/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.model;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.ServerTreeView;
import com.avaya.eclipse.plugin.model.ElementInfo;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ServerLabelProvider
implements ILabelProvider {
    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        return this.getImageFromAccess(element);
    }

    public Image getImageFromAccess(Object element) {
        ServerTreeView.Node treeNode = (ServerTreeView.Node)element;
        ElementInfo ei = treeNode.getElementInfo();
        int r = 255;
        int g = 0;
        try {
            int n = r = ei.isValidated() ? 0 : 255;
            if (r == 0) {
                g = 255;
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error validating object", e);
        }
        Image image = null;
        switch (ei.getServerType()) {
            case SMGR: 
            case CE: {
                image = new Image(null, 16, 16);
                GC gc = new GC((Drawable)image);
                gc.setBackground(new Color(null, r, g, 0));
                gc.fillOval(0, 0, 16, 16);
                gc.dispose();
                break;
            }
            case CLUSTER: {
                image = new Image(null, 16, 16);
                GC gc = new GC((Drawable)image);
                gc.setBackground(new Color(null, 0, 255, 0));
                gc.fillOval(0, 0, 16, 16);
                gc.dispose();
                break;
            }
        }
        return image;
    }

    public String getText(Object element) {
        ServerTreeView.Node treeNode = (ServerTreeView.Node)element;
        ElementInfo ei = treeNode.getElementInfo();
        switch (ei.getServerType()) {
            case CE: {
                return ei.getName() + " (" + ei.getIp() + ")";
            }
            case SMGR: {
                return "SMGR (" + ei.getIp() + ")";
            }
            case CLUSTER: {
                return ei.getName() != null ? ei.getName() : ei.getIp();
            }
        }
        return ei.getIp();
    }

    public void dispose() {
    }
}

