/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.CallHistoryAPI;
import com.avaya.asm.datamgr.dao.CallHistoryDAO;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CallHistoryKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public class CallHistoryDM
implements CallHistoryAPI {
    private final Logger log = AsmLogger.getLogger(CallHistoryDM.class);
    private CassandraDAOFactory<CallHistoryDAO> callHistoryDAOFactory = new CassandraDAOFactory();
    private CassandraConnectionInfo cConnInfo = null;
    protected final SortByTimestampComparator sorter = new SortByTimestampComparator();

    public CallHistoryDM(CassandraConnectionInfo cConnInfo) {
        this.cConnInfo = cConnInfo;
    }

    public CallHistoryDM() {
    }

    @Override
    public void addCallHistory(CallHistoryKey key, Integer maxLogs, List<CallLog> callLogs) throws DMException {
        long endTime;
        String fcn_name = "addCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("addCallHistory: enter with key=" + key + ", maxLog=" + maxLogs + ", callLogs.size()=" + callLogs.size()));
        }
        if (key == null) {
            this.log.warn((Object)"addCallHistory: key was null ");
            return;
        }
        List<UUID> deleteUuids = null;
        int numToDelete = 0;
        CallHistoryDAO dao = this.getCallHistoryDAO();
        if (maxLogs != null) {
            if (maxLogs <= 0) {
                throw new IllegalArgumentException("maxLogs is <= 0: " + maxLogs);
            }
            if (isFinest) {
                startTime = System.currentTimeMillis();
            }
            List<UUID> allUuids = dao.getCallLogIds(key);
            if (isFinest) {
                endTime = System.currentTimeMillis();
                this.log.finest((Object)("addCallHistory: dao.getCallLogIds took " + (endTime - startTime) + "ms, allUuids.size=" + allUuids.size()));
            }
            if (allUuids.size() > 0) {
                numToDelete = allUuids.size() + callLogs.size() - maxLogs;
                if (numToDelete > 0) {
                    deleteUuids = allUuids.subList(0, numToDelete);
                }
            } else if (isFinest) {
                this.log.finest((Object)("addCallHistory: The Cassandra DB is empty so no existing call logs will be deleted from it for: " + key));
            }
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
            this.log.finest((Object)("addCallHistory: We will now update the call logs for: " + key));
        }
        dao.updateCallLogs(key, deleteUuids, callLogs);
        if (isFinest) {
            endTime = System.currentTimeMillis();
            this.log.finest((Object)("addCallHistory: dao.updateCallLogs took " + (endTime - startTime) + "ms, deleteUuids.size=" + (deleteUuids != null ? deleteUuids.size() : -1)));
        }
        if (isFiner) {
            this.log.finer((Object)"addCallHistory: leave");
        }
    }

    @Override
    public void deleteCallHistoryById(CallHistoryKey key, List<UUID> callLogUuids) throws DMException {
        CallHistoryDAO dao = this.getCallHistoryDAO();
        dao.deleteCallLogs(key, callLogUuids);
    }

    @Override
    public void deleteCallHistoryByLimit(CallHistoryKey key, int maxLogs) throws DMException {
        String fcn_name = "deleteCallHistoryByLimit";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteCallHistoryByLimit: enter with key=" + key + ", maxLogs=" + maxLogs));
        }
        if (key == null) {
            this.log.warn((Object)"deleteCallHistoryByLimit: key was null ");
            return;
        }
        CallHistoryDAO dao = this.getCallHistoryDAO();
        if (maxLogs == 0) {
            dao.deleteAllCallLogs(key);
        } else {
            List<UUID> deleteUuids = null;
            List<UUID> allUuids = dao.getCallLogIds(key);
            int numToDelete = allUuids.size() - maxLogs;
            if (numToDelete > 0) {
                deleteUuids = allUuids.subList(0, numToDelete);
                dao.deleteCallLogs(key, deleteUuids);
            }
        }
        if (isFiner) {
            this.log.finer((Object)"deleteCallHistoryByLimit: leave");
        }
    }

    @Override
    public List<CallLog> getCallHistory(CallHistoryKey key, Integer maxLogs) throws DMException {
        String fcn_name = "getCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: enter with key =" + key + ", maxLogs=" + maxLogs));
        }
        if (key == null) {
            this.log.warn((Object)"getCallHistory: key was null ");
            return null;
        }
        CallHistoryDAO dao = this.getCallHistoryDAO();
        List<CallLog> allCallLogs = dao.getCallHistory(key, maxLogs);
        if (isFinest) {
            this.log.finest((Object)("getCallHistory: DB returned callLogs.size()=" + allCallLogs.size()));
        }
        List<CallLog> trimmedCallLogs = this.removeDuplicateCallHistoryRecords(key, allCallLogs);
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: leave, trimmed callLogs.size()=" + trimmedCallLogs.size()));
        }
        return trimmedCallLogs;
    }

    @Override
    public void moveCallHistory(CallHistoryKey oldKey, CallHistoryKey newKey) throws DMException {
        String fcn_name = "moveCallHistory";
        if (oldKey.equals(newKey)) {
            return;
        }
        List<CallLog> callLogList = this.getCallHistory(oldKey, 100);
        if (callLogList != null && !callLogList.isEmpty()) {
            this.addCallHistory(newKey, 100, callLogList);
            this.deleteAllCallHistory(oldKey);
        } else {
            this.log.finest((Object)("moveCallHistory: Tried to move the user's Call Logs, but no call logs were found for oldCallHistoryKeyInfo: " + oldKey));
        }
    }

    @Override
    public void deleteAllCallHistory(CallHistoryKey key) throws DMException {
        this.deleteCallHistoryByLimit(key, 0);
    }

    protected CallHistoryDAO getCallHistoryDAO() throws DMException {
        String fcn_name = "getCallHistoryDAO";
        CallHistoryDAO dao = this.callHistoryDAOFactory.getDAOInstance(this.cConnInfo, CallHistoryDAO.class);
        if (dao == null) {
            String msg = "getCallHistoryDAO: getDAOInstance failed, cConnInfo=" + this.cConnInfo;
            this.log.error((Object)msg);
            throw new DMException(msg);
        }
        return dao;
    }

    @Override
    public void getSetIdsForKeyspace(UserStoreKeyspace keyspace, CassandraConnectionInfo cConnInfo, Collection<Long> ids) throws DMException {
        CallHistoryDAO dao = this.getCallHistoryDAO();
        dao.getSetIdsForKeyspace(keyspace, cConnInfo, ids);
    }

    @Override
    public List<CallLog> removeDuplicateCallHistoryRecords(CallHistoryKey key, List<CallLog> callLogsFromDb) throws DMException {
        String fcn_name = "removeDuplicateCallHistoryRecords";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        ArrayList<UUID> uuidsToDelete = null;
        if (isFiner) {
            this.log.finer((Object)("removeDuplicateCallHistoryRecords: Enter with Call History Key: " + key + " and callLogsfromDB size: " + callLogsFromDb.size()));
        }
        Collections.sort(callLogsFromDb, this.sorter);
        block0: for (int i = 0; i < callLogsFromDb.size() - 1; ++i) {
            CallLog currentCallLog = callLogsFromDb.get(i);
            if (isFinest) {
                this.log.finest((Object)("removeDuplicateCallHistoryRecords: callLog from the DB #" + i + ": " + currentCallLog));
            }
            int j = i + 1;
            while (j < callLogsFromDb.size()) {
                CallLog compareCallLog = callLogsFromDb.get(j);
                if (isFinest) {
                    this.log.finest((Object)("removeDuplicateCallHistoryRecords: callLog from the DB #" + j + ": " + compareCallLog + " to compare with the previous call log to see if it's a duplicate or not."));
                }
                if (compareCallLog.getTimestamp() - currentCallLog.getTimestamp() > 5000L) {
                    if (!isFinest) continue block0;
                    this.log.finest((Object)"removeDuplicateCallHistoryRecords: The timestamps of the call Logs are more than 5 seconds apart, move onto the next one.");
                    continue block0;
                }
                if (currentCallLog.isDuplicateCallLogByFieldEquality(compareCallLog)) {
                    if (isFinest) {
                        this.log.finest((Object)"removeDuplicateCallHistoryRecords: Found callLog to remove because it's a duplicate.");
                    }
                    if (uuidsToDelete == null) {
                        uuidsToDelete = new ArrayList<UUID>();
                    }
                    if (currentCallLog.getDialogId() == null && compareCallLog.getDialogId() != null) {
                        uuidsToDelete.add(currentCallLog.getUUID());
                        callLogsFromDb.remove(i);
                        continue;
                    }
                    if (currentCallLog.getDialogId() != null && compareCallLog.getDialogId() == null) {
                        uuidsToDelete.add(compareCallLog.getUUID());
                        callLogsFromDb.remove(j);
                        continue;
                    }
                    uuidsToDelete.add(compareCallLog.getUUID());
                    callLogsFromDb.remove(j);
                    continue;
                }
                ++j;
                if (!isFinest) continue;
                this.log.finest((Object)"removeDuplicateCallHistoryRecords: The two call logs we just compared don't match, so the callLogsfromDB size remains the same. ");
            }
        }
        if (isFinest) {
            this.log.finest((Object)("removeDuplicateCallHistoryRecords: Final callLogsfromDB size: " + callLogsFromDb.size()));
        }
        if (uuidsToDelete != null && !uuidsToDelete.isEmpty()) {
            if (isFinest) {
                this.log.finest((Object)("removeDuplicateCallHistoryRecords: uuidsToDelete size: " + uuidsToDelete.size()));
            }
            this.deleteCallHistoryById(key, (List<UUID>)uuidsToDelete);
        }
        if (isFiner) {
            this.log.finer((Object)"removeDuplicateCallHistoryRecords: Leaving");
        }
        return callLogsFromDb;
    }

    class SortByTimestampComparator
    implements Comparator<CallLog> {
        SortByTimestampComparator() {
        }

        @Override
        public int compare(CallLog callLog1, CallLog callLog2) {
            Long clTimestamp2;
            Long clTimestamp1 = callLog1.getTimestamp();
            if (clTimestamp1.equals(clTimestamp2 = Long.valueOf(callLog2.getTimestamp()))) {
                return 0;
            }
            if (clTimestamp1 < clTimestamp2) {
                return -1;
            }
            return 1;
        }
    }
}

