/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.LocalSettings;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.LoadRulesHandler;
import com.avaya.asm.datamgr.ReadWriteLockHandler;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.DaoConnectionPool;
import com.avaya.asm.datamgr.dao.jdbc.JDBCBasedDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationListener;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.loadrules.DataMgrLoadRules;
import com.avaya.asm.datamgr.objectapi.WeakHashSet;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.client.UserStoreFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class DMFactory {
    private static Logger log = AsmLogger.getLogger(DMFactory.class);
    private JDBCBasedDAO dataSourceAsm = null;
    private JDBCBasedDAO dataSourceAsmLocal = null;
    private static volatile DMFactory myInstance = null;
    private static boolean tryJndi = true;
    private LoadRulesHandler loadRulesHandler = new LoadRulesHandler();
    private WeakHashMap<Object, String> classLoaders = new WeakHashMap();
    private Map<String, Object> ignoredClassLoaders = new HashMap<String, Object>();
    private WeakHashMap<String, String> classLoaderNames = new WeakHashMap();
    private WeakHashMap<String, Set<DataMgr>> applicationDataMgrs = new WeakHashMap();
    private ReadWriteLockHandler classLoaderMapsLock = new ReadWriteLockHandler("DMFactory classLoaderMaps");
    private volatile WeakHashMap<Class<? extends DataMgr>, WeakReference<DataMgr>> dmMap = new WeakHashMap();
    private ReadWriteLockHandler dmMapLock = new ReadWriteLockHandler("DMFactory dmMapLock");
    private volatile Map<DMListener, Set<DataMgr>> listenerMap = new WeakHashMap<DMListener, Set<DataMgr>>();
    private ReadWriteLockHandler listenerMapLock = new ReadWriteLockHandler("DMFactory listenerMapLock");
    private final WeakHashSet<Class<? extends DataAccessObject>> allDAO = new WeakHashSet();
    private boolean shutDown = false;
    private Set<DataMgr> permanentDMs = new HashSet<DataMgr>();
    private Map<String, Long> warnedClassLoaders = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DMFactory getInstance() {
        if (myInstance != null) return myInstance;
        Class<DMFactory> clazz = DMFactory.class;
        synchronized (DMFactory.class) {
            if (myInstance != null) return myInstance;
            if (tryJndi) {
                try {
                    InitialContext ctx = new InitialContext();
                    myInstance = (DMFactory)ctx.lookup("DMFactory");
                    log.info((Object)"Using JNDI instance for DMFactory");
                }
                catch (NamingException e) {
                    log.fine((Object)"Unable to find binding for DMFactory - if this is not a bootstrapping application, this is an error");
                }
                catch (Exception e) {
                    log.error((Object)"getInstance: Unexpected error", (Throwable)e);
                }
            }
            if (myInstance != null) return myInstance;
            log.info((Object)"Creating DMFactory");
            myInstance = new DMFactory();
            myInstance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return myInstance;
        }
    }

    private DMFactory() {
    }

    protected void init() {
        if (!AsmCommon.jUnitEnvironment) {
            GenericAlarmHandler.create();
        }
    }

    private void initJDBCBasedDAO() {
        block7: {
            DaoConnectionPool pool;
            block6: {
                if (this.dataSourceAsmLocal == null) {
                    try {
                        pool = new DaoConnectionPool();
                        pool.setUrl("jdbc:postgresql://localhost/asmlocal");
                        pool.setUser("asm");
                        pool.setPassword("asm");
                        pool.setRetries(2);
                        pool.setQueryTimeout(10000);
                        pool.setPoolSize(3);
                        pool.setDriverClass("org.postgresql.Driver");
                        this.dataSourceAsmLocal = new JDBCBasedDAO();
                        this.dataSourceAsmLocal.setConnectionPool(pool);
                        this.dataSourceAsmLocal.setQueryRetries(LocalSettings.getDatabaseRetries().intValue());
                        this.dataSourceAsmLocal.setQueryTimeout(LocalSettings.getDatabaseTimeout().intValue());
                    }
                    catch (DMException e) {
                        log.fatal((Object)"Failed creating DaoConnectionPool for ASMLOCAL", (Throwable)e);
                        if (this.dataSourceAsmLocal == null) break block6;
                        this.dataSourceAsmLocal.shutdown();
                        this.dataSourceAsmLocal = null;
                    }
                }
            }
            if (this.dataSourceAsm == null) {
                try {
                    pool = new DaoConnectionPool();
                    pool.setUrl("jdbc:postgresql://localhost/asm?ssl");
                    pool.setUser("asm");
                    pool.setPassword("asm");
                    pool.setRetries(2);
                    pool.setQueryTimeout(10000);
                    pool.setPoolSize(5);
                    pool.setDriverClass("org.postgresql.Driver");
                    this.dataSourceAsm = new JDBCBasedDAO();
                    this.dataSourceAsm.setConnectionPool(pool);
                    this.dataSourceAsm.setQueryRetries(LocalSettings.getDatabaseRetries().intValue());
                    this.dataSourceAsm.setQueryTimeout(LocalSettings.getDatabaseTimeout().intValue());
                }
                catch (DMException e) {
                    log.fatal((Object)"Failed creating DaoConnectionPool for ASM", (Throwable)e);
                    if (this.dataSourceAsm == null) break block7;
                    this.dataSourceAsm.shutdown();
                    this.dataSourceAsm = null;
                }
            }
        }
    }

    public synchronized JDBCBasedDAO getDataSource() {
        if (this.dataSourceAsm == null) {
            this.initJDBCBasedDAO();
        }
        return this.dataSourceAsm;
    }

    public synchronized JDBCBasedDAO getLocalDataSource() {
        if (this.dataSourceAsmLocal == null) {
            this.initJDBCBasedDAO();
        }
        return this.dataSourceAsmLocal;
    }

    public LoadRulesHandler getLoadRules() {
        return this.loadRulesHandler;
    }

    public WeakHashMap<Object, String> getClassLoaders() {
        return this.classLoaders;
    }

    public Map<String, Object> getIgnoredClassLoaders() {
        return this.ignoredClassLoaders;
    }

    public WeakHashMap<String, Set<DataMgr>> getApplicationDataMgrs() {
        return this.applicationDataMgrs;
    }

    public void addIgnoredClassLoader(String classLoaderId, Object ignoredObject) {
        this.classLoaderMapsLock.acquireWriteLock();
        try {
            if (this.ignoredClassLoaders.get(classLoaderId) == null || !this.ignoredClassLoaders.get(classLoaderId).equals(ignoredObject)) {
                log.info((Object)("registerIgnoredCL: Adding to ignored CL tracking: " + ignoredObject + ": " + DMUtilities.getCurrentThreadCLName() + "(" + classLoaderId + ")"));
                this.ignoredClassLoaders.put(classLoaderId, ignoredObject);
                this.classLoaderNames.put(classLoaderId, DMUtilities.getCurrentThreadCLName());
            }
        }
        finally {
            this.classLoaderMapsLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object registrationObject) {
        if (log.isFineEnabled()) {
            log.fine((Object)("register: registrationObject=" + registrationObject));
        }
        if (registrationObject == null) {
            log.warn((Object)"Cannot register a null object!");
            return;
        }
        String classLoaderId = DMUtilities.getCurrentThreadIdentity(null);
        this.classLoaderMapsLock.acquireWriteLock();
        try {
            if (this.classLoaders.containsKey(registrationObject)) {
                log.info((Object)"register: Object already registered with DMFactory.  Note this only needs to be done once.");
                return;
            }
            if (this.ignoredClassLoaders.containsKey(classLoaderId)) {
                log.warn((Object)("Class loader stored as an ignored CL.  Overriding: " + this.classLoaderNames.get(classLoaderId) + "(" + classLoaderId + ") for " + DMUtilities.getCurrentThreadCLName() + "(" + this.ignoredClassLoaders.get(classLoaderId) + ")"));
                this.ignoredClassLoaders.remove(classLoaderId);
                this.classLoaderNames.remove(classLoaderId);
            }
            if (this.applicationDataMgrs.containsKey(classLoaderId)) {
                boolean isCollision = true;
                for (Map.Entry<Object, String> e : this.classLoaders.entrySet()) {
                    if (!classLoaderId.equals(e.getValue()) || e.getKey().getClass().getClassLoader() != registrationObject.getClass().getClassLoader()) continue;
                    log.info((Object)("Class loader already tracked - it is not necessary to register more than once per application.  This is for '" + registrationObject + "', duplicate class loader found for '" + e.getKey() + "'"));
                    isCollision = false;
                    break;
                }
                if (isCollision) {
                    log.warn((Object)("Detected a collision in the application map for (" + classLoaderId + ")!  Dynamic tracking of the internal cache may be effected, please restart your system at the earliest convenience."));
                }
            }
            this.classLoaders.put(registrationObject, classLoaderId);
            this.applicationDataMgrs.put(classLoaderId, new HashSet());
            this.classLoaderNames.put(classLoaderId, DMUtilities.getCurrentThreadCLName());
        }
        finally {
            this.classLoaderMapsLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<DataMgr> getSingleReferencedDMs(String classLoaderId) {
        HashSet<DataMgr> dataMgrs = new HashSet<DataMgr>();
        this.classLoaderMapsLock.acquireReadLock();
        try {
            Set<DataMgr> allDataMgrs = this.applicationDataMgrs.get(classLoaderId);
            if (allDataMgrs == null) {
                HashSet<DataMgr> hashSet = dataMgrs;
                return hashSet;
            }
            dataMgrs.addAll(allDataMgrs);
            for (Map.Entry<String, Set<DataMgr>> entry : this.applicationDataMgrs.entrySet()) {
                if (classLoaderId.equals(entry.getKey())) continue;
                for (DataMgr dm : entry.getValue()) {
                    if (log.isFineEnabled()) {
                        log.fine((Object)("getSingleReferencedDMs: Skipping " + dm + ": Still shared with " + this.classLoaderNames.get(entry.getKey()) + " (" + classLoaderId + ")"));
                    }
                    dataMgrs.remove(dm);
                }
            }
        }
        finally {
            this.classLoaderMapsLock.releaseReadLock();
        }
        return dataMgrs;
    }

    protected WeakHashSet<DataAccessObject> getDAOsByClassLoader(ClassLoader cl) {
        Set<DataMgr> dms = this.getDMsByClassLoader(cl);
        if (dms == null) {
            return null;
        }
        WeakHashSet<DataAccessObject> daos = new WeakHashSet<DataAccessObject>();
        for (DataMgr dm : dms) {
            if (!(dm instanceof DataAccessObject)) continue;
            daos.add((DataAccessObject)dm);
        }
        return daos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<DataMgr> getDMsByClassLoader(ClassLoader classLoader) {
        String classLoaderId = DMUtilities.getCurrentThreadIdentity(classLoader);
        if (classLoaderId == null) {
            return new HashSet<DataMgr>();
        }
        Set<DataMgr> dataMgrs = null;
        this.classLoaderMapsLock.acquireReadLock();
        try {
            dataMgrs = this.applicationDataMgrs.get(classLoaderId);
        }
        finally {
            this.classLoaderMapsLock.releaseReadLock();
        }
        if (dataMgrs != null) {
            return Collections.unmodifiableSet(dataMgrs);
        }
        return new HashSet<DataMgr>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegister() {
        this.classLoaderMapsLock.acquireWriteLock();
        try {
            String classLoaderId = DMUtilities.getCurrentThreadIdentity(null);
            log.info((Object)("Shutting down all DataMgrs for " + this.classLoaderNames.get(classLoaderId)));
            Set<DataMgr> dataMgrs = this.getSingleReferencedDMs(classLoaderId);
            if (log.isFineEnabled()) {
                log.fine((Object)("The DataMgrs to destroy are: " + dataMgrs));
            }
            if (dataMgrs != null) {
                for (DataMgr dataMgr : dataMgrs) {
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("Destroying: " + dataMgr.getClass().getSimpleName()));
                    }
                    try {
                        if (dataMgr == null) continue;
                        dataMgr.destroy();
                    }
                    catch (Exception e) {
                        log.error((Object)"Exception during per application shutdown", (Throwable)e);
                    }
                }
            }
            GenericAlarmHandler.shutdownByApp();
            DataDistLayerFactory.getInstance().destroyListeners(Thread.currentThread().getContextClassLoader());
            this.applicationDataMgrs.remove(classLoaderId);
        }
        finally {
            this.classLoaderMapsLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegister(Class<? extends DataMgr> clazz) {
        List<Class<? extends DataMgr>> dmList = this.getAllDMEntriesforDM(clazz);
        if (dmList == null) {
            log.error((Object)("Could not get any entries for class: " + clazz));
            return;
        }
        List<WeakReference<DataMgr>> references = this.getAllDMWeakReferences(clazz, dmList);
        if (references == null) {
            log.error((Object)("Could not get any references for class: " + clazz));
        }
        this.classLoaderMapsLock.acquireWriteLock();
        try {
            for (WeakReference<DataMgr> reference : references) {
                DataMgr dm = (DataMgr)reference.get();
                log.info((Object)("Removing DM: " + dm));
                if (dm == null) continue;
                for (Map.Entry<String, Set<DataMgr>> entry : this.applicationDataMgrs.entrySet()) {
                    Set<DataMgr> set = entry.getValue();
                    set.remove(dm);
                }
                try {
                    dm.destroy();
                }
                catch (Exception e) {
                    log.error((Object)"Exception during dm shutdown. ", (Throwable)e);
                }
                this.allDAO.removeAll(dmList);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception thrown on DM unregister. ", (Throwable)e);
            this.allDAO.removeAll(dmList);
        }
        finally {
            this.classLoaderMapsLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<? extends DataMgr>> getAllDMEntriesforDM(Class<? extends DataMgr> clazz) {
        ArrayList<Class<? extends DataMgr>> dmList = new ArrayList<Class<? extends DataMgr>>();
        this.dmMapLock.acquireWriteLock();
        try {
            CopyOnWriteArraySet<Class<? extends DataMgr>> dmSet = new CopyOnWriteArraySet<Class<? extends DataMgr>>(this.dmMap.keySet());
            for (Class<? extends DataMgr> dmEntry : dmSet) {
                if (!dmEntry.getName().equalsIgnoreCase(clazz.getName())) continue;
                dmList.add(dmEntry);
            }
            ArrayList<Class<? extends DataMgr>> arrayList = dmList;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)"Exception on getting all the instances of registered DM. ", (Throwable)e);
            List<Class<? extends DataMgr>> list = null;
            return list;
        }
        finally {
            this.dmMapLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WeakReference<DataMgr>> getAllDMWeakReferences(Class<? extends DataMgr> clazz, List<Class<? extends DataMgr>> dmList) {
        ArrayList<WeakReference<DataMgr>> weakRefList = new ArrayList<WeakReference<DataMgr>>();
        this.dmMapLock.acquireWriteLock();
        try {
            for (Class<? extends DataMgr> dmEntry : dmList) {
                weakRefList.add(this.dmMap.remove(dmEntry));
            }
            ArrayList<WeakReference<DataMgr>> arrayList = weakRefList;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)"Exception on getting references for the registered DM. ", (Throwable)e);
            List<WeakReference<DataMgr>> list = null;
            return list;
        }
        finally {
            this.dmMapLock.releaseWriteLock();
        }
    }

    protected synchronized void shutdownFactory() {
        log.info((Object)"DMFactory shutting down");
        this.shutDown = true;
        if (!AsmCommon.jUnitEnvironment) {
            DataDistLayerFactory.getInstance().destroy();
        }
        log.info((Object)"Shutting down all DataMgrs");
        for (WeakReference<DataMgr> weakDm : this.dmMap.values()) {
            DataMgr dm = (DataMgr)weakDm.get();
            if (dm == null) continue;
            dm.destroy();
        }
        if (this.dataSourceAsm != null) {
            this.dataSourceAsm.shutdown();
        }
        if (this.dataSourceAsmLocal != null) {
            this.dataSourceAsmLocal.shutdown();
        }
        UserStoreFactory.destroy();
        this.dataSourceAsm = null;
        this.dataSourceAsmLocal = null;
        GenericAlarmHandler.shutdown();
        this.classLoaders = null;
        this.ignoredClassLoaders = null;
        this.classLoaderNames = null;
        this.applicationDataMgrs = null;
        this.dmMap = null;
        this.warnedClassLoaders = null;
        myInstance = null;
        log.info((Object)"DMFactory is now shut down.");
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    protected void finalize() {
        log.info((Object)"Called finalize() on DMFactory");
        this.shutdownFactory();
    }

    public void registerIgnoredCL(Object registeredObj, Properties properties) {
        if (log.isFineEnabled()) {
            log.fine((Object)("registerIgnoredCL: registeredObj=" + registeredObj + " properties=" + properties));
        }
        this.loadRulesHandler.setLoadRules(this.registerIgnoredCL(registeredObj), properties);
    }

    public String registerIgnoredCL(Object ignoredObject) {
        String clId = DMUtilities.getCurrentThreadIdentity(null);
        this.addIgnoredClassLoader(clId, ignoredObject);
        return clId;
    }

    public void register(Object registrationObject, Properties properties) {
        this.register(registrationObject);
        this.classLoaderMapsLock.acquireReadLock();
        try {
            this.loadRulesHandler.setLoadRules(this.classLoaders.get(registrationObject), properties);
        }
        finally {
            this.classLoaderMapsLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder warnUntrackedClassloader(String clId, String appName, Class<? extends DataMgr> clazz) {
        boolean logWarning = false;
        Map<String, Long> map = this.warnedClassLoaders;
        synchronized (map) {
            if (!this.warnedClassLoaders.containsKey(clId) || this.warnedClassLoaders.get(clId) + 3600000L < System.currentTimeMillis()) {
                this.warnedClassLoaders.put(clId, System.currentTimeMillis());
                logWarning = true;
            }
        }
        if (logWarning) {
            StringBuilder logStatement = new StringBuilder("Calling component not registered with the DMFactory: ClassLoader Name=" + appName + "(" + clId + ").  Not tracking '" + clazz.getSimpleName() + "' against this Class loader.");
            this.dmMapLock.acquireReadLock();
            try {
                if (this.dmMap.containsKey(clazz)) {
                    logStatement.append(" However, requested DataMgr IS currently tracked under a DIFFERENT Class Loader.");
                } else {
                    logStatement.append(" Requested DataMgr is NOT currently tracked under a different Class Loader, so this will cause a performance problem due to frequent reinitializations.");
                }
            }
            finally {
                this.dmMapLock.releaseReadLock();
            }
            return logStatement;
        }
        return null;
    }

    public DataMgr getDataMgr(Class<? extends DataMgr> clazz) {
        return this.getDataMgr(clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public DataMgr getDataMgr(Class<? extends DataMgr> clazz, boolean createIfNotExist) {
        if (clazz == null) {
            DMFactory.log.warn((Object)("Attempted to retrieve non-DataMgr object " + clazz + " from DMFactory"));
            return null;
        }
        classLoaderId = DMUtilities.getCurrentThreadIdentity(null);
        appDMs = null;
        appName = null;
        this.classLoaderMapsLock.acquireReadLock();
        try {
            appDMs = this.applicationDataMgrs.get(classLoaderId);
            appName = this.classLoaderNames.get(classLoaderId);
            if (appDMs == null && !this.ignoredClassLoaders.containsKey(classLoaderId) && (logStatement = this.warnUntrackedClassloader(classLoaderId, appName, clazz)) != null) {
                logStatement.append(" Class loader IDs stored in appMap:");
                for (Map.Entry<String, Set<DataMgr>> entry : this.applicationDataMgrs.entrySet()) {
                    logStatement.append(" " + entry.getKey());
                }
                DMFactory.log.warn((Object)logStatement.toString(), new Throwable());
            }
        }
        finally {
            this.classLoaderMapsLock.releaseReadLock();
        }
        this.dmMapLock.acquireReadLock();
        weakCurDM = this.dmMap.get(clazz);
        v0 = curDM = weakCurDM == null ? null : (DataMgr)weakCurDM.get();
        if (curDM == null) {
            if (createIfNotExist) {
                this.dmMapLock.releaseReadLock();
                this.dmMapLock.acquireWriteLock();
                try {
                    weakCurDM = this.dmMap.get(clazz);
                    if (weakCurDM == null || weakCurDM.get() == null) {
                        if (DMFactory.log.isFineEnabled() && weakCurDM != null && !clazz.getSimpleName().contains("Debug")) {
                            DMFactory.log.fine((Object)("DataMgr class was GCed prior to application getting GCed.  Recreating anyway: " + clazz.getSimpleName()));
                        }
                        if ((curDM = this.createDM(clazz)) == null) {
                            entry = null;
                            return entry;
                        }
                        weakCurDM = new WeakReference<DataMgr>(curDM);
                        this.dmMap.put(clazz, weakCurDM);
                        if (curDM.getClass().equals(clazz)) ** GOTO lbl62
                        this.dmMap.put(curDM.getClass(), weakCurDM);
                        DMFactory.log.finest((Object)("Added second DM entry for custom load rule: " + curDM.getClass() + " (requested=" + clazz.getSimpleName() + ")"));
                    }
                    if (DMFactory.log.isFinerEnabled()) {
                        DMFactory.log.finer((Object)(clazz.getSimpleName() + " was just added to dmMaps, using this newly added instance now"));
                    }
                    curDM = (DataMgr)weakCurDM.get();
                }
                finally {
                    this.dmMapLock.releaseWriteLock();
                }
            } else {
                this.dmMapLock.releaseReadLock();
                if (DMFactory.log.isFinerEnabled()) {
                    append = " doesn't exist and won't create.";
                    if (weakCurDM != null) {
                        append = " has been GCed - will not recreate and hence returning null";
                    }
                    DMFactory.log.finer((Object)("getDataMgr: " + clazz.getSimpleName() + append));
                }
            }
        } else {
            this.dmMapLock.releaseReadLock();
        }
lbl62:
        // 5 sources

        if (appDMs != null && curDM != null) {
            if (DMFactory.log.isFinestEnabled() && !appDMs.contains(curDM)) {
                DMFactory.log.finest((Object)("getDataMgr: Adding " + clazz.getSimpleName() + " to be tracked under " + appName));
            }
            appDMs.add(curDM);
        }
        if (curDM == null) {
            return null;
        }
        try {
            if (curDM.uninitialized() && curDM.shouldInit()) {
                if (curDM instanceof DataAccessObject) {
                    if ("jdbc:postgresql://localhost/asm?ssl".equals(((DataAccessObject)curDM).getDBURL())) {
                        ((DataAccessObject)curDM).setDataSource(this.getDataSource());
                    } else {
                        ((DataAccessObject)curDM).setDataSource(this.getLocalDataSource());
                    }
                    if (!this.allDAO.contains(clazz)) {
                        curDM.init();
                        this.allDAO.add(clazz);
                        DAOReplicationListener.getInstance().updateEventTables(clazz);
                    } else {
                        curDM.reinit();
                    }
                } else {
                    curDM.init();
                }
            }
        }
        catch (Exception e) {
            DMFactory.log.error((Object)("Error encountered (re)initializing " + clazz), (Throwable)e);
        }
        return curDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataMgr createDM(Class<? extends DataMgr> clazz) {
        try {
            if (!this.loadRulesHandler.isInitialized()) {
                String classLoaderId = this.getActualCLIdentity(DMUtilities.getCurrentThreadIdentity(null));
                if (log.isFineEnabled()) {
                    log.fine((Object)("createDM setting default load rules clazz=" + clazz));
                }
                this.loadRulesHandler.setDefaultLoadRules(classLoaderId, DMUtilities.isBranch());
            }
            boolean setLoadRules = false;
            Class<? extends DataMgr> requested = clazz;
            DataMgrLoadRules dataMgrLoadRules = this.loadRulesHandler.getLoadRules(clazz);
            DataMgr dm = null;
            if (dataMgrLoadRules != null) {
                try {
                    DataMgr existingDM;
                    String dataMgrImplementationClass = dataMgrLoadRules.getDataMgrImplementationClass();
                    if (dataMgrImplementationClass != null) {
                        clazz = this.getDMClass(dataMgrImplementationClass);
                    }
                    WeakReference<DataMgr> weakDM = null;
                    this.dmMapLock.acquireReadLock();
                    try {
                        weakDM = this.dmMap.get(clazz);
                    }
                    finally {
                        this.dmMapLock.releaseReadLock();
                    }
                    if (weakDM != null && (existingDM = (DataMgr)weakDM.get()) != null) {
                        dm = existingDM;
                    }
                    setLoadRules = true;
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to retrieve custom load rule for: " + requested));
                    clazz = requested;
                    setLoadRules = false;
                }
            }
            if (dm == null) {
                log.info((Object)("createDM: Creating class: " + clazz.getSimpleName()));
                dm = clazz.newInstance();
            }
            if (dataMgrLoadRules != null && setLoadRules) {
                dm.setLoadRules(dataMgrLoadRules.getLoadRules().values());
            }
            return dm;
        }
        catch (Exception e) {
            log.fatal((Object)("Failed instantiating requested '" + clazz.getSimpleName() + "'"), (Throwable)e);
            return null;
        }
    }

    public Set<Class<? extends DataAccessObject>> getAllDAOClasses() {
        return new HashSet<Class<? extends DataAccessObject>>(this.allDAO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Class<? extends DataMgr>, DataMgr> getAllDataMgrs() {
        HashMap<Class<? extends DataMgr>, DataMgr> allDataMgrs = new HashMap<Class<? extends DataMgr>, DataMgr>();
        this.dmMapLock.acquireReadLock();
        try {
            for (Map.Entry<Class<? extends DataMgr>, WeakReference<DataMgr>> dm : this.dmMap.entrySet()) {
                DataMgr curDm = (DataMgr)dm.getValue().get();
                if (curDm == null) continue;
                allDataMgrs.put(dm.getKey(), curDm);
            }
        }
        finally {
            this.dmMapLock.releaseReadLock();
        }
        return allDataMgrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPermanentDM(DataMgr dm) {
        if (dm != null) {
            if (log.isFineEnabled()) {
                log.fine((Object)("Created permanent DM: " + dm.getClass().getSimpleName()));
            }
            Set<DataMgr> set = this.permanentDMs;
            synchronized (set) {
                this.permanentDMs.add(dm);
            }
        }
    }

    protected Class<? extends DataMgr> getDMClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                if (log.isFineEnabled()) {
                    log.fine((Object)("getDMClass() caught ClassNotFoundException for " + className + "; retrying with context classloader"));
                }
                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e2) {
                log.warn((Object)("Tried to resolve " + className + "; caught exception " + e2));
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getActualCLIdentity(String clId) {
        String actualClId = null;
        this.classLoaderMapsLock.acquireReadLock();
        try {
            for (String o : this.classLoaders.values()) {
                if (!o.equals(clId)) continue;
                actualClId = o;
            }
            if (actualClId == null) {
                for (String o : this.ignoredClassLoaders.keySet()) {
                    if (!o.equals(clId)) continue;
                    actualClId = o;
                }
            }
        }
        finally {
            this.classLoaderMapsLock.releaseReadLock();
        }
        if (actualClId == null && clId != null) {
            return clId;
        }
        return actualClId;
    }

    public boolean isContainerProcess() {
        return DataDistLayerFactory.getInstance().isLeader();
    }

    public static void setTryJndi(boolean tryJndi) {
        DMFactory.tryJndi = tryJndi;
    }

    public String getAppNameForCLIdentity(String clId) {
        this.classLoaderMapsLock.acquireReadLock();
        try {
            String string = this.classLoaderNames.get(clId);
            return string;
        }
        finally {
            this.classLoaderMapsLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(DMListener listener, DataMgr dm) {
        this.listenerMapLock.acquireWriteLock();
        try {
            Set<DataMgr> set = this.listenerMap.get(listener);
            if (set == null) {
                set = new HashSet<DataMgr>();
                this.listenerMap.put(listener, set);
            }
            set.add(dm);
        }
        finally {
            this.listenerMapLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DMListener listener, DataMgr dm) {
        this.listenerMapLock.acquireWriteLock();
        try {
            Set<DataMgr> set = this.listenerMap.get(listener);
            if (set != null) {
                set.remove(dm);
                if (set.isEmpty()) {
                    this.listenerMap.remove(listener);
                }
            }
        }
        finally {
            this.listenerMapLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String dumpFactoryMaps() {
        StringBuilder builder = new StringBuilder();
        this.classLoaderMapsLock.acquireReadLock();
        try {
            builder.append("ClassLoaders (" + this.classLoaders.size() + "):\n");
            for (Map.Entry<Object, String> entry : this.classLoaders.entrySet()) {
                builder.append(" *\t");
                builder.append(entry.getKey());
                builder.append(": ");
                builder.append(this.classLoaderNames.get(entry.getValue()));
                builder.append("(");
                builder.append((Object)entry.getValue());
                builder.append(")\n");
            }
            builder.append("Ignored ClassLoaders (" + this.ignoredClassLoaders.size() + "):\n");
            for (Map.Entry<Object, Object> entry : this.ignoredClassLoaders.entrySet()) {
                builder.append(" *\t");
                builder.append(this.classLoaderNames.get(entry.getKey()));
                builder.append("(");
                builder.append(entry.getKey());
                builder.append("): ");
                builder.append(entry.getValue());
                builder.append("\n");
            }
            builder.append("Applications (" + this.applicationDataMgrs.size() + "):\n");
            for (Map.Entry<Object, Object> entry : this.applicationDataMgrs.entrySet()) {
                builder.append(" *\t");
                builder.append(this.classLoaderNames.get(entry.getKey()));
                builder.append(": ");
                builder.append(entry.getValue());
                builder.append("\n");
            }
        }
        finally {
            this.classLoaderMapsLock.releaseReadLock();
        }
        HashMap duplicateDataMgrs = new HashMap();
        this.dmMapLock.acquireReadLock();
        try {
            void var3_9;
            builder.append("DataMgr (" + this.dmMap.size() + "):\n");
            boolean bl = false;
            int nonNullCount = 0;
            for (Map.Entry<Class<? extends DataMgr>, WeakReference<DataMgr>> e : this.dmMap.entrySet()) {
                if (e.getValue().get() == null) {
                    ++var3_9;
                } else {
                    ++nonNullCount;
                }
                builder.append("\nClass: ");
                builder.append(e.getKey());
                builder.append("\n");
                builder.append("Classloader: ");
                builder.append(e.getKey().getClassLoader());
                builder.append("\n");
                builder.append("Instance: ");
                builder.append(e.getValue() + "=" + e.getValue().get());
                builder.append("\n");
            }
            builder.append("\nFound " + nonNullCount + " active DMs and " + (int)var3_9 + " null DMs\n");
            builder.append("Null DataMgr (" + (int)var3_9 + "):\n");
            for (Map.Entry<Class<? extends DataMgr>, WeakReference<DataMgr>> e : this.dmMap.entrySet()) {
                void var3_10;
                if (e.getValue().get() != null) continue;
                builder.append(" *\tClass: ");
                builder.append(e.getKey());
                builder.append("\n");
                ++var3_10;
            }
            Iterator<Class<? extends DataMgr>> iterator = this.permanentDMs;
            synchronized (iterator) {
                builder.append("Permanent DataMgr (" + this.permanentDMs.size() + "):\n *\t");
                int i = 0;
                for (DataMgr dataMgr : this.permanentDMs) {
                    builder.append(dataMgr.getClass().getSimpleName() + (++i < this.permanentDMs.size() ? ", " : ""));
                }
            }
            builder.append("\n");
            for (Class<? extends DataMgr> clazz : this.dmMap.keySet()) {
                for (Class clazz2 : this.dmMap.keySet()) {
                    if (clazz == clazz2) continue;
                    String curName = clazz.getName();
                    Object o = this.dmMap.get(clazz).get();
                    if (!curName.equals(clazz2.getName()) || o == null || this.dmMap.get(clazz2).get() == null) continue;
                    HashSet curSet = (HashSet)duplicateDataMgrs.get(curName);
                    if (curSet == null) {
                        curSet = new HashSet();
                        duplicateDataMgrs.put(curName, curSet);
                    }
                    curSet.add(o);
                }
            }
        }
        finally {
            this.dmMapLock.releaseReadLock();
        }
        if (!duplicateDataMgrs.isEmpty()) {
            builder.append("Duplicate classes (" + duplicateDataMgrs.size() + ") - likely from a redeployment of an application:\n");
            for (Map.Entry e : duplicateDataMgrs.entrySet()) {
                builder.append(" *\t");
                builder.append((String)e.getKey());
                builder.append(" (" + ((Set)e.getValue()).size() + "): ");
                builder.append(e.getValue());
                builder.append("\n");
            }
        }
        return builder.toString();
    }
}

