/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.loadrules.DataMgrLoadRules;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.common.logging.client.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;

public class LoadRulesHandler {
    public static final String DEFAULT_DM_PROP = "dm.properties";
    public static final String BSM_DM_PROP = "bsm-dm.properties";
    private static Logger log = AsmLogger.getLogger(LoadRulesHandler.class);
    private boolean isInitialized = false;
    private WeakHashMap<Class<? extends DataMgr>, DataMgrLoadRules> loadRulesByDataMgr = new WeakHashMap();

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isEmpty() {
        return this.loadRulesByDataMgr.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String propertyFileName) throws IOException {
        if (propertyFileName == null || propertyFileName.isEmpty()) {
            throw new IOException("Must specify a valid property file");
        }
        File propertyFile = new File(propertyFileName);
        InputStream propertyFileInputStream = null;
        try {
            propertyFileInputStream = new FileInputStream(propertyFile);
        }
        catch (FileNotFoundException e) {
            log.info((Object)(propertyFileName + " not found - will try to load from the application's ClassPath"));
            propertyFileInputStream = null;
        }
        if (propertyFileInputStream == null) {
            propertyFileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFile.getName());
        }
        if (propertyFileInputStream == null) {
            throw new IOException("Could not find requested properties file on the ClassPath: " + propertyFile.getName());
        }
        Properties properties = new Properties();
        try {
            properties.load(propertyFileInputStream);
        }
        finally {
            propertyFileInputStream.close();
        }
        return properties;
    }

    public Set<DataMgrLoadRules> parseLoadRules(String classLoaderId, Properties properties) {
        HashSet<DataMgrLoadRules> loadRules = new HashSet<DataMgrLoadRules>();
        if (properties == null) {
            return loadRules;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            LoadRule loadRule;
            String dmInterfaceClass = (String)entry.getKey();
            try {
                loadRule = new LoadRule((String)entry.getValue());
            }
            catch (ParseException e) {
                log.warn((Object)("Ignoring load rule - not formatted properly '" + dmInterfaceClass + "=" + properties.get(dmInterfaceClass) + "'"));
                continue;
            }
            DataMgrLoadRules dataMgrLoadRules = new DataMgrLoadRules(dmInterfaceClass);
            dataMgrLoadRules.addLoadRule(classLoaderId, loadRule);
            loadRules.add(dataMgrLoadRules);
        }
        return loadRules;
    }

    public void setLoadRules(String classLoaderId, Properties properties) {
        if (log.isFineEnabled()) {
            log.fine((Object)("setLoadRules: classLoaderId=" + classLoaderId + " properties=" + properties));
        }
        this.updateLoadRules(classLoaderId, this.parseLoadRules(classLoaderId, properties));
    }

    public void setDefaultLoadRules(String classLoaderId, boolean isBranch) {
        Properties properties;
        this.isInitialized = true;
        String BASE_DIR = "/opt/Avaya/CommonServerPlatform" + File.separator + "lib" + File.separator;
        String file = BASE_DIR + (isBranch ? BSM_DM_PROP : DEFAULT_DM_PROP);
        if (log.isFineEnabled()) {
            log.fine((Object)("setDefaultLoadRules: classLoaderId=" + classLoaderId + " isBranch=" + isBranch + " file==" + file));
        }
        try {
            properties = this.loadProperties(file);
        }
        catch (IOException e) {
            log.warn((Object)("Error retrieving default load rules: " + e));
            return;
        }
        this.loadRulesByDataMgr.clear();
        Set<DataMgrLoadRules> loadRules = this.parseLoadRules(classLoaderId, properties);
        this.updateLoadRules(classLoaderId, loadRules);
    }

    private void updateLoadRules(String classLoaderId, Set<DataMgrLoadRules> dataMgrLoadRulesSet) {
        if (classLoaderId == null) {
            log.warn((Object)("Ignoring load rules requested for unregistered application=" + classLoaderId + ", loadRules=" + dataMgrLoadRulesSet));
            return;
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)("updateLoadRules: classLoaderId=" + classLoaderId + ", dataMgrLoadRulesSet=" + dataMgrLoadRulesSet));
        }
        if (dataMgrLoadRulesSet == null) {
            return;
        }
        DMFactory dmFactory = DMFactory.getInstance();
        for (DataMgrLoadRules dataMgrLoadRules : dataMgrLoadRulesSet) {
            String dataMgrInterfaceClassName = dataMgrLoadRules.getDataMgrInterfaceClass();
            Class<? extends DataMgr> dataMgrInterfaceClass = dmFactory.getDMClass(dataMgrInterfaceClassName);
            if (dataMgrInterfaceClass == null) {
                log.warn((Object)("Ignoring load rules requested for unresolvable interfaceClass=" + dataMgrLoadRules.getDataMgrInterfaceClass()));
            } else {
                this.updateLoadRule(classLoaderId, dataMgrInterfaceClass, dataMgrLoadRules);
            }
            DataMgr existingDM = dmFactory.getDataMgr(dataMgrInterfaceClass, dataMgrLoadRules.isPermanentDataMgr());
            if (dataMgrLoadRules.isPermanentDataMgr()) {
                dmFactory.addPermanentDM(existingDM);
            }
            if (existingDM == null) continue;
            Map<String, LoadRule> loadRules = this.loadRulesByDataMgr.get(dataMgrInterfaceClass).getLoadRules();
            existingDM.setLoadRules(loadRules.values());
        }
    }

    private void updateLoadRule(String classLoaderId, Class<? extends DataMgr> dataMgrInterfaceClass, DataMgrLoadRules newDataMgrLoadRules) {
        DataMgrLoadRules dataMgrLoadRules;
        if (log.isFinerEnabled()) {
            log.finer((Object)("updateLoadRule: classLoaderId=" + classLoaderId + ", newDataMgrLoadRules=" + newDataMgrLoadRules));
        }
        if ((dataMgrLoadRules = this.loadRulesByDataMgr.get(dataMgrInterfaceClass)) == null) {
            this.loadRulesByDataMgr.put(dataMgrInterfaceClass, newDataMgrLoadRules);
            if (log.isFinestEnabled()) {
                log.finest((Object)("updateLoadRule: inserted " + newDataMgrLoadRules));
            }
        } else {
            dataMgrLoadRules.addLoadRule(classLoaderId, newDataMgrLoadRules.getLoadRule(classLoaderId));
            if (log.isFinestEnabled()) {
                log.finest((Object)("updateLoadRule: after adding load rule, dataMgrLoadRules=" + dataMgrLoadRules));
            }
        }
    }

    public DataMgrLoadRules getLoadRules(Class<? extends DataMgr> clazz) {
        return this.loadRulesByDataMgr.get(clazz);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LoadRules:\n");
        for (Map.Entry<Class<? extends DataMgr>, DataMgrLoadRules> entry : this.loadRulesByDataMgr.entrySet()) {
            builder.append(" *\t");
            builder.append(entry.getKey());
            builder.append(": \n");
            Map<String, LoadRule> rules = this.loadRulesByDataMgr.get(entry.getKey()).getLoadRules();
            for (Map.Entry<String, LoadRule> rulesEntry : rules.entrySet()) {
                builder.append(" \t\tApplication(");
                builder.append(DMFactory.getInstance().getAppNameForCLIdentity(rulesEntry.getKey()));
                builder.append("): {");
                Iterator<Map.Entry<String, String>> iterator = rules.get(rulesEntry.getKey()).getParameters().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> c = iterator.next();
                    builder.append((Object)c.getKey());
                    builder.append("=");
                    builder.append((Object)c.getValue());
                    if (!iterator.hasNext()) continue;
                    builder.append(", ");
                }
                builder.append("}\n");
            }
        }
        return builder.toString();
    }
}

