/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteLockHandler
extends ReentrantReadWriteLock {
    private static final long serialVersionUID = 1L;
    private transient Logger log = AsmLogger.getLogger(ReadWriteLockHandler.class);
    private String ownerName;

    public ReadWriteLockHandler(String ownerName) {
        super(true);
        this.ownerName = ownerName;
    }

    public void acquireReadLock() {
        long oldTime = System.currentTimeMillis();
        try {
            if (this.readLock().tryLock(2L, TimeUnit.SECONDS)) {
                return;
            }
        }
        catch (InterruptedException e) {
            this.log.warn((Object)("Thread " + Thread.currentThread().getId() + " acquireReadLock(" + this.ownerName + "): We were interrupted trying to get the lock."));
            this.readLock().lock();
            return;
        }
        Thread owner = this.getOwner();
        Thread current = Thread.currentThread();
        if (owner != null) {
            StackTraceElement[] elements = owner.getStackTrace();
            this.log.warn((Object)("Thread " + current.getId() + " waited over 2 seconds to acquire READ LOCK for " + this.ownerName + ": RLocks=" + this.getReadLockCount() + ":\nWe are (priority " + Thread.currentThread().getPriority() + "):" + ReadWriteLockHandler.printStack(Thread.currentThread().getStackTrace()) + "\nPotential Lock Owner (priority " + owner.getPriority() + "):" + ReadWriteLockHandler.printStack(elements)));
        }
        this.log.warn((Object)("Thread " + current.getId() + " trying to acquire read lock indefinitely now on " + this.ownerName + "."));
        Thread.yield();
        this.readLock().lock();
        long newTime = System.currentTimeMillis();
        this.log.info((Object)("Thread " + current.getId() + " got the read lock for " + this.ownerName + ".  Waited a total of " + (newTime - (oldTime + 2000L)) + "ms after the 2 second wait to finally get it."));
    }

    public void acquireWriteLock() {
        long oldTime = System.currentTimeMillis();
        try {
            if (this.writeLock().tryLock(5L, TimeUnit.SECONDS)) {
                return;
            }
        }
        catch (InterruptedException e) {
            this.log.warn((Object)("Thread " + Thread.currentThread().getId() + " acquireWriteLock(" + this.ownerName + " " + Thread.currentThread().getId() + "): We were interrupted trying to get the lock."));
            this.writeLock().lock();
            return;
        }
        Thread owner = this.getOwner();
        Thread current = Thread.currentThread();
        if (owner != null) {
            StackTraceElement[] elements = owner.getStackTrace();
            this.log.warn((Object)("Thread " + current.getId() + " waited over 5 seconds to acquire WRITE LOCK for " + this.ownerName + ":\nWe are (priority " + Thread.currentThread().getPriority() + "):" + ReadWriteLockHandler.printStack(Thread.currentThread().getStackTrace()) + "\nPotential Lock Owner (priority " + owner.getPriority() + "):" + ReadWriteLockHandler.printStack(elements)));
        }
        this.log.warn((Object)("Thread " + current.getId() + " trying to acquire write lock indefinitely now on " + this.ownerName + "."));
        Thread.yield();
        this.writeLock().lock();
        long newTime = System.currentTimeMillis();
        this.log.info((Object)("Thread " + current.getId() + " got the write lock for " + this.ownerName + ".  Waited a total of " + (newTime - (oldTime + 5000L)) + "ms AFTER the 5 sec wait to finally get it."));
    }

    private static String printStack(StackTraceElement[] ste) {
        StringBuffer stackTrace = new StringBuffer();
        for (StackTraceElement e : ste) {
            stackTrace.append(e.toString() + "\n");
        }
        return stackTrace.toString();
    }

    public void releaseReadLock() {
        this.readLock().unlock();
    }

    public void releaseWriteLock() {
        this.writeLock().unlock();
    }

    @Override
    public boolean isWriteLocked() {
        return this.isWriteLockedByCurrentThread();
    }
}

