/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.LocalCommProfileSetDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.loadrulekeys.Local;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.asm.datamgr.objectapi.CsCommProfile;
import com.avaya.asm.datamgr.objectapi.LocalCommProfileSet;
import com.avaya.common.logging.client.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ConsumesLoadRules(key={Local.class})
public abstract class CommProfileDAO
extends IsDeletedHandler {
    private final Logger log = AsmLogger.getLogger(CommProfileDAO.class);
    protected ConcurrentMap<Long, CsCommProfile> csCommProfileMap = new ConcurrentHashMap<Long, CsCommProfile>();
    protected Map<Long, Long> setIdMap = new HashMap<Long, Long>();
    protected boolean localOnly = true;
    protected boolean isBranch = DMUtilities.isBranch();
    private List<String> dependentTables = null;
    protected final String getAllProfiles = this.getSelectFields() + " WHERE cs.cscommprofilesetid NOT IN (" + IsDeletedHandler.isDeletedCommProfileSetId + ") AND cs.commprofiletype = '" + this.getCommProfileType() + "'";
    protected final String joinLocalCommon = " JOIN cscommprofileset set ON cs.cscommprofilesetid = set.id" + (this.joinAsmCommProfile() ? " JOIN cscommprofile cs_a ON cs_a.cscommprofilesetid = set.id  JOIN asmcommprofile asm ON asm.id = cs_a.id" : "");
    protected final String joinLocalCore = " JOIN asmusercommunityassign uca ON uca.asmusercommunity_id = asm.usercommunity_id";
    protected final String joinLocalBranch = " JOIN asminstance ai ON asm.survivability_server_id = ai.sipentity_id";
    protected final String joinLocalSmType = this.isBranch ? " JOIN asminstance ai ON asm.survivability_server_id = ai.sipentity_id" : " JOIN asmusercommunityassign uca ON uca.asmusercommunity_id = asm.usercommunity_id";
    protected final String whereLocalCore = " AND uca.asmusercommunity_id = asm.usercommunity_id AND uca.asminstance_id = ?";
    protected final String whereLocalBranch = " AND ai.id = ?";
    protected final String whereLocalSmType = this.isBranch ? " AND ai.id = ?" : " AND uca.asmusercommunity_id = asm.usercommunity_id AND uca.asminstance_id = ?";
    protected final String getAllLocalProfiles = this.getSelectFields() + this.joinLocalCommon + this.joinLocalSmType + " WHERE set.csuserid NOT IN (" + IsDeletedHandler.isDeletedCsUserId + ") AND cs.commprofiletype = '" + this.getCommProfileType() + "'" + (this.joinAsmCommProfile() ? " AND cs_a.commprofiletype = 'SIP'" : "") + this.whereLocalSmType;
    protected final String getProfileBase = this.getSelectFields() + " JOIN cscommprofileset set ON set.id = cs.cscommprofilesetid JOIN csuser u ON u.id = set.csuserid WHERE cs.commprofiletype = '" + this.getCommProfileType() + "' AND u.isdeleted= false";
    protected final String getProfile = this.getProfileBase + " AND cs.id = ?";
    protected final String getLocalProfileBase = this.getSelectFields() + this.joinLocalCommon + this.joinLocalSmType + " JOIN csuser u ON u.id = set.csuserid WHERE u.isdeleted = false AND cs.commprofiletype = '" + this.getCommProfileType() + "'" + (this.joinAsmCommProfile() ? " AND cs_a.commprofiletype = 'SIP'" : "") + this.whereLocalSmType;
    protected final String getLocalProfile = this.getLocalProfileBase + " AND cs.id = ?";
    protected final String getProfilesBySetId = this.getProfileBase + " AND cs.cscommprofilesetid = ?";
    protected final String getLocalProfilesBySetId = this.getLocalProfileBase + " AND cs.cscommprofilesetid = ?";

    public CommProfileDAO() {
        super(true);
        this.getIdsByUserId = "SELECT cs.id, u.isdeleted FROM cscommprofile cs JOIN cscommprofileset set ON cs.cscommprofilesetid=set.id JOIN csuser u ON set.csuserid=u.id WHERE u.id = ?";
    }

    @Override
    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        super.setLoadRules(appLoadRules);
        boolean reinit = false;
        boolean bestCacheValue = true;
        block0: for (Map.Entry entry : this.loadRules.entrySet()) {
            if ("local".equals(((String)entry.getKey()).toLowerCase())) {
                for (String value : (Set)entry.getValue()) {
                    if (Boolean.parseBoolean(value)) continue;
                    bestCacheValue = false;
                    continue block0;
                }
                continue;
            }
            this.log.warn((Object)("Unrecognized Load Rule detected; ignoring: " + (String)entry.getKey()));
        }
        if (bestCacheValue != this.localOnly) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Setting Locality filter to " + bestCacheValue));
            }
            this.localOnly = bestCacheValue;
            reinit = true;
        }
        if (reinit && !this.uninitialized()) {
            this.reinit();
        }
    }

    protected void setLocalOnly(boolean value) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to directly set Load Rule!");
        }
        this.localOnly = value;
    }

    protected abstract String getSelectFields();

    protected abstract String getCommProfileType();

    protected boolean joinAsmCommProfile() {
        return true;
    }

    protected abstract ResultSetMapper getMapper();

    protected String getInitQuery() {
        return this.localOnly ? this.getAllLocalProfiles : this.getAllProfiles;
    }

    protected String getUpdateQuery() {
        return this.localOnly ? this.getLocalProfile : this.getProfile;
    }

    protected String getSetQuery() {
        return this.localOnly ? this.getLocalProfilesBySetId : this.getProfilesBySetId;
    }

    protected Object[] getInitParams() {
        return this.localOnly ? DMUtilities.getLocalAsmInstanceParams() : new Object[]{};
    }

    protected Object[] getUpdateParams(Object id) {
        Object[] objectArray;
        if (this.localOnly) {
            objectArray = DMUtilities.getLocalAsmInstanceParams(id);
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = id;
        }
        return objectArray;
    }

    protected LocalCommProfileSetDAO getLocalCommProfileSetDAO() {
        return (LocalCommProfileSetDAO)this.getDataMgr(LocalCommProfileSetDAO.class);
    }

    @Override
    protected Object getMainCollection() {
        return this.csCommProfileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        if (this.localOnly) {
            this.getLocalCommProfileSetDAO();
        }
        ConcurrentMap csCommProfileMapTMP = new ConcurrentHashMap();
        HashMap<Long, Long> setIdMapTMP = new HashMap<Long, Long>();
        Object[] params = this.getInitParams();
        try {
            if (!this.localOnly || (Long)params[0] != 0L) {
                csCommProfileMapTMP = (ConcurrentMap)this.dataSource.executeQuery(this.getInitQuery(), params, this.getMapper());
                for (CsCommProfile profile : csCommProfileMapTMP.values()) {
                    setIdMapTMP.put(profile.getCsCommProfileSetId(), profile.getId());
                }
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.csCommProfileMap = csCommProfileMapTMP;
                this.setIdMap = setIdMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        if (this.dependentTables != null) {
            return this.dependentTables;
        }
        this.dependentTables = super.getDependentTables();
        if (!this.dependentTables.contains("cscommprofileset")) {
            this.dependentTables.add("cscommprofileset");
        }
        if (!this.dependentTables.contains("asmcommprofile")) {
            this.dependentTables.add("asmcommprofile");
        }
        if (!this.dependentTables.contains("pscommprofile")) {
            this.dependentTables.add("pscommprofile");
        }
        if (!this.dependentTables.contains("cmcommprofile")) {
            this.dependentTables.add("cmcommprofile");
        }
        if (!this.dependentTables.contains("zr_commprofile")) {
            this.dependentTables.add("zr_commprofile");
        }
        if (!this.dependentTables.contains("cshandle")) {
            this.dependentTables.add("cshandle");
        }
        if (!this.dependentTables.contains("cscommprofile")) {
            this.dependentTables.add("cscommprofile");
        }
        return this.dependentTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        if ("csuser".equals(tableName)) {
            if (!this.localOnly) {
                super.updateDAO(event);
            }
            return;
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean locked = false;
        CsCommProfile oldProfile = null;
        CsCommProfile newProfile = null;
        try {
            if (this.getMainTable().equals(tableName)) {
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Map map = (Map)this.dataSource.executeQuery(this.getUpdateQuery(), this.getUpdateParams(id), this.getMapper());
                    newProfile = (CsCommProfile)map.get(id);
                }
                this.lock.acquireWriteLock();
                locked = true;
                oldProfile = (CsCommProfile)this.csCommProfileMap.remove(id);
                if (oldProfile != null) {
                    this.setIdMap.remove(oldProfile.getCsCommProfileSetId());
                }
                if (newProfile != null) {
                    this.csCommProfileMap.put(id, newProfile);
                    this.setIdMap.put(newProfile.getCsCommProfileSetId(), newProfile.getId());
                }
            } else if ("cscommprofileset".equals(tableName)) {
                Map map = null;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    map = (Map)this.dataSource.executeQuery(this.getSetQuery(), this.getUpdateParams(id), this.getMapper());
                }
                this.lock.acquireWriteLock();
                locked = true;
                Long oldProfileId = this.setIdMap.remove(id);
                if (oldProfileId != null) {
                    oldProfile = (CsCommProfile)this.csCommProfileMap.remove(oldProfileId);
                }
                if (map != null && !map.isEmpty()) {
                    newProfile = (CsCommProfile)map.values().iterator().next();
                    this.csCommProfileMap.put(newProfile.getId(), newProfile);
                    this.setIdMap.put(id, newProfile.getId());
                }
            }
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            oldProfile = null;
            newProfile = null;
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
            }
        }
        if (oldProfile == null ? newProfile != null : !oldProfile.equals(newProfile)) {
            this.updateListeners(oldProfile, newProfile);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (oldObject instanceof LocalCommProfileSet || newObject instanceof LocalCommProfileSet) {
            if (!this.localOnly) {
                return;
            }
            if (newObject == null) {
                long cmId = ((LocalCommProfileSet)oldObject).getId();
                this.updateDAO(new DAOTableEvent("cscommprofileset", DAOReplicationEvent.OperationType.DELETE, cmId));
            } else if (oldObject == null) {
                long cmId = ((LocalCommProfileSet)newObject).getId();
                this.updateDAO(new DAOTableEvent("cscommprofileset", DAOReplicationEvent.OperationType.INSERT, cmId));
            }
        } else {
            super.objectChanged(oldObject, newObject);
        }
    }

    protected void printQueries() {
        System.out.println("getAllProfiles=" + this.getAllProfiles);
        System.out.println("getAllLocalProfiles=" + this.getAllLocalProfiles);
        System.out.println("getProfile=" + this.getProfile);
        System.out.println("getLocalProfile=" + this.getLocalProfile);
        System.out.println("getProfilesBySetId=" + this.getProfilesBySetId);
        System.out.println("getLocalProfilesBySetId=" + this.getLocalProfilesBySetId);
    }
}

