/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.EntityLink;
import com.avaya.asm.datamgr.objectapi.EntityLinkTable;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityLinkTableDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(EntityLinkTableDAO.class);
    protected Map<Long, EntityLink> entityLinkMap = new HashMap<Long, EntityLink>();
    protected Map<Long, EntityLinkTable> entityLinkTableMap = new HashMap<Long, EntityLinkTable>();
    private final List<String> dependentTables = new ArrayList<String>();
    protected static final String getEntityLinks = "SELECT id, entity1_id, entity2_id, listenportentity1, listenportentity2, trusted, ipaddr_family, transportprotocol, service_state FROM entitylink";
    protected static final String getEntityLinkById = "SELECT id, entity1_id, entity2_id, listenportentity1, listenportentity2, trusted, ipaddr_family, transportprotocol, service_state FROM entitylink WHERE id=?";
    private static final ResultSetMapper entityLinksMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, EntityLink> map = new HashMap<Long, EntityLink>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                boolean denyNewService = "busy-out".equals(rs.getString("service_state"));
                map.put(id, new EntityLink(id, rs.getLong("entity1_id"), rs.getLong("entity2_id"), rs.getInt("listenportentity1"), rs.getInt("listenportentity2"), rs.getBoolean("trusted"), rs.getString("ipaddr_family"), rs.getString("transportprotocol"), denyNewService));
            }
            return map;
        }
    };
    private static final ResultSetMapper entityLinkMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                boolean denyNewService = "busy-out".equals(rs.getString("service_state"));
                return new EntityLink(rs.getLong("id"), rs.getLong("entity1_id"), rs.getLong("entity2_id"), rs.getInt("listenportentity1"), rs.getInt("listenportentity2"), rs.getBoolean("trusted"), rs.getString("ipaddr_family"), rs.getString("transportprotocol"), denyNewService);
            }
            return null;
        }
    };

    public EntityLinkTableDAO() {
        super(true);
        this.dependentTables.add("entitylink");
    }

    public ResultSetMapper getEntityLinksMapper() {
        return entityLinksMapper;
    }

    public ResultSetMapper getEntityLinkMapper() {
        return entityLinkMapper;
    }

    @Override
    public void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + EntityLinkTableDAO.class.getSimpleName()));
        }
        this.init(getEntityLinks, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void init(String query, Object[] params) {
        Map entityLinkMapTMP;
        HashMap<Long, EntityLinkTable> entityLinkTableMapTMP = new HashMap<Long, EntityLinkTable>();
        try {
            entityLinkMapTMP = (Map)this.dataSource.executeQuery(query, params, this.getEntityLinksMapper());
            for (EntityLink link : entityLinkMapTMP.values()) {
                this.addLinks(link, entityLinkTableMapTMP);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        if (this.okay()) {
            this.lock.acquireWriteLock();
            try {
                this.entityLinkMap = entityLinkMapTMP;
                this.entityLinkTableMap = entityLinkTableMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    protected void addLinks(EntityLink link, Map<Long, EntityLinkTable> map) {
        long entity1 = link.getEntity1_id();
        long entity2 = link.getEntity2_id();
        int port1 = link.getListenportentity1();
        int port2 = link.getListenportentity2();
        this.addLink(link, entity1, entity2, port1, port2, map);
        this.addLink(link, entity2, entity1, port2, port1, map);
    }

    protected void addLink(EntityLink link, long entity1, long entity2, int port1, int port2, Map<Long, EntityLinkTable> map) {
        EntityLink newLink = new EntityLink(link.getId(), entity1, entity2, port1, port2, link.getTrusted(), link.getIPAddrFamily().toString(), link.getTransportProtocol(), link.denyNewService());
        EntityLinkTable elt = map.get(entity1);
        if (elt == null) {
            elt = new EntityLinkTable(entity1);
            map.put(entity1, elt);
        }
        elt.addEntityLink(newLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        EntityLink newLink;
        EntityLink oldLink;
        block21: {
            DAOReplicationEvent.OperationType operation = event.getOperation();
            boolean locked = false;
            String tableName = event.getTableName();
            if (!this.getDependentTables().contains(tableName) || operation == null) {
                return;
            }
            Long id = event.getKey();
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)(EntityLinkTableDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
            }
            oldLink = null;
            newLink = null;
            this.lock.acquireWriteLock();
            locked = true;
            try {
                oldLink = this.entityLinkMap.remove(id);
                if (oldLink != null) {
                    Long oldEntity1 = oldLink.getEntity1_id();
                    Long oldEntity2 = oldLink.getEntity2_id();
                    if (this.entityLinkTableMap.containsKey(oldEntity1)) {
                        this.entityLinkTableMap.get(oldEntity1).removeEntityLink(oldLink);
                        if (this.entityLinkTableMap.get(oldEntity1).getSize() == 0) {
                            this.entityLinkTableMap.remove(oldEntity1);
                        }
                    }
                    if (this.entityLinkTableMap.containsKey(oldEntity2)) {
                        this.entityLinkTableMap.get(oldEntity2).removeEntityLink(oldLink);
                        if (this.entityLinkTableMap.get(oldEntity2).getSize() == 0) {
                            this.entityLinkTableMap.remove(oldEntity2);
                        }
                    }
                } else if (operation != DAOReplicationEvent.OperationType.INSERT) {
                    this.log.warn((Object)("EntityLink was null for " + (Object)((Object)operation) + " operation; we are probably out of sync"));
                }
                if (operation != DAOReplicationEvent.OperationType.INSERT && operation != DAOReplicationEvent.OperationType.UPDATE) break block21;
                try {
                    ResultSetMapper linkMapper = this.getEntityLinkMapper();
                    Object[] params = new Object[]{id};
                    newLink = (EntityLink)this.dataSource.executeQuery(getEntityLinkById, params, linkMapper);
                    if (newLink == null) {
                        throw new DMException("Data does not exist for " + (Object)((Object)operation) + " event");
                    }
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)("Retrieved new EntityLink " + newLink));
                    }
                    this.entityLinkMap.put(id, newLink);
                    this.addLinks(newLink, this.entityLinkTableMap);
                }
                catch (DMException e) {
                    if (locked) {
                        this.lock.releaseWriteLock();
                        locked = false;
                    }
                    this.log.error((Object)("Error updating " + EntityLinkTableDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
                    this.reinit();
                    if (!this.okay()) {
                        this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                    }
                    if (locked) {
                        this.lock.releaseWriteLock();
                        locked = false;
                    }
                    return;
                }
            }
            finally {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
            }
        }
        this.updateListeners(oldLink, newLink);
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(EntityLinkTableDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        return this.dependentTables;
    }

    public EntityLinkTable getEntityLinkTable(Long entityId) {
        this.lock.acquireReadLock();
        try {
            if (entityId != null && this.entityLinkTableMap.containsKey(entityId)) {
                EntityLinkTable entityLinkTable = this.entityLinkTableMap.get(entityId);
                return entityLinkTable;
            }
            EntityLinkTable entityLinkTable = new EntityLinkTable(entityId);
            return entityLinkTable;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public EntityLink getEntityLink(Long linkId) {
        this.lock.acquireReadLock();
        try {
            EntityLink entityLink = this.entityLinkMap.get(linkId);
            return entityLink;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned Entity Links.")
    public Map<Long, EntityLinkTable> getAllEntityLinks() {
        this.lock.acquireReadLock();
        try {
            Map<Long, EntityLinkTable> map = this.entityLinkTableMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected Object getMainCollection() {
        return this.entityLinkMap;
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }
}

