/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.FailoverGroup;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FailoverGroupDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(FailoverGroupDAO.class);
    public Map<Long, FailoverGroup> groupMap = new HashMap<Long, FailoverGroup>();
    public Map<Long, Long> entityMap = new HashMap<Long, Long>();
    protected Map<Long, List<FailoverGroup>> smToFailoverGroupCache = new HashMap<Long, List<FailoverGroup>>();
    protected static final String getFailoverGroups = "SELECT id, domain_name, inverse_domain_name, asm_instance1, asm_instance2 FROM asm_failover_group";
    protected static final String getFailoverGroup = "SELECT id, domain_name, inverse_domain_name, asm_instance1, asm_instance2 FROM asm_failover_group where id=?";
    protected static final String getFailoverGroupMappings = "SELECT asm_failover_group_id, sipentity_id FROM asm_failover_group_to_entity";
    protected static final String getFailoverGroupMapping = "SELECT asm_failover_group_id, sipentity_id FROM asm_failover_group_to_entity WHERE asm_failover_group_id=?";
    protected static final ResultSetMapper failoverGroupMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, FailoverGroup> fgs = new HashMap<Long, FailoverGroup>();
            while (rs.next()) {
                long id = rs.getLong("id");
                fgs.put(id, new FailoverGroup(id, rs.getString("domain_name"), rs.getString("inverse_domain_name"), rs.getLong("asm_instance1"), rs.getLong("asm_instance2")));
            }
            return fgs;
        }
    };
    protected static final ResultSetMapper entityToFailoverGroupMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Long> entityToFgMap = new HashMap<Long, Long>();
            while (rs.next()) {
                entityToFgMap.put(rs.getLong("sipentity_id"), rs.getLong("asm_failover_group_id"));
            }
            return entityToFgMap;
        }
    };

    public FailoverGroupDAO() {
        super(true);
    }

    @Override
    protected Object getMainCollection() {
        return this.groupMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap entityMapTMP;
        HashMap groupMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + FailoverGroupDAO.class.getSimpleName()));
        }
        try {
            Object[] params = new Object[]{};
            groupMapTMP = (HashMap)this.dataSource.executeQuery(getFailoverGroups, params, failoverGroupMapper);
            entityMapTMP = (HashMap)this.dataSource.executeQuery(getFailoverGroupMappings, params, entityToFailoverGroupMapper);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            this.lock.acquireWriteLock();
            try {
                this.groupMap = groupMapTMP;
                this.entityMap = entityMapTMP;
                this.smToFailoverGroupCache = new HashMap<Long, List<FailoverGroup>>();
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asm_failover_group");
        list.add("asm_failover_group_to_entity");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        FailoverGroup oldGroup = null;
        FailoverGroup newGroup = null;
        boolean locked = false;
        try {
            if (tableName.equals("asm_failover_group")) {
                if (DAOReplicationEvent.OperationType.DELETE != operation) {
                    Object[] params = new Object[]{id};
                    HashMap map = (HashMap)this.dataSource.executeQuery(getFailoverGroup, params, failoverGroupMapper);
                    newGroup = (FailoverGroup)map.get(id);
                }
                this.lock.acquireWriteLock();
                locked = true;
                this.smToFailoverGroupCache.clear();
                oldGroup = this.groupMap.remove(id);
                if (newGroup != null) {
                    this.groupMap.put(id, newGroup);
                }
            } else {
                Object[] params = new Object[]{id};
                HashMap map = (HashMap)this.dataSource.executeQuery(getFailoverGroupMapping, params, entityToFailoverGroupMapper);
                this.lock.acquireWriteLock();
                locked = true;
                HashSet<Long> keys = new HashSet<Long>();
                for (Map.Entry<Long, Long> entry : this.entityMap.entrySet()) {
                    if (!id.equals(entry.getValue())) continue;
                    keys.add(entry.getKey());
                }
                for (Long l : keys) {
                    this.entityMap.remove(l);
                }
                for (Map.Entry<Long, Long> entry : map.entrySet()) {
                    this.entityMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + FailoverGroupDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            newGroup = null;
            oldGroup = null;
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Update NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
        }
        if (oldGroup != null || newGroup != null) {
            this.updateListeners(oldGroup, newGroup);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(this.logTag(operation, tableName, id) + "Update successful"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FailoverGroup> getFailoverGroupsForSm(long smInstanceId) {
        this.lock.acquireReadLock();
        try {
            if (this.smToFailoverGroupCache.containsKey(smInstanceId)) {
                List<FailoverGroup> list = this.smToFailoverGroupCache.get(smInstanceId);
                return list;
            }
            ArrayList<FailoverGroup> retVal = new ArrayList<FailoverGroup>();
            for (FailoverGroup group : this.groupMap.values()) {
                if (group.getPrimarySMId() != smInstanceId && group.getSecondarySMId() != smInstanceId) continue;
                retVal.add(group);
            }
            this.smToFailoverGroupCache.put(smInstanceId, retVal);
            ArrayList<FailoverGroup> arrayList = retVal;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public FailoverGroup getFailoverGroup(Long sipEntityId) {
        this.lock.acquireReadLock();
        try {
            FailoverGroup failoverGroup = this.groupMap.get(this.entityMap.get(sipEntityId));
            return failoverGroup;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned FailoverGroups.")
    public Set<FailoverGroup> getAllFailoverGroups() {
        this.lock.acquireReadLock();
        try {
            HashSet<FailoverGroup> hashSet = new HashSet<FailoverGroup>(this.groupMap.values());
            return hashSet;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

