/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarm;
import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.datamgr.DAOAsmIdentityAlarm;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.core.exceptions.SMIdentityException;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMember;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.Instance;
import com.avaya.common.logging.client.Logger;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class InstanceDAO
extends DataAccessObject {
    protected static final Logger log = AsmLogger.getLogger(InstanceDAO.class);
    protected Map<Long, Instance> instanceMap = new ConcurrentHashMap<Long, Instance>();
    protected Map<Long, Instance> entityMap = new ConcurrentHashMap<Long, Instance>();
    private Long mySIPEntityId = null;
    private Instance myInstance = null;
    private boolean instanceEverResolved = false;

    protected abstract String getInstancesQuery();

    protected abstract String getInstanceQuery();

    protected abstract ResultSetMapper getMapper();

    public InstanceDAO() {
        super(true);
    }

    protected abstract boolean tryResolveIdentity();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolveIdentity() {
        if (!this.tryResolveIdentity()) {
            return true;
        }
        boolean instanceResolved = true;
        boolean beforeCheckIsResolved = this.mySIPEntityId != null;
        try {
            this.lock.acquireWriteLock();
            Instance oldInstance = this.myInstance;
            this.mySIPEntityId = null;
            this.myInstance = null;
            String managementServerIpAddress = DataDistLayerFactory.getInstance().getIntraClusterName();
            if (log.isFinerEnabled()) {
                log.finer((Object)("resolveIdentity(): Searching for an Instance matching " + managementServerIpAddress));
            }
            try {
                IPAddress mgmtIpAddress = IPAddress.parseIPAddr(managementServerIpAddress);
                for (Map.Entry<Long, Instance> entry : this.instanceMap.entrySet()) {
                    Instance instance = entry.getValue();
                    String managementAccessPointHostName = instance.getManagementAccessPointHostName();
                    try {
                        for (String address : this.realDNSResolve(managementAccessPointHostName)) {
                            if (log.isFinestEnabled()) {
                                log.finest((Object)("Looking at address " + address));
                            }
                            if (mgmtIpAddress.compareTo(IPAddress.parseIPAddr(address)) != 0) continue;
                            if (this.mySIPEntityId != null) {
                                if (log.isFinestEnabled()) {
                                    log.finest((Object)("Current mySIPEntityID is " + this.mySIPEntityId));
                                }
                                throw new SMIdentityException("Found multiple Instances that correspond to us.  Current mySipEntityId = " + this.mySIPEntityId, this.mySIPEntityId, this.myInstance.getManagementAccessPointHostName(), this.instanceEverResolved);
                            }
                            this.mySIPEntityId = instance.getSipEntityId();
                            this.myInstance = instance;
                        }
                    }
                    catch (UnknownHostException e) {
                        log.warn((Object)("Found an Instance with a management access point host name that can't be resolved using real DNS: " + instance.getManagementAccessPointHostName()));
                    }
                    catch (ParseException e) {
                        log.warn((Object)("Found an Instance with a management access point IP address that doesn't parse: " + instance.getManagementAccessPointHostName()));
                    }
                }
                if (this.mySIPEntityId == null) {
                    throw new SMIdentityException("Instance is unresolved.", this.mySIPEntityId, null, this.instanceEverResolved);
                }
                if (this.myInstance.isBranch() != DMUtilities.isBranch()) {
                    log.warn((Object)("Unsupported configuration - install type is " + (DMUtilities.isBranch() ? "branch" : "core") + ", but configured type is " + (this.myInstance.isBranch() ? "branch." : "core.")));
                    this.myInstance = null;
                    this.mySIPEntityId = null;
                    throw new SMIdentityException("Installed type does not match configured instance.", null, null, this.instanceEverResolved);
                }
                log.fine((Object)("resolveIdentity(): myEntityId is now " + this.mySIPEntityId));
                if (!this.myInstance.equals(oldInstance)) {
                    log.info((Object)("Resolved self as instance with host name " + this.myInstance.getManagementAccessPointHostName()));
                }
                if (this.instanceEverResolved && !beforeCheckIsResolved) {
                    GenericAlarmHandler.manuallyClearEvent(this, new SMIdentityException());
                }
            }
            catch (SMIdentityException | ParseException e1) {
                log.error((Object)"Error resolving Instance");
                this.handleFailureEvent(e1);
                instanceResolved = false;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        DDLInterClusterMember member = DataDistLayerFactory.getInstance().getInterClusterMember();
        if (instanceResolved) {
            this.instanceEverResolved = true;
            if (member != null && !beforeCheckIsResolved && !DMUtilities.isBranch()) {
                DataDistLayerFactory.getInstance().asynchRejoinMember(member);
            }
        } else if (member != null) {
            ((DataDistLayerMember)member).leaveTheGroup(false);
        }
        return instanceResolved;
    }

    @Override
    protected Object getMainCollection() {
        return this.instanceMap;
    }

    @Override
    public synchronized void init() {
        Map instanceMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + InstanceDAO.class.getSimpleName()));
        }
        ConcurrentHashMap<Long, Instance> entityMapTMP = new ConcurrentHashMap<Long, Instance>();
        try {
            Object[] params = new Object[]{};
            instanceMapTMP = (Map)this.dataSource.executeQuery(this.getInstancesQuery(), params, this.getMapper());
            for (Instance instance : instanceMapTMP.values()) {
                entityMapTMP.put(instance.getSipEntityId(), instance);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        if (this.okay()) {
            this.instanceMap = instanceMapTMP;
            this.entityMap = entityMapTMP;
            this.resolveIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)(InstanceDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        Instance oldInstance = null;
        Instance newInstance = null;
        try {
            this.lock.acquireWriteLock();
            ConcurrentHashMap<Long, Instance> instanceMapTMP = new ConcurrentHashMap<Long, Instance>(this.instanceMap);
            ConcurrentHashMap<Long, Instance> entityMapTMP = new ConcurrentHashMap<Long, Instance>(this.entityMap);
            try {
                oldInstance = (Instance)instanceMapTMP.remove(id);
                if (oldInstance == null) {
                    if (operation == DAOReplicationEvent.OperationType.DELETE) {
                        return;
                    }
                    if (operation != DAOReplicationEvent.OperationType.INSERT) {
                        log.warn((Object)("Instance was null for " + (Object)((Object)operation) + "; we are probably out of sync"));
                    }
                } else {
                    entityMapTMP.remove(oldInstance.getSipEntityId());
                }
                newInstance = null;
                if (DAOReplicationEvent.OperationType.UPDATE == operation || DAOReplicationEvent.OperationType.INSERT == operation) {
                    Object[] params = new Object[]{id};
                    Map newMap = (Map)this.dataSource.executeQuery(this.getInstanceQuery(), params, this.getMapper());
                    if (newMap.size() != 1) {
                        throw new DMException("updateDAO: read " + newMap.size() + " Instance(" + id + ") from database");
                    }
                    newInstance = (Instance)newMap.get(id);
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("Retrieved new Instance " + newInstance));
                    }
                    instanceMapTMP.put(id, newInstance);
                    entityMapTMP.put(newInstance.getSipEntityId(), newInstance);
                }
                this.instanceMap = instanceMapTMP;
                this.entityMap = entityMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        catch (DMException e) {
            log.error((Object)("Error updating " + InstanceDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
            } else if (log.isFineEnabled()) {
                log.fine((Object)(InstanceDAO.class.getSimpleName() + " update successful after a full DAO reinit"));
            }
            return;
        }
        this.resolveIdentity();
        this.updateListeners(oldInstance, newInstance);
        if (log.isFineEnabled()) {
            log.fine((Object)(InstanceDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public abstract List<String> getDependentTables();

    public String getMyIp() {
        if (this.myInstance != null) {
            return this.myInstance.getManagementAccessPointHostName();
        }
        return null;
    }

    public Long getMySIPEntityId() {
        this.lock.acquireReadLock();
        try {
            Long l = this.mySIPEntityId;
            return l;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public Instance getMyInstance() {
        this.lock.acquireReadLock();
        try {
            Instance instance = this.myInstance;
            return instance;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public Long getMyInstanceId() {
        this.lock.acquireReadLock();
        try {
            if (this.myInstance == null) {
                Long l = null;
                return l;
            }
            Long l = this.myInstance.getId();
            return l;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    protected Instance getInstance(Long instanceId) {
        if (instanceId == null) {
            return null;
        }
        return this.instanceMap.get(instanceId);
    }

    public List<String> getAllCoreInstanceIPs() {
        ArrayList<String> entityList = new ArrayList<String>();
        if (this.instanceMap == null) {
            return entityList;
        }
        for (Instance instance : this.instanceMap.values()) {
            if (instance.isBranch()) continue;
            String mgmtIP = instance.getManagementAccessPointHostName();
            try {
                this.realDNSResolve(mgmtIP);
                entityList.add(mgmtIP);
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return entityList;
    }

    public Instance getEntityInstance(Long entityId) {
        return this.entityMap.get(entityId);
    }

    public Map<Long, Instance> getAllInstances() {
        return Collections.unmodifiableMap(this.instanceMap);
    }

    public Map<Long, Instance> getAllInstanceEntities() {
        return Collections.unmodifiableMap(this.entityMap);
    }

    @Override
    protected boolean isCorrected(GenericAlarm alarm) {
        if (DAOAsmIdentityAlarm.class.equals(alarm.getClass())) {
            return this.resolveIdentity();
        }
        return super.isCorrected(alarm);
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }

    protected List<String> realDNSResolve(String fqdn) throws UnknownHostException {
        return AsmCommon.realDNSResolve(fqdn);
    }
}

