/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.helpers.FlexCache;
import com.avaya.asm.datamgr.loadrulekeys.CacheSize;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ConsumesLoadRules(key={CacheSize.class})
public class SetSurvivableDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(SetSurvivableDAO.class);
    private int capacity = 1;
    protected FlexCache<Long, Long> setSurvivableMap = new FlexCache();
    public static final String getSetSurvivables = "SELECT set.id, asm.survivability_server_id FROM cscommprofile cs JOIN asmcommprofile asm ON cs.id=asm.id JOIN cscommprofileset set ON set.id=cs.cscommprofilesetid JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false";
    public static final String getSetSurvivablesBySurvivableId = "SELECT set.id, asm.survivability_server_id FROM cscommprofile cs JOIN asmcommprofile asm ON cs.id=asm.id JOIN cscommprofileset set ON set.id=cs.cscommprofilesetid JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false AND asm.survivability_server_id = ?";
    public static final String setIdStatement = "SELECT set.id, asm.survivability_server_id FROM cscommprofile cs JOIN asmcommprofile asm ON cs.id=asm.id JOIN cscommprofileset set ON set.id=cs.cscommprofilesetid JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false AND set.id = ?";
    public static final String csIdStatement = "SELECT set.id, asm.survivability_server_id FROM cscommprofile cs JOIN asmcommprofile asm ON cs.id=asm.id JOIN cscommprofileset set ON set.id=cs.cscommprofilesetid JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false AND cs.id = ?";
    public static final String asmIdStatement = "SELECT set.id, asm.survivability_server_id FROM cscommprofile cs JOIN asmcommprofile asm ON cs.id=asm.id JOIN cscommprofileset set ON set.id=cs.cscommprofilesetid JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false AND asm.id = ?";
    public static final String getSetIdByUserId = "SELECT set.id FROM cscommprofileset set JOIN csuser u ON set.csuserid=u.id WHERE u.id = ?";
    protected static final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            while (rs.next()) {
                map.put(rs.getLong("id"), (Long)rs.getObject("survivability_server_id"));
            }
            return map;
        }
    };
    protected static final ResultSetMapper userMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getLong("id");
            }
            return null;
        }
    };

    public SetSurvivableDAO() {
        super(false);
    }

    protected void setCapacity(int capacity) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to directly set Load Rule!");
        }
        this.capacity = capacity;
    }

    protected int getCapacity() {
        return this.capacity;
    }

    @Override
    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        super.setLoadRules(appLoadRules);
        boolean reinit = false;
        int bestCacheValue = 1;
        block0: for (Map.Entry entry : this.loadRules.entrySet()) {
            if ("cachesize".equals(((String)entry.getKey()).toLowerCase())) {
                for (String value : (Set)entry.getValue()) {
                    int cap = Integer.parseInt(value);
                    if (cap <= 0) {
                        bestCacheValue = -1;
                        continue block0;
                    }
                    if (bestCacheValue == -1 || cap <= bestCacheValue) continue;
                    bestCacheValue = cap;
                }
                continue;
            }
            this.log.warn((Object)("Unrecognized Load Rule detected; ignoring: " + (String)entry.getKey()));
        }
        if (bestCacheValue != this.capacity) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Setting FlexCache capacity to " + bestCacheValue));
            }
            this.capacity = bestCacheValue;
            reinit = true;
        }
        if (reinit && !this.uninitialized()) {
            this.reinit();
        }
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        FlexCache setSurvivableMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        try {
            HashMap setSurvivableMapQueryResults = null;
            if (this.getCapacity() >= 0) {
                Long myEntityId = this.getAsmInstanceDAO().getMySIPEntityId();
                if (myEntityId != null) {
                    Object[] params = new Object[]{myEntityId};
                    setSurvivableMapQueryResults = (HashMap)this.dataSource.executeQuery(getSetSurvivablesBySurvivableId, params, mapper);
                }
            } else {
                Object[] params = new Object[]{};
                setSurvivableMapQueryResults = (HashMap)this.dataSource.executeQuery(getSetSurvivables, params, mapper);
            }
            setSurvivableMapTMP = new FlexCache(this.getCapacity(), setSurvivableMapQueryResults, true);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.setSurvivableMap = setSurvivableMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        long id = event.getKey();
        if ("cshandle".equals(tableName)) {
            return;
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        Object[] params = new Object[]{id};
        boolean lockHeld = false;
        try {
            if ("csuser".equals(tableName)) {
                Long setId = (Long)this.dataSource.executeQuery(getSetIdByUserId, params, userMapper);
                if (setId != null) {
                    if (this.getCapacity() >= 0) {
                        this.lock.acquireWriteLock();
                        lockHeld = true;
                        this.setSurvivableMap.remove(setId);
                    } else {
                        params = new Object[]{setId};
                        Map map = (Map)this.dataSource.executeQuery(setIdStatement, params, mapper);
                        this.lock.acquireWriteLock();
                        lockHeld = true;
                        if (map.isEmpty()) {
                            this.setSurvivableMap.remove(setId);
                            if (this.log.isFinestEnabled()) {
                                this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + setId + " no longer maps to a Survivability Server"));
                            }
                        } else {
                            for (Map.Entry entry : map.entrySet()) {
                                this.setSurvivableMap.put((Long)entry.getKey(), (Long)entry.getValue());
                                if (!this.log.isFinestEnabled()) continue;
                                this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Survivability Server " + entry.getValue()));
                            }
                        }
                    }
                }
            } else if ("cscommprofileset".equals(tableName)) {
                if (this.getCapacity() >= 0) {
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    this.setSurvivableMap.remove(id);
                } else {
                    Map map = (Map)this.dataSource.executeQuery(setIdStatement, params, mapper);
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    if (map.isEmpty()) {
                        this.setSurvivableMap.remove(id);
                        if (this.log.isFinestEnabled()) {
                            this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + id + " no longer maps to a Survivability Server"));
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            this.setSurvivableMap.put((Long)entry.getKey(), (Long)entry.getValue());
                            if (!this.log.isFinestEnabled()) continue;
                            this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Survivability Server " + entry.getValue()));
                        }
                    }
                }
            } else if ("cscommprofile".equals(tableName)) {
                if (this.getCapacity() < 0) {
                    Map map = (Map)this.dataSource.executeQuery(csIdStatement, params, mapper);
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    for (Map.Entry entry : map.entrySet()) {
                        if (this.getCapacity() >= 0 && !this.setSurvivableMap.containsKey(entry.getKey())) continue;
                        this.setSurvivableMap.put((Long)entry.getKey(), (Long)entry.getValue());
                        if (!this.log.isFinestEnabled()) continue;
                        this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Survivability Server " + entry.getValue()));
                    }
                }
            } else if ("asmcommprofile".equals(tableName) && this.getCapacity() < 0) {
                Map map = (Map)this.dataSource.executeQuery(asmIdStatement, params, mapper);
                this.lock.acquireWriteLock();
                lockHeld = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (this.getCapacity() >= 0 && !this.setSurvivableMap.containsKey(entry.getKey())) continue;
                    this.setSurvivableMap.put((Long)entry.getKey(), (Long)entry.getValue());
                    if (!this.log.isFinestEnabled()) continue;
                    this.log.finest((Object)(this.logTag(operation, tableName, id) + "Set " + entry.getKey() + " now maps to Survivability Server " + entry.getValue()));
                }
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csuser");
        list.add("cscommprofileset");
        list.add("cscommprofile");
        list.add("asmcommprofile");
        list.add("cshandle");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        return this.setSurvivableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getSurvivabilityServerId(Long setId) {
        if (setId == null) {
            return null;
        }
        Long survId = null;
        try {
            this.lock.acquireReadLock();
            survId = this.setSurvivableMap.get(setId);
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (survId != null || this.getCapacity() < 0) {
            return survId;
        }
        try {
            Object[] params = new Object[]{setId};
            Map map = (Map)this.dataSource.executeQuery(setIdStatement, params, mapper);
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)("Read object(s) into FlexCache: " + map));
            }
            if (map != null) {
                survId = (Long)map.get(setId);
            }
        }
        catch (DMException e) {
            this.log.error((Object)("Error reading Database for " + setId), (Throwable)e);
        }
        if (survId != null) {
            try {
                this.lock.acquireWriteLock();
                this.setSurvivableMap.put(setId, survId);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return survId;
    }

    @SMConsole(description="Print a map of CommProfileSet IDs to Survivability Server IDs.")
    public Map<Long, Long> getSetSurvivableMappings() {
        this.lock.acquireReadLock();
        try {
            Map<Long, Long> map = this.setSurvivableMap.getCopyOfInternalMap();
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

