/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmSettings;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.OldNewDataDiffs;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.IptBaseDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.SynchingCMs;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class SynchingCmDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(SynchingCmDAO.class);
    protected static final Object[] params = new Object[0];
    protected static final Object[] paramsArray = new Object[0];
    private final Timer timer;
    private TimerTask timerTask;
    private long updateTimeStamp = this.currentTime();
    protected SynchingCMs mainCollection = new SynchingCMs(null);
    protected static final String cmSyncSQLFunction = "select ipt_iscmsyncrunning()";
    protected static final String findUnknownCMSyncStatusQuery = "SELECT cm_id FROM ipt_cmtask WHERE taskstatus <> 'Completed' AND taskstatus <> 'Failed' AND taskstatus <> 'Smgr Upgraded' AND taskstatus <> 'Interrupted' AND taskstatus NOT LIKE '%Synchronizing%'";
    protected final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ArrayList<Long> collection = new ArrayList<Long>();
            while (rs.next()) {
                collection.add(rs.getLong("ipt_iscmsyncrunning"));
            }
            return collection;
        }
    };
    protected final ResultSetMapper unknownCMSyncStateMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, String> cmMap = new HashMap<Long, String>();
            while (rs.next()) {
                cmMap.put(rs.getLong("cm_id"), rs.getString("taskstatus"));
            }
            return cmMap;
        }
    };

    public SynchingCmDAO() {
        super(true);
        this.timer = new Timer(true);
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    @Override
    protected Object getMainCollection() {
        return this.mainCollection;
    }

    @Override
    public void init() {
        Collection mainCollectionTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        try {
            mainCollectionTMP = (Collection)this.dataSource.executeQuery(cmSyncSQLFunction, params, this.mapper);
            if (mainCollectionTMP.isEmpty()) {
                this.updateTimeStamp = this.currentTime();
            }
            this.setStatus(DataMgr.Status.OKAY);
            this.checkForUnknownCMSyncState();
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.mainCollection = new SynchingCMs(mainCollectionTMP);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        if (!AsmCommon.jUnitEnvironment) {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        SynchingCmDAO.this.handleSyncTimeout();
                    }
                    catch (Exception e) {
                        log.error((Object)"Exception in task for avoiding stuck listeners", (Throwable)e);
                    }
                }
            };
            this.timer.scheduleAtFixedRate(this.timerTask, 2000L, 60000L);
        }
    }

    protected void checkForUnknownCMSyncState() {
        String fcn_name = "checkForUnknownCMSyncState";
        try {
            HashMap unknownCMSyncStateMap = (HashMap)this.dataSource.executeQuery(findUnknownCMSyncStatusQuery, paramsArray, this.unknownCMSyncStateMapper);
            if (unknownCMSyncStateMap.size() > 0) {
                StringBuilder cmIDList = new StringBuilder();
                for (Map.Entry entry : unknownCMSyncStateMap.entrySet()) {
                    cmIDList.append("[CM_ID: " + entry.getKey() + " TASKSTATUS: " + (String)entry.getValue() + "] ");
                }
                log.warn((Object)("checkForUnknownCMSyncState: Listing unknown CM sync state and their IDs - " + cmIDList));
            }
        }
        catch (DMException e) {
            log.error((Object)"checkForUnknownCMSyncState: Exception: ", (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        log.info((Object)("Destroying " + this.getClass().getSimpleName()));
        this.timer.cancel();
    }

    @Override
    protected List<OldNewDataDiffs> compareOldNewData(Object oldData, Object newData) {
        Collection<Long> oldCollection = ((SynchingCMs)oldData).ids;
        Collection<Long> newCollection = ((SynchingCMs)newData).ids;
        boolean match = true;
        for (Long id : oldCollection) {
            if (newCollection.contains(id)) continue;
            match = false;
            break;
        }
        if (match) {
            for (Long id : newCollection) {
                if (oldCollection.contains(id)) continue;
                match = false;
                break;
            }
        }
        if (oldCollection.isEmpty() || newCollection.isEmpty()) {
            this.updateTimeStamp = this.currentTime();
        }
        ArrayList<OldNewDataDiffs> diffList = new ArrayList<OldNewDataDiffs>();
        if (!match) {
            diffList.add(new OldNewDataDiffs(oldData, newData));
        }
        return diffList;
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ipt_cmtask");
        return list;
    }

    @Override
    public int numChangesBeforeReinit() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean lockHeld = false;
        SynchingCMs oldCollection = null;
        SynchingCMs newCollection = null;
        try {
            Collection mainCollectionTMP = (Collection)this.dataSource.executeQuery(cmSyncSQLFunction, params, this.mapper);
            this.lock.acquireWriteLock();
            lockHeld = true;
            oldCollection = this.mainCollection;
            this.mainCollection = new SynchingCMs(mainCollectionTMP);
            if (this.compareOldNewData(oldCollection, this.mainCollection).isEmpty()) {
                oldCollection = null;
            } else {
                newCollection = this.mainCollection;
            }
            this.checkForUnknownCMSyncState();
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            newCollection = null;
            oldCollection = null;
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (oldCollection != null || newCollection != null) {
            this.updateListeners(oldCollection, newCollection);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    protected void handleSyncTimeout() {
        if (this.getSynchingCMs().isEmpty()) {
            this.updateTimeStamp = this.currentTime();
            return;
        }
        if (this.updateTimeStamp + AsmSettings.getIPTCMSyncTimeout() < this.currentTime()) {
            log.info((Object)("Continuous IPTCM syncs have lasted more than " + AsmSettings.getIPTCMSyncTimeout() / 60000L + " minutes. Specifically, it has been " + (this.currentTime() - this.updateTimeStamp) / 60000L + " minutes since IPT DAOs have processed replication updates. Processing queued replication updates now."));
            for (DMListener listener : this.getListeners()) {
                if (!(listener instanceof IptBaseDAO)) continue;
                ((IptBaseDAO)listener).processEventQueue();
            }
            this.updateTimeStamp = this.currentTime();
        }
    }

    @SMConsole(description="Get the IDs of all IptCMs that are currently engaged in IPTCM syncs.")
    public Collection<Long> getSynchingCMs() {
        try {
            this.lock.acquireReadLock();
            Collection<Long> collection = this.mainCollection.ids;
            return collection;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

