/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.RoutePolicy;
import com.avaya.asm.datamgr.objectapi.TimeOfDay;
import com.avaya.asm.datamgr.objectapi.TimeRange;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;

public class TimeDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(TimeDAO.class);
    protected Map<Long, String> timeZoneMap = new HashMap<Long, String>();
    protected Map<Long, TimeRange> timeRangeMap = new HashMap<Long, TimeRange>();
    protected Map<Long, TimeOfDay> timeOfDayMap = new HashMap<Long, TimeOfDay>();
    protected Map<Long, List<TimeOfDay>> policyTimeMap = new HashMap<Long, List<TimeOfDay>>();
    private final Random generator;
    protected static final String getTimeZones = "SELECT id, name FROM timezone";
    protected static final String getTimeZone = "SELECT id, name FROM timezone WHERE id=?";
    protected static final String getTimeRanges = "SELECT id, includessunday, includesmonday, includestuesday, includeswednesday, includesthursday, includesfriday, includessaturday, starttime, stoptime FROM timerange";
    protected static final String getTimeRange = "SELECT id, includessunday, includesmonday, includestuesday, includeswednesday, includesthursday, includesfriday, includessaturday, starttime, stoptime FROM timerange WHERE id=?";
    protected static final String getTimesOfDay = "SELECT id, timerange_id, routingpolicy_id, rank FROM timeofday";
    protected static final String getTimeOfDay = "SELECT id, timerange_id, routingpolicy_id, rank FROM timeofday WHERE id=?";
    protected final ResultSetMapper timeZoneMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException, DMException {
            HashMap<Long, String> map = new HashMap<Long, String>();
            while (rs.next()) {
                map.put(rs.getLong("id"), rs.getString("name"));
            }
            return map;
        }
    };
    protected final ResultSetMapper timeRangeMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException, DMException {
            HashMap<Long, TimeRange> map = new HashMap<Long, TimeRange>();
            Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            while (rs.next()) {
                map.put(rs.getLong("id"), new TimeRange(rs.getBoolean("includessunday"), rs.getBoolean("includesmonday"), rs.getBoolean("includestuesday"), rs.getBoolean("includeswednesday"), rs.getBoolean("includesthursday"), rs.getBoolean("includesfriday"), rs.getBoolean("includessaturday"), rs.getTime("starttime", utc), rs.getTime("stoptime", utc)));
            }
            return map;
        }
    };
    protected final ResultSetMapper timeOfDayMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException, DMException {
            HashMap<Long, TimeOfDay> map = new HashMap<Long, TimeOfDay>();
            while (rs.next()) {
                Long timeRangeId = (Long)rs.getObject("timerange_id");
                Long routingPolicyId = (Long)rs.getObject("routingpolicy_id");
                if (timeRangeId == null || routingPolicyId == null) continue;
                map.put(rs.getLong("id"), new TimeOfDay(timeRangeId, routingPolicyId, rs.getInt("rank")));
            }
            return map;
        }
    };

    public TimeDAO() {
        this.generator = new Random();
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap<Long, List<TimeOfDay>> policyTimeMapTMP;
        HashMap timeOfDayMapTMP;
        HashMap timeRangeMapTMP;
        HashMap timeZoneMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + TimeDAO.class.getSimpleName()));
        }
        try {
            Object[] params = new Object[]{};
            timeZoneMapTMP = (HashMap)this.dataSource.executeQuery(getTimeZones, params, this.timeZoneMapper);
            timeRangeMapTMP = (HashMap)this.dataSource.executeQuery(getTimeRanges, params, this.timeRangeMapper);
            timeOfDayMapTMP = (HashMap)this.dataSource.executeQuery(getTimesOfDay, params, this.timeOfDayMapper);
            policyTimeMapTMP = new HashMap<Long, List<TimeOfDay>>();
            for (TimeOfDay timeOfDay : timeOfDayMapTMP.values()) {
                if (!policyTimeMapTMP.containsKey(timeOfDay.getRoutingPolicyId())) {
                    policyTimeMapTMP.put(timeOfDay.getRoutingPolicyId(), new ArrayList());
                }
                ((List)policyTimeMapTMP.get(timeOfDay.getRoutingPolicyId())).add(timeOfDay);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.timeZoneMap = timeZoneMapTMP;
                this.timeRangeMap = timeRangeMapTMP;
                this.timeOfDayMap = timeOfDayMapTMP;
                this.policyTimeMap = policyTimeMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        boolean locked = false;
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)(TimeDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        try {
            this.lock.acquireWriteLock();
            locked = true;
            if (tableName.equals("timezone")) {
                if (this.timeZoneMap.remove(id) == null && operation != DAOReplicationEvent.OperationType.INSERT) {
                    log.warn((Object)("Timezone was null for " + (Object)((Object)operation) + "; we are probably out of sync"));
                }
                if (DAOReplicationEvent.OperationType.UPDATE == operation || DAOReplicationEvent.OperationType.INSERT == operation) {
                    Object[] params = new Object[]{id};
                    HashMap zoneMap = (HashMap)this.dataSource.executeQuery(getTimeZone, params, this.timeZoneMapper);
                    if (zoneMap.size() != 1) {
                        throw new DMException("updateDAO: read " + zoneMap.size() + " TimeZone(" + id + ") from database");
                    }
                    String zone = (String)zoneMap.get(id);
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("Retrieved new TimeZone " + zone));
                    }
                    this.timeZoneMap.put(id, zone);
                }
            } else if (tableName.equals("timerange")) {
                if (this.timeRangeMap.remove(id) == null && operation != DAOReplicationEvent.OperationType.INSERT) {
                    log.warn((Object)("TimeRange was null for " + (Object)((Object)operation) + "; we are probably out of sync"));
                }
                if (DAOReplicationEvent.OperationType.UPDATE == operation || DAOReplicationEvent.OperationType.INSERT == operation) {
                    Object[] params = new Object[]{id};
                    HashMap rangeMap = (HashMap)this.dataSource.executeQuery(getTimeRange, params, this.timeRangeMapper);
                    if (rangeMap.size() != 1) {
                        throw new DMException("updateDAO: read " + rangeMap.size() + " TimeRange(" + id + ") from database");
                    }
                    TimeRange range = (TimeRange)rangeMap.get(id);
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("Retrieved new TimeRange " + range));
                    }
                    this.timeRangeMap.put(id, range);
                }
            } else if (tableName.equals("timeofday")) {
                TimeOfDay timeOfDay = this.timeOfDayMap.remove(id);
                if (timeOfDay != null) {
                    List<TimeOfDay> list = this.policyTimeMap.get(timeOfDay.getRoutingPolicyId());
                    if (list != null) {
                        list.remove(timeOfDay);
                        if (list.isEmpty()) {
                            this.policyTimeMap.remove(timeOfDay.getRoutingPolicyId());
                        }
                    }
                } else if (operation != DAOReplicationEvent.OperationType.INSERT) {
                    log.warn((Object)("TimeOfDay was null for " + (Object)((Object)operation) + "; we are probably out of sync"));
                }
                if (DAOReplicationEvent.OperationType.UPDATE == operation || DAOReplicationEvent.OperationType.INSERT == operation) {
                    Object[] params = new Object[]{id};
                    HashMap todMap = (HashMap)this.dataSource.executeQuery(getTimeOfDay, params, this.timeOfDayMapper);
                    if (todMap.size() != 1) {
                        throw new DMException("updateDAO: read " + todMap.size() + " TimeOfDay(" + id + ") from database");
                    }
                    timeOfDay = (TimeOfDay)todMap.get(id);
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("Retrieved new TimeOfDay " + timeOfDay));
                    }
                    this.timeOfDayMap.put(id, timeOfDay);
                    if (!this.policyTimeMap.containsKey(timeOfDay.getRoutingPolicyId())) {
                        this.policyTimeMap.put(timeOfDay.getRoutingPolicyId(), new ArrayList());
                    }
                    this.policyTimeMap.get(timeOfDay.getRoutingPolicyId()).add(timeOfDay);
                }
            }
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            log.error((Object)("Error updating " + TimeDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(TimeDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("timezone");
        list.add("timerange");
        list.add("timeofday");
        return list;
    }

    private String padLeft(String s) {
        while (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    private String customCalendarToString(Calendar calendar) {
        String day = "Sunday";
        switch (calendar.get(7)) {
            case 1: {
                day = "Sunday";
                break;
            }
            case 2: {
                day = "Monday";
                break;
            }
            case 3: {
                day = "Tuesday";
                break;
            }
            case 4: {
                day = "Wednesday";
                break;
            }
            case 5: {
                day = "Thursday";
                break;
            }
            case 6: {
                day = "Friday";
                break;
            }
            case 7: {
                day = "Saturday";
                break;
            }
            default: {
                day = "ERROR";
            }
        }
        return day + " " + calendar.get(11) + ":" + this.padLeft("" + calendar.get(12)) + ":" + this.padLeft("" + calendar.get(13));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RoutePolicy> rankRoutePolicies(List<RoutePolicy> routePolicyList, Long tod) throws DMException {
        try {
            this.lock.acquireReadLock();
            if (routePolicyList == null) {
                ArrayList<RoutePolicy> arrayList = new ArrayList<RoutePolicy>();
                return arrayList;
            }
            if (routePolicyList.size() < 2) {
                List<RoutePolicy> list = routePolicyList;
                return list;
            }
            if (log.isFinestEnabled()) {
                log.finest((Object)("Ranking RoutePolicies " + routePolicyList));
            }
            ArrayList<RoutePolicy> returnPolicyList = new ArrayList<RoutePolicy>();
            Calendar currentUTC = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            if (tod != null) {
                currentUTC.setTimeInMillis(tod);
            }
            Calendar time = null;
            ArrayList<RoutePolicyRank> rankList = new ArrayList<RoutePolicyRank>();
            for (RoutePolicy policy : routePolicyList) {
                long routePolicyId = policy.getId();
                long timeZoneId = policy.getTimeZoneId();
                RoutePolicyRank rpRank = new RoutePolicyRank(policy);
                rankList.add(rpRank);
                String timeZoneName = this.timeZoneMap.get(timeZoneId);
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneName);
                time = Calendar.getInstance(timeZone);
                time.setTimeInMillis(currentUTC.getTimeInMillis());
                if (!this.policyTimeMap.containsKey(routePolicyId)) {
                    if (!log.isFineEnabled()) continue;
                    log.fine((Object)("Setting rank to null for policy " + routePolicyId + ".  Time for timeZoneId " + timeZoneId + " has hour " + time.get(11)));
                    continue;
                }
                long currentTimeOfDay = time.get(11) * 3600000 + time.get(12) * 60000;
                for (TimeOfDay timeOfDay : this.policyTimeMap.get(routePolicyId)) {
                    if (!this.timeRangeMap.containsKey(timeOfDay.getTimeRangeId())) {
                        throw new DMException("TimeRange " + timeOfDay.getTimeRangeId() + " was not found");
                    }
                    TimeRange timeRange = this.timeRangeMap.get(timeOfDay.getTimeRangeId());
                    if (!timeRange.getIncludesDayOfWeek(time.get(7)).booleanValue() || currentTimeOfDay < timeRange.getStartTime().getTime() || currentTimeOfDay > timeRange.getStopTime().getTime()) continue;
                    rpRank.setRank(timeOfDay.getRank());
                    if (log.isFineEnabled()) {
                        log.fine((Object)("Setting rank to " + timeOfDay.getRank() + " for policy " + routePolicyId + ", time range id " + timeOfDay.getTimeRangeId() + " because current time in " + timeZoneName + " is " + this.customCalendarToString(time)));
                    }
                    if (!log.isFinestEnabled()) break;
                    log.finest((Object)("Used time range " + timeRange.toString()));
                    break;
                }
                if (rpRank.getRank() != null) continue;
                log.error((Object)("Setting rank to null for RoutePolicy " + policy + " because no TimeRange match was found at time " + time + " (ignore date information)"));
            }
            Collections.sort(rankList, new RoutePolicyRanker());
            for (RoutePolicyRank rpRank : rankList) {
                returnPolicyList.add(rpRank.getRoutePolicy());
            }
            ArrayList<RoutePolicy> arrayList = returnPolicyList;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned TimeRanges.")
    public Map<Long, TimeRange> getAllTimeRanges() {
        return this.timeRangeMap;
    }

    public class RoutePolicyRanker
    implements Comparator<RoutePolicyRank> {
        @Override
        public int compare(RoutePolicyRank r1, RoutePolicyRank r2) {
            int rank = 0;
            rank = !(r1 != null && r1.getRank() != null || r2 != null && r2.getRank() != null) ? 0 : (r1 == null || r1.getRank() == null ? 1 : (r2 == null || r2.getRank() == null ? -1 : (r1.getRank().equals(r2.getRank()) ? r1.getRandomTiebreaker() - r2.getRandomTiebreaker() : r1.getRank() - r2.getRank())));
            return rank;
        }
    }

    public class RoutePolicyRank {
        private final RoutePolicy rp;
        private Integer rank;
        private int randomTiebreaker;

        public RoutePolicyRank(RoutePolicy rp) {
            this.rp = rp;
            this.rank = null;
            this.randomTiebreaker = TimeDAO.this.generator.nextInt(1000);
        }

        public RoutePolicy getRoutePolicy() {
            return this.rp;
        }

        public boolean setRank(int rank) {
            if (this.rank != null) {
                return false;
            }
            this.rank = rank;
            return true;
        }

        public Integer getRank() {
            return this.rank;
        }

        public int getRandomTiebreaker() {
            return this.randomTiebreaker;
        }

        public String toString() {
            return "[rank=" + this.rank + " random=" + this.randomTiebreaker + "]";
        }
    }
}

