/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.dao.jdbc.JDBCBasedDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.objectapi.AsmCommProfile;
import com.avaya.asm.datamgr.objectapi.User;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UserInfoOnDemandDAO {
    private static final Logger log = AsmLogger.getLogger(UserInfoOnDemandDAO.class);
    protected static final String getUser = "SELECT csuser.id, csuser.loginname, csuser.commpassword, csuser.defaultcontactlistid, csuser.defaultcommprofilesetid, csuser.givenname,csuser.givennameascii, csuser.surname, csuser.surnameascii, csuser.preferredlanguage, csuser.displayname, csuser.displaynameascii FROM csuser ";
    protected static final String getAnyUserWhere = "WHERE csuser.isdeleted=false AND csuser.id=? ";
    protected static final String getUserQuery = "SELECT csuser.id, csuser.loginname, csuser.commpassword, csuser.defaultcontactlistid, csuser.defaultcommprofilesetid, csuser.givenname,csuser.givennameascii, csuser.surname, csuser.surnameascii, csuser.preferredlanguage, csuser.displayname, csuser.displaynameascii FROM csuser WHERE csuser.isdeleted=false AND csuser.id=? ";
    protected static final String getAnyUserByCommIdWhere = ", cscommprofileset csset WHERE csuser.isdeleted=false AND csset.csuserid= csuser.id AND csset.id=? ";
    protected static final String getAnyUserByCommIdQuery = "SELECT csuser.id, csuser.loginname, csuser.commpassword, csuser.defaultcontactlistid, csuser.defaultcommprofilesetid, csuser.givenname,csuser.givennameascii, csuser.surname, csuser.surnameascii, csuser.preferredlanguage, csuser.displayname, csuser.displaynameascii FROM csuser , cscommprofileset csset WHERE csuser.isdeleted=false AND csset.csuserid= csuser.id AND csset.id=? ";
    protected static final String getCommProfile = "SELECT asm.id, set.id as sid, cs.preferredhandleid, asm.forkingpolicy, asm.simultaneous_devices, asm.origappset_id, asm.termappset_id, asm.usercommunity_id, asm.subscriptionset_id, asm.homelocation_id, asm.survivability_server_id, asm.asm_conf_factory_set_id, asm.block_reg_if_max, asm.call_logging, asm.emer_origappset_id, asm.emer_termappset_id FROM asmcommprofile asm JOIN cscommprofile cs ON asm.id=cs.id JOIN cscommprofileset set ON cs.cscommprofilesetid=set.id JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false AND cs.commprofiletype='SIP' AND set.id=?";

    private static JDBCBasedDAO getDataSource() {
        return DMFactory.getInstance().getDataSource();
    }

    protected static final ResultSetMapper getAnyUserMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ArrayList<User> userList = new ArrayList<User>();
                while (rs.next()) {
                    User user = new User(rs.getLong("id"), rs.getString("loginname"), rs.getString("commpassword"), rs.getString("displayname"), rs.getString("displaynameascii"), rs.getString("givenname"), rs.getString("givennameascii"), rs.getString("surname"), rs.getString("surnameascii"), rs.getString("preferredlanguage"), rs.getLong("defaultcontactlistid"), rs.getLong("defaultcommprofilesetid"));
                    userList.add(user);
                }
                return userList;
            }
        };
    }

    public static User getAnyUserByCommProfileSetId(Long setId) {
        Boolean isFinest = log.isFinestEnabled();
        List userList = null;
        Object[] params = new Object[]{setId};
        String fcn_name = "getAnyUserByCommProfileSetId";
        long nanos = 0L;
        if (isFinest.booleanValue()) {
            nanos = System.nanoTime();
        }
        try {
            userList = (List)UserInfoOnDemandDAO.getDataSource().executeQuery(getAnyUserByCommIdQuery, params, UserInfoOnDemandDAO.getAnyUserMapper());
        }
        catch (DMException e) {
            log.error((Object)("getAnyUserByCommProfileSetId: error obtaining a user record with setId " + setId), (Throwable)e);
        }
        if (isFinest.booleanValue()) {
            log.finest((Object)("getAnyUserByCommProfileSetId: SQL query for commprofilesetId " + setId + " took " + (System.nanoTime() - nanos) + " nsec."));
        }
        User user = null;
        if (userList != null && !userList.isEmpty()) {
            if (userList.size() > 1) {
                log.warn((Object)("getAnyUserByCommProfileSetId: there are " + userList.size() + " csuser records for setId " + setId));
            }
            user = (User)userList.get(0);
        }
        return user;
    }

    protected static final ResultSetMapper getAnyCommProfMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ArrayList<AsmCommProfile> commProfileList = new ArrayList<AsmCommProfile>();
                while (rs.next()) {
                    AsmCommProfile commProfile = new AsmCommProfile(rs.getLong("id"), rs.getLong("sid"), rs.getLong("preferredhandleid"), rs.getString("forkingpolicy"), rs.getInt("simultaneous_devices"), rs.getLong("origappset_id"), rs.getLong("termappset_id"), rs.getLong("usercommunity_id"), rs.getLong("subscriptionset_id"), rs.getLong("homelocation_id"), rs.getLong("survivability_server_id"), rs.getLong("asm_conf_factory_set_id"), rs.getBoolean("block_reg_if_max"), rs.getBoolean("call_logging"), rs.getLong("emer_origappset_id"), rs.getLong("emer_termappset_id"));
                    commProfileList.add(commProfile);
                }
                return commProfileList;
            }
        };
    }

    public static List<AsmCommProfile> getAnyCommProfile(Long commProfileSetId) {
        Object[] params = new Object[]{commProfileSetId};
        List commProfileList = null;
        Boolean isFinest = log.isFinestEnabled();
        String fcn_name = "getAnyCommProfile";
        long nanos = 0L;
        if (isFinest.booleanValue()) {
            nanos = System.nanoTime();
        }
        try {
            commProfileList = (List)UserInfoOnDemandDAO.getDataSource().executeQuery(getCommProfile, params, UserInfoOnDemandDAO.getAnyCommProfMapper());
        }
        catch (DMException e) {
            log.error((Object)("getAnyCommProfile: error obtaining a comm profile with commprofile set id " + commProfileSetId), (Throwable)e);
        }
        if (isFinest.booleanValue()) {
            log.finest((Object)("getAnyCommProfile: SQL query for commProfileSetId " + commProfileSetId + " took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return commProfileList;
    }
}

