/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CQLFileHandler;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.common.logging.client.Logger;
import java.util.Iterator;
import java.util.List;

public class CallHistoryKeyspaceBuilder
extends UserStoreKeyspaceBuilder {
    private static List<String> callHistoryCommands = null;
    private final Logger log = AsmLogger.getLogger(CallHistoryKeyspaceBuilder.class);

    public CallHistoryKeyspaceBuilder(UserStoreKeyspace keyspace) {
        super(keyspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean createColumnFamilies(SessionDAO dao) throws DMException {
        if (callHistoryCommands == null) {
            Class<CallHistoryKeyspaceBuilder> clazz = CallHistoryKeyspaceBuilder.class;
            // MONITORENTER : com.avaya.asm.datamgr.dao.cassandra.CallHistoryKeyspaceBuilder.class
            if (callHistoryCommands == null) {
                callHistoryCommands = CQLFileHandler.getInstance().readSchema("CallHistory.cql3");
                this.log.info((Object)"CallHistoryKeyspaceBuilder: Read CALL HISTORY CF schema file.");
            }
            // MONITOREXIT : clazz
        }
        if (callHistoryCommands == null) {
            this.log.error((Object)"CallHistoryKeyspaceBuilder: cached callhistory commands unexpectedly null");
            throw new DMException("CallHistoryKeyspaceBuilder: cached callhistory commands unexpectedly null");
        }
        List<String> ksCallHistoryCommands = this.getCallHistoryCommands();
        Iterator<String> iterator = ksCallHistoryCommands.iterator();
        while (iterator.hasNext()) {
            String command = iterator.next();
            dao.executeQuery(command);
        }
        return true;
    }

    public List<String> getCallHistoryCommands() throws DMException {
        return this.insertKeyspaceIntoCommand(callHistoryCommands);
    }
}

