/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.replication;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.IptBaseDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.WeakHashSet;
import com.avaya.common.logging.client.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public class DAOReplicationEventBucket {
    protected static Logger log = AsmLogger.getLogger(DAOReplicationEventBucket.class);
    protected Map<String, Set<Class<? extends DataAccessObject>>> tableDependentDAOs = new HashMap<String, Set<Class<? extends DataAccessObject>>>();

    protected DMFactory getFactory() {
        return DMFactory.getInstance();
    }

    public void init(Class<? extends DataAccessObject> daoClazz) {
        if (log.isFineEnabled()) {
            log.fine((Object)("init: Updating event bucket based on " + daoClazz.getSimpleName() + " tables..."));
        }
        DMFactory factory = this.getFactory();
        List<String> dependentTables = ((DataAccessObject)factory.getDataMgr(daoClazz)).getDependentTables();
        if (log.isFinestEnabled()) {
            log.finest((Object)("init: Updating " + daoClazz.getSimpleName() + " to listen for changes on tables " + dependentTables));
        }
        if (dependentTables != null) {
            for (String tableName : dependentTables) {
                Set<Class<? extends DataAccessObject>> daoSet = this.tableDependentDAOs.get(tableName);
                if (daoSet == null) {
                    daoSet = new WeakHashSet<Class<? extends DataAccessObject>>();
                    this.tableDependentDAOs.put(tableName, daoSet);
                }
                daoSet.add(daoClazz);
            }
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)("Recognized tables: " + this.tableDependentDAOs));
        }
    }

    public void executeEventUpdates(DAOReplicationEvent event) {
        if (event == null) {
            log.warn((Object)"Got a null event.");
            return;
        }
        if (event.getOperation() == null && event.getPrimaryTable() == null && event.getPrimaryKey() == null) {
            if (log.isFineEnabled()) {
                log.fine((Object)"Processing null event prompt to flush all queues.");
            }
            for (Class<? extends DataAccessObject> dao : this.getFactory().getAllDAOClasses()) {
                DataAccessObject curDAO = (DataAccessObject)this.getFactory().getDataMgr(dao);
                if (curDAO == null) continue;
                this.processEventQueue(curDAO);
            }
            return;
        }
        if (event.getPrimaryTable() == null) {
            log.warn((Object)("Received null table: " + event));
            return;
        }
        DAOTableEvent tableEvent = new DAOTableEvent(event);
        String tableName = tableEvent.getTableName();
        Set<Class<? extends DataAccessObject>> affectedDAOs = this.tableDependentDAOs.get(tableName);
        if (affectedDAOs == null) {
            if (!"replication_monitor".equals(tableName) && log.isFinestEnabled()) {
                log.finest((Object)("Table '" + tableName + "' not known for the bucket"));
            }
        } else {
            if (log.isFineEnabled()) {
                log.fine((Object)("Translating table change for event " + event));
            }
            if (log.isFinerEnabled()) {
                StringJoiner daos = new StringJoiner(", ");
                for (Class<? extends DataAccessObject> clazz : affectedDAOs) {
                    daos.add(clazz.getSimpleName());
                }
                log.finer((Object)("Notifying " + daos.toString()));
            }
            for (Class<? extends DataAccessObject> daoClass : this.getFactory().getAllDAOClasses()) {
                try {
                    DataAccessObject curDAO;
                    if (affectedDAOs.contains(daoClass)) {
                        curDAO = (DataAccessObject)this.getFactory().getDataMgr(daoClass);
                        if (curDAO != null) {
                            curDAO.queueUpdate(tableEvent);
                            continue;
                        }
                        log.warn((Object)("DAO Object '" + daoClass + "' associated with table '" + tableName + "' is null"));
                        continue;
                    }
                    curDAO = (DataAccessObject)this.getFactory().getDataMgr(daoClass);
                    if (curDAO == null) continue;
                    this.processEventQueue(curDAO);
                }
                catch (Exception e) {
                    log.error((Object)("Caught exception while sending " + tableEvent + " to " + daoClass), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEventQueue(DataAccessObject curDAO) {
        if (curDAO instanceof IptBaseDAO && ((IptBaseDAO)curDAO).iptcmSyncsInProgress()) {
            return;
        }
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader curDAOCL = curDAO.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(curDAOCL);
            curDAO.processEventQueue();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCl);
        }
    }
}

