/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmSettings;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.datadistributionlayer.DDLException;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterHelper;
import com.avaya.asm.datamgr.datadistributionlayer.DDLIntraClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DDLIntraClusterMemberLeader;
import com.avaya.asm.datamgr.datadistributionlayer.DDLMessageSender;
import com.avaya.asm.datamgr.datadistributionlayer.DDLUtilities;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerData;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerDataKey;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.datadistributionlayer.FragmentationAudit;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class DDLInterClusterMember
extends DataDistLayerMember {
    private static Logger log = AsmLogger.getLogger(DDLInterClusterMember.class);
    protected DDLInterClusterHelper interHelper;
    protected Timer interFragAuditTimer = null;
    protected TimerTask interFragAudit = null;
    public Long lastTimeViewRequested = 0L;

    protected DDLInterClusterMember() {
    }

    public DDLInterClusterMember(String interClusterName, DDLInterClusterHelper interHelper, String myName, DataDistLayerFactory ddlFactory) {
        super(interClusterName, myName, ddlFactory);
        this.myGroupType = GroupCommIntf.DDLGroupType.INTER_SM_CLUSTER;
        this.interHelper = interHelper;
        this.interFragAuditTimer = new Timer("FragmentationAudit", true);
    }

    public synchronized void restartFragmentationAudit(long delay) {
        if (this.interFragAuditTimer == null) {
            log.warn((Object)"InterCluster FragmentationAuditTimer is null");
            return;
        }
        Vector<String> ipAddrs = this.interHelper.getInterClusterMemberIPs();
        if (ipAddrs != null && ipAddrs.size() > 0) {
            if (log.isFineEnabled()) {
                log.fine((Object)("Fragmentation Audit rescheduled to start in " + delay + " ms."));
            }
            if (this.interFragAudit != null) {
                this.interFragAudit.cancel();
            }
            this.interFragAudit = new FragmentationAudit();
            this.interFragAuditTimer.schedule(this.interFragAudit, delay, (long)AsmSettings.getFragAuditInterval());
        }
    }

    public synchronized void startFragmentationAudit() {
        if (this.interFragAuditTimer == null) {
            log.warn((Object)"InterCluster FragmentationAuditTimer is null");
            return;
        }
        Vector<String> ipAddrs = this.interHelper.getInterClusterMemberIPs();
        if (ipAddrs != null && ipAddrs.size() > 0) {
            if (log.isFineEnabled()) {
                log.fine((Object)"Fragmentation Audit rescheduled to start now! ");
            }
            if (this.interFragAudit != null) {
                this.interFragAudit.cancel();
            }
            this.interFragAudit = new FragmentationAudit(true);
            this.interFragAuditTimer.schedule(this.interFragAudit, 0L);
        }
    }

    public void setInterHelper(DDLInterClusterHelper interHelper) {
        this.interHelper = interHelper;
    }

    @Override
    protected void createGroup() {
        DDLInterClusterHelper.KeystoreType kstype;
        DDLIntraClusterMember leader = this.ddlFactory.getIntraClusterMember();
        if (leader != null && leader instanceof DDLIntraClusterMemberLeader) {
            ((DDLIntraClusterMemberLeader)leader).clearBlackList();
        } else {
            log.warn((Object)("DDLFactory intra cluster member is " + (leader != null ? "not a leader" : "is null") + " - not clearing black list"));
        }
        Vector<String> ipAddrs = this.interHelper.getInterClusterMemberIPs();
        DDLInterClusterHelper.KeystoreType keystoreType = kstype = this.myClusterName.endsWith("_PPM") ? DDLInterClusterHelper.KeystoreType.JBOSS : DDLInterClusterHelper.KeystoreType.WAS;
        if (ipAddrs != null && this.interHelper.getMD5HashJGroupsKeyStore(kstype) != null && this.interHelper.getStorePassword() != null) {
            if (ipAddrs.size() != 0) {
                if (this.myClusterGroup == null) {
                    this.myClusterGroup = this.ddlFactory.createGroupCommIntf(this.myClusterName, this, this.interHelper.getMyIp(), ipAddrs, this.myGroupType);
                    this.restartFragmentationAudit(AsmSettings.getFragAuditInterval());
                }
            } else {
                if (this.interFragAudit != null) {
                    this.interFragAudit.cancel();
                }
                this.interFragAudit = null;
                log.info((Object)"no IP Addresses provided.  Cannot join the inter cluster, interSMcluster");
            }
        } else {
            if (this.interFragAudit != null) {
                this.interFragAudit.cancel();
            }
            this.interFragAudit = null;
            if (log.isFineEnabled()) {
                log.fine((Object)"Cannot join intercluster because my instance is still unresolved or JGroups encryption is not setup yet.");
            }
        }
    }

    @Override
    public void sendMessage(DataDistLayerMemberAddr member, DataDistLayerMessage message) throws DDLException {
        DDLMessageSender.sendMessage(member, message, true);
    }

    @Override
    public Object queryHost(DataDistLayerMemberAddr member, DataDistLayerMessage message, int timeout) {
        return DDLMessageSender.queryHost(member, message, timeout, true);
    }

    @Override
    protected boolean handleNewMember(DataDistLayerMemberAddr member, String newName) {
        boolean isFullyResolved;
        DDLIntraClusterMember leader = this.ddlFactory.getIntraClusterMember();
        if (leader instanceof DDLIntraClusterMemberLeader) {
            ((DDLIntraClusterMemberLeader)leader).removeBlackListEntry(member);
        }
        if (isFullyResolved = super.handleNewMember(member, newName)) {
            // empty if block
        }
        if (this.interFragAudit == null) {
            this.restartFragmentationAudit(AsmSettings.getFragAuditInterval());
        }
        return isFullyResolved;
    }

    @Override
    protected void handleDroppedMember(DataDistLayerMemberAddr member) {
        DDLIntraClusterMember leader = this.ddlFactory.getIntraClusterMember();
        if (leader instanceof DDLIntraClusterMemberLeader) {
            String interDroppedIp = member.getIpAddress();
            if (interDroppedIp == null) {
                log.warn((Object)("handleDroppedMember: Unknown IP address for " + member + ".  Ignoring normal processing of removing cluster data."));
            } else if (this.doMultipleMembersShareIP(member)) {
                log.warn((Object)"handleDroppedMember: Detected that multiple members in the Inter Cluster have the same IP address.  Not processing removal of cluster data list at this time. This is likely due to a recent network fragmentation");
            } else {
                if (log.isFineEnabled()) {
                    log.fine((Object)("handleDroppedMember: Invoking removeClusterData due to " + member + " leaving - using IP " + interDroppedIp));
                }
                ((DDLIntraClusterMemberLeader)leader).removeClusterData(interDroppedIp);
            }
        } else {
            log.error((Object)("Failed to remove data for cluster owned by departing member " + member));
        }
        super.handleDroppedMember(member);
    }

    @Override
    public void leaveTheGroup(boolean waitForClosed) {
        DDLIntraClusterMember leader = this.ddlFactory.getIntraClusterMember();
        if (leader != null) {
            if (leader instanceof DDLIntraClusterMemberLeader) {
                ((DDLIntraClusterMemberLeader)leader).removeClusterData(null);
            } else {
                log.error((Object)"Failed to remove data owned by other cluster members after leaving the group");
            }
        }
        super.leaveTheGroup(waitForClosed);
    }

    @Override
    public Object handleQuery(DataDistLayerMessage message, DataDistLayerMemberAddr srcMember) {
        DataDistLayerMemberAddr destination = message.getHost();
        if (destination != null && !destination.equals(this.getMyId())) {
            if (log.isFinestEnabled()) {
                log.finest((Object)("forwarding query intended for " + destination));
            }
            return this.queryHost(destination, message);
        }
        if (message.getAppId() == DataDistLayerMessage.TargetAppId.INTERNAL) {
            switch (message.getMessageType()) {
                case 19: {
                    Object view = this.getJGroupView();
                    String rtn = "JGroups: " + (view == null ? "No view" : view.toString());
                    return rtn + "\nSM: " + this.getJGroupClusterInfo();
                }
                case 25: {
                    if (message.getPayload() == null) {
                        this.lastTimeViewRequested = System.currentTimeMillis();
                    }
                    return this.getJGroupView();
                }
            }
        }
        return super.handleQuery(message, srcMember);
    }

    @Override
    protected void processInternalMessage(DataDistLayerMessage message, DataDistLayerMemberAddr sender) throws DDLException {
        switch (message.getMessageType()) {
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 24: 
            case 27: {
                DDLIntraClusterMember member;
                if (!DDLUtilities.supportsCommProfileSetIdBasedDDL(sender)) {
                    ArrayList<DataDistLayerData> list = null;
                    ArrayList<DataDistLayerData> removeList = new ArrayList<DataDistLayerData>();
                    if (message.getPayload() instanceof List) {
                        list = (ArrayList<DataDistLayerData>)message.getPayload();
                    } else if (message.getPayload() instanceof DataDistLayerData) {
                        list = new ArrayList<DataDistLayerData>();
                        list.add((DataDistLayerData)message.getPayload());
                    }
                    if (list != null) {
                        for (DataDistLayerData data : list) {
                            DataDistLayerDataKey key = data.getKey();
                            try {
                                Long setId;
                                if (key.getKeyCategory() != DataDistLayerDataKey.Category.URE_CONTACTS && key.getKeyCategory() != DataDistLayerDataKey.Category.URE_SUBSCRIPTIONS || (setId = DDLUtilities.getCommProfileSetId(Long.parseLong(key.getKeyValue()))) == null) continue;
                                if (key.getKeyCategory() == DataDistLayerDataKey.Category.URE_SUBSCRIPTIONS) {
                                    data.setData(setId);
                                }
                                if (log.isFinestEnabled()) {
                                    log.finest((Object)("Converting " + (Object)((Object)key.getKeyCategory()) + " key from " + key.getKeyValue() + " to " + setId));
                                }
                                key.setKeyValue(Long.toString(setId));
                            }
                            catch (Exception e) {
                                log.error((Object)("Received DDL Data from older SM (" + sender + ") that used AsmCommProfile ID as key, but couldn't convert to CommProfileSet ID due to " + e + ". Discarding data: " + data));
                                removeList.add(data);
                            }
                        }
                        list.removeAll(removeList);
                        if (list.isEmpty()) {
                            return;
                        }
                    }
                }
                if ((member = this.ddlFactory.getIntraClusterMember()) == null || !(member instanceof DDLIntraClusterMemberLeader)) break;
                member.processInternalMessage(message, sender);
                break;
            }
            case 20: {
                super.processInternalMessage(message, sender);
                if (log.isFineEnabled()) {
                    log.fine((Object)("Received member type from " + sender + ", and are connected so will send a bulk store"));
                }
                if (sender.equals(this.getMyId())) break;
                DDLIntraClusterMember leader = this.ddlFactory.getIntraClusterMember();
                if (leader instanceof DDLIntraClusterMemberLeader) {
                    ((DDLIntraClusterMemberLeader)leader).generateBulkStore(sender);
                    break;
                }
                log.warn((Object)"DDLFactory intra cluster member is not a leader - not generating bulk store.");
                break;
            }
            default: {
                super.processInternalMessage(message, sender);
            }
        }
    }

    protected String getJGroupClusterInfo() {
        StringBuffer infoStr = new StringBuffer("Inter Cluster Name = '" + this.myClusterName + "'");
        int count = 0;
        if (this.myClusterGroup == null) {
            infoStr.append("  Inter cluster is not connected. Our SM Instance is" + (DMUtilities.isBranch() ? " a branch, so this is proper behavior." : " a core SM, so something is probabaly not correct."));
        } else {
            infoStr.append(" Version: " + this.myClusterGroup.getClusterVersion() + "\n");
            for (DataDistLayerMemberAddr dataDistLayerMemberAddr : this.getMembers()) {
                Double version = DDLUtilities.getDDLVersion(this);
                String leader = " ";
                String us = "     ";
                if (!dataDistLayerMemberAddr.equals(this.getMyId())) {
                    DataDistLayerMessage msg = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 17, null);
                    version = dataDistLayerMemberAddr.getMemberVersion();
                    if (version == null) {
                        version = (Double)this.queryHost(dataDistLayerMemberAddr, msg, 2000);
                    }
                    if (version == null) {
                        version = 0.0;
                    }
                } else {
                    us = " --> ";
                }
                if (count++ == 0) {
                    leader = "L";
                }
                infoStr.append(leader + us + dataDistLayerMemberAddr.getHostId().toString());
                infoStr.append(" (");
                infoStr.append(dataDistLayerMemberAddr.getIpAddress());
                infoStr.append(") Version = ");
                infoStr.append(AsmCommon.versionToString(version) + "\n");
            }
            infoStr.append("\nMember Mappings:\n");
            for (Map.Entry entry : this.getMemberMapping().entrySet()) {
                infoStr.append(entry.getKey() + "=" + entry.getValue() + "\n");
            }
        }
        return infoStr.toString();
    }

    public boolean isInterSMClusterCoordinator() {
        try {
            if (this.myClusterGroup.getCurrentMembers().size() > 0 && this.myClusterGroup.getCurrentMembers().get(0).equals(this.myClusterGroup.getThisHostId())) {
                return true;
            }
        }
        catch (NullPointerException npe) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        super.destroy();
        DDLInterClusterMember dDLInterClusterMember = this;
        synchronized (dDLInterClusterMember) {
            if (this.interFragAuditTimer != null) {
                this.interFragAuditTimer.cancel();
            }
        }
    }

    public void updateForHost(String oldIp, String newIp) {
        if (!(oldIp == null && newIp == null || IPAddress.areEqual(oldIp, newIp) || this.myClusterGroup == null)) {
            this.myClusterGroup.updateForHost(oldIp, newIp);
        }
    }

    protected boolean doMultipleMembersShareIP(DataDistLayerMemberAddr leavingMbr) {
        boolean foundLeavingMbr = false;
        int numMbrSharingIp = 0;
        FQDNOrIpAddr leavingIP = new FQDNOrIpAddr(leavingMbr.getIpAddress());
        for (DataDistLayerMemberAddr addr : this.myClusterMembers) {
            if (leavingMbr.equals(addr)) {
                foundLeavingMbr = true;
            }
            if (!leavingIP.isEqualTo(addr.getIpAddress())) continue;
            ++numMbrSharingIp;
        }
        return numMbrSharingIp > 1 || !foundLeavingMbr && numMbrSharingIp >= 1;
    }
}

