/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.datadistributionlayer.DDLConstants;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.common.logging.client.Logger;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class DDLMessageStatistics {
    private static volatile DDLMessageStatistics myInstance;
    private static final Logger log;
    private Map<DataDistLayerMessage.TargetAppId, HashMap<Integer, DDLMessageData>> msgStats = new HashMap<DataDistLayerMessage.TargetAppId, HashMap<Integer, DDLMessageData>>();

    public void countRcvMessage(DataDistLayerMessage message, byte[] buffer) {
        this.countMessage(message, buffer, 1, true);
    }

    public void countSentMessage(DataDistLayerMessage message, byte[] buffer, int numMembersSent) {
        this.countMessage(message, buffer, numMembersSent, false);
    }

    private synchronized void countMessage(DataDistLayerMessage message, byte[] buffer, int numMembersSent, boolean received) {
        if (message == null) {
            return;
        }
        DDLMessageData msgData = this.getMessageData(message);
        if (received) {
            msgData.incrementRecvCount();
            msgData.increaseRecvPayloadSize(buffer.length);
        } else {
            msgData.incrementSentCount(numMembersSent);
            msgData.increaseSentPayloadSize(buffer.length);
        }
    }

    private DDLMessageData getMessageData(DataDistLayerMessage message) {
        DDLMessageData msgData;
        DataDistLayerMessage.TargetAppId appId = message.getAppId();
        Integer type = message.getMessageType();
        HashMap<Integer, DDLMessageData> appMap = this.msgStats.get((Object)appId);
        if (appMap == null) {
            appMap = new HashMap();
            this.msgStats.put(appId, appMap);
            msgData = new DDLMessageData();
            appMap.put(type, msgData);
        } else {
            msgData = appMap.get(type);
            if (msgData == null) {
                msgData = new DDLMessageData();
                appMap.put(message.getMessageType(), msgData);
            }
        }
        return msgData;
    }

    public void resetStatistics() {
        if (log.isFinestEnabled()) {
            log.finest((Object)"Clear all DDLMessageStatistics");
        }
        this.msgStats.clear();
    }

    public void resetStatistics(DataDistLayerMessage.TargetAppId appId) {
        HashMap<Integer, DDLMessageData> appMsgStats;
        if (log.isFinestEnabled()) {
            log.finest((Object)("Clear DDLMessageStatistics for " + appId.toString()));
        }
        if ((appMsgStats = this.msgStats.get((Object)appId)) != null) {
            appMsgStats.clear();
        }
    }

    public void resetStatistics(DataDistLayerMessage.TargetAppId appId, int type) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final DDLMessageStatistics getInstance() {
        if (myInstance != null) return myInstance;
        Class<DDLMessageStatistics> clazz = DDLMessageStatistics.class;
        synchronized (DDLMessageStatistics.class) {
            if (myInstance != null) return myInstance;
            myInstance = new DDLMessageStatistics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return myInstance;
        }
    }

    public Map<DataDistLayerMessage.TargetAppId, HashMap<Integer, DDLMessageData>> getMsgStats() {
        return this.msgStats;
    }

    public String getAllMessageStatsAsString() {
        StringBuffer retBuf = new StringBuffer();
        for (Map.Entry<DataDistLayerMessage.TargetAppId, HashMap<Integer, DDLMessageData>> entry : this.msgStats.entrySet()) {
            DataDistLayerMessage.TargetAppId appId = entry.getKey();
            HashMap<Integer, DDLMessageData> appMap = entry.getValue();
            retBuf.append("===== ");
            retBuf.append((Object)appId);
            retBuf.append(" =====\n");
            if (appMap == null) {
                retBuf.append("null");
                continue;
            }
            for (Map.Entry<Integer, DDLMessageData> subentry : appMap.entrySet()) {
                retBuf.append(this.messageTypeToString(appId, subentry.getKey()) + "\n   " + subentry.getValue().toString() + "\n");
            }
        }
        return retBuf.toString();
    }

    private String messageTypeToString(DataDistLayerMessage.TargetAppId appId, int messageType) {
        Class clazz;
        switch (appId) {
            case ASM_CALL_PROC_SERVLET: {
                clazz = DDLConstants.DDLMessageTypes.AsmCallProcServletMessages.class;
                break;
            }
            case CALLADMCONTROL: {
                clazz = DDLConstants.DDLMessageTypes.CACMessages.class;
                break;
            }
            case EVENTPROXY: {
                clazz = DDLConstants.DDLMessageTypes.EventProxy.class;
                break;
            }
            case INTERNAL: {
                clazz = DDLConstants.DDLMessageTypes.DDLInternalMessages.class;
                break;
            }
            case MTCAGENT: {
                clazz = DDLConstants.DDLMessageTypes.MtcAgentMessages.class;
                break;
            }
            case MGMT_REQ: {
                clazz = DDLConstants.DDLMessageTypes.MgmtQueryMessages.class;
                break;
            }
            default: {
                return Integer.toString(messageType);
            }
        }
        try {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                if (f.getInt(null) != messageType) continue;
                return f.getName();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return Integer.toString(messageType);
    }

    static {
        log = AsmLogger.getLogger(DDLMessageStatistics.class);
    }

    private static class DDLMessageData {
        private int sent_count = 0;
        private int sent_payloadSize = 0;
        private int recv_count = 0;
        private int recv_payloadSize = 0;

        private void incrementSentCount(int i) {
            this.sent_count += i;
        }

        private void increaseSentPayloadSize(int payloadSize) {
            this.sent_payloadSize += payloadSize;
        }

        private void incrementRecvCount() {
            this.recv_count = this.sent_count + 1;
        }

        private void increaseRecvPayloadSize(int payloadSize) {
            this.recv_payloadSize = this.sent_payloadSize + payloadSize;
        }

        public String toString() {
            return "sent count / payload size (bytes) = " + Integer.toString(this.sent_count) + " / " + this.sent_payloadSize + "\t|\trecv count / payload size (bytes) = " + Integer.toString(this.recv_count) + " / " + this.recv_payloadSize;
        }
    }
}

