/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.ConfigFileEntryException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.dao.AsmCommProfileDAO;
import com.avaya.asm.datamgr.dao.jdbc.JDBCBasedDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DDLIntraClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.objectapi.AsmCommProfile;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.common.logging.client.Logger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class DDLUtilities {
    protected static final Logger log = AsmLogger.getLogger(DDLUtilities.class);
    protected static final String getClusterVersionSQL_Local = "SELECT value FROM asmlocalparm WHERE name = 'MIN_SM_VERSION';";
    private static JDBCBasedDAO dataSource = null;
    protected static Double version = null;

    public static void setJUnitDataSource(JDBCBasedDAO dataSource) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalArgumentException("Attempt to set DataSource outside JUnit!");
        }
        DDLUtilities.dataSource = dataSource;
    }

    protected static JDBCBasedDAO getAsmLocalDataSource() {
        if (AsmCommon.jUnitEnvironment) {
            return dataSource;
        }
        return DMFactory.getInstance().getLocalDataSource();
    }

    public static String getEth0IP() {
        return DDLUtilities.getEth0v4IP();
    }

    public static String getEth0v4IP() {
        List<String> eth0ips = DDLUtilities.getEth0IPs(IPAddress.IPAddressFamily.IPV4);
        return eth0ips.isEmpty() ? null : eth0ips.get(0);
    }

    public static String getEth0v6IP() {
        List<String> eth0ips = DDLUtilities.getEth0IPs(IPAddress.IPAddressFamily.IPV6);
        return eth0ips.isEmpty() ? null : eth0ips.get(0);
    }

    public static List<String> getEth0IPs(IPAddress.IPAddressFamily addrType) {
        ArrayList<String> eth0ips = new ArrayList<String>();
        ArrayList<String> localIps = new ArrayList<String>();
        try {
            NetworkInterface nif = NetworkInterface.getByName("eth0");
            Enumeration<InetAddress> addresses = nif.getInetAddresses();
            ArrayList<String> virtualInet = new ArrayList<String>();
            for (NetworkInterface n : Collections.list(nif.getSubInterfaces())) {
                for (InetAddress addr : Collections.list(n.getInetAddresses())) {
                    virtualInet.add(addr.getHostAddress());
                }
            }
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if ((addrType == IPAddress.IPAddressFamily.IPV6 || !(address instanceof Inet4Address)) && (addrType == IPAddress.IPAddressFamily.IPV4 || !(address instanceof Inet6Address)) || virtualInet.contains(address.getHostAddress())) continue;
                if (address.isLinkLocalAddress() || address.isSiteLocalAddress()) {
                    localIps.add(address.getHostAddress());
                    continue;
                }
                eth0ips.add(address.getHostAddress());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error determining the eth0 IP address.");
        }
        eth0ips.addAll(localIps);
        return eth0ips;
    }

    public static String getClusterVersion() {
        try {
            return (String)DDLUtilities.getAsmLocalDataSource().executeQuery(getClusterVersionSQL_Local, new Object[0], new ResultSetMapper(){

                @Override
                public Object mapResults(ResultSet rs) throws SQLException {
                    if (rs.next()) {
                        return rs.getString("value");
                    }
                    return "8000";
                }
            });
        }
        catch (Exception e) {
            log.error((Object)"Could not get cluster version", (Throwable)e);
            return "8000";
        }
    }

    public static double getDDLVersion(DataDistLayerMember mbr) {
        block4: {
            if (version != null) {
                return version;
            }
            try {
                version = DDLUtilities.versionToDouble();
            }
            catch (Exception e) {
                if (mbr == null || mbr.getMyId() == null || mbr.getMyId().getMemberType() == null || !mbr.getMyId().getMemberType().equals("WAS-SM")) break block4;
                log.fatal((Object)("Cannot parse our version, which is set as " + DMUtilities.getProductVersion() + ", due to " + e));
            }
        }
        if (version == null) {
            return 0.0;
        }
        return version;
    }

    public static Double versionToDouble() throws Exception {
        Double retVersion = null;
        String sVersion = DMUtilities.getProductVersion();
        try {
            String[] sections = sVersion.split("\\.");
            String gather = sections[0] + ".";
            gather = gather + DDLUtilities.padLeft(sections[1], 2, '0');
            gather = gather + DDLUtilities.padLeft(sections[2], 2, '0');
            gather = gather + DDLUtilities.padLeft(sections[3], 2, '0');
            gather = gather + DDLUtilities.padLeft(sections[4], 6, '0');
            retVersion = Double.parseDouble(gather);
        }
        catch (Exception e) {
            if (null != sVersion) {
                ConfigFileEntryException eNotFound = new ConfigFileEntryException(ConfigFileEntryException.eType.VersionFormatError, "SM Version of \"" + sVersion + "\" has invalid format");
                GenericAlarmHandler.handleFailureEvent(null, eNotFound);
            }
            DMUtilities.setProductVersion(null);
            throw e;
        }
        return retVersion;
    }

    private static String padLeft(String string, int number, char filler) {
        if (string == null) {
            return string;
        }
        int add = number - string.length();
        if (add <= 0) {
            return string;
        }
        StringBuffer str = new StringBuffer(string);
        char[] ch = new char[add];
        Arrays.fill(ch, filler);
        str.insert(0, ch);
        return str.toString();
    }

    protected static String getJgroupsWrapperClass(GroupCommIntf.JGroupsVersion currentVersion) {
        return "com.avaya.asm.datamgr.datadistributionlayer.JGroupWrapper3";
    }

    public static boolean supportsCommProfileSetIdBasedDDL(DataDistLayerMemberAddr targetAddr) {
        return DDLUtilities.isAtLeastVersion(targetAddr, 6.03);
    }

    public static boolean supportsCommProfileSetIdBasedDDL(DataDistLayerMemberAddr targetAddr, Double version) {
        return DDLUtilities.isAtLeastVersion(targetAddr, version, 6.03);
    }

    public static boolean isAtLeastVersion(DataDistLayerMemberAddr targetAddr, Double version) {
        if (targetAddr == null) {
            log.warn((Object)"isAtLeastVersion: targetAddr = null!");
            return false;
        }
        Double memberVersion = DDLUtilities.getMemberVersion(targetAddr);
        return DDLUtilities.isAtLeastVersion(targetAddr, memberVersion, version);
    }

    public static boolean isAtLeastVersion(DataDistLayerMemberAddr targetAddr, Double targetAddrVersion, Double version) {
        if (targetAddrVersion == null) {
            log.warn((Object)("isAtLeastVersion(" + targetAddrVersion + ", " + version + "): could not determine version; assuming older"));
            return false;
        }
        if (targetAddrVersion < version) {
            if (log.isFinestEnabled()) {
                log.finest((Object)("isAtLeastVersion(" + targetAddrVersion + ", " + version + "): Backwards compatibility situation detected (Version = " + targetAddrVersion + ") for " + targetAddr));
            }
            return false;
        }
        return true;
    }

    public static Double getMemberVersion(DataDistLayerMemberAddr targetAddr) {
        Double otherNodeVersion = targetAddr.getMemberVersion();
        if (otherNodeVersion == null) {
            DDLIntraClusterMember intraClusterMember = DataDistLayerFactory.getInstance().getIntraClusterMember();
            DataDistLayerMemberAddr myAddr = intraClusterMember.getMyId();
            if (IPAddress.areEqual(myAddr.getIpAddress(), targetAddr.getIpAddress())) {
                return DDLUtilities.getDDLVersion(intraClusterMember);
            }
            DDLInterClusterMember inter = DataDistLayerFactory.getInstance().getInterClusterMember();
            List<DataDistLayerMemberAddr> interMembers = inter != null ? inter.getMembers() : null;
            String targetIp = targetAddr.getIpAddress();
            if (targetIp != null && interMembers != null) {
                FQDNOrIpAddr targetIpAddr = new FQDNOrIpAddr(targetIp);
                for (DataDistLayerMemberAddr addr : interMembers) {
                    if (!targetIpAddr.isEqualTo(addr.getIpAddress())) continue;
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("isAtLeastVersion(" + targetAddr.getIpAddress() + "): found target addr outside of this intra cluster.  Found in inter cluster with " + addr));
                    }
                    otherNodeVersion = addr.getMemberVersion();
                    break;
                }
            }
        }
        return otherNodeVersion;
    }

    public static Long getCommProfileSetId(Long asmCommProfileId) {
        if (AsmCommon.jUnitEnvironment) {
            return 1L;
        }
        AsmCommProfile profile = ((AsmCommProfileDAO)DMFactory.getInstance().getDataMgr(AsmCommProfileDAO.class)).getAsmCommProfile(asmCommProfileId);
        if (profile != null) {
            return profile.getCsCommProfileSetId();
        }
        return null;
    }

    public static Long getAsmCommProfileId(Long commProfileSetId) {
        if (AsmCommon.jUnitEnvironment) {
            return 1L;
        }
        AsmCommProfile profile = ((AsmCommProfileDAO)DMFactory.getInstance().getDataMgr(AsmCommProfileDAO.class)).getAsmCommProfileBySetId(commProfileSetId);
        if (profile != null) {
            return profile.getId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getManagementIP() {
        Class<DDLUtilities> clazz = DDLUtilities.class;
        synchronized (DDLUtilities.class) {
            String mgmtIP = DMUtilities.readPropFile("/opt/Avaya/install.properties", "MgmtIP");
            if (mgmtIP != null) {
                mgmtIP = mgmtIP.trim();
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            log.info((Object)("MgmtIP in /opt/Avaya/install.properties is " + mgmtIP + "."));
            return mgmtIP;
        }
    }
}

