/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.loadrules;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LoadRule {
    public static final String DELIMITER = ";";
    public static final String IMPLEMENTATION_CLASS = "IMPL";
    public static final String PERMANENT_DATAMGR = "PERM";
    private boolean isPermanentDataMgr = false;
    private String dataMgrImplementationClass = null;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public LoadRule(String parameterString) throws ParseException {
        if (parameterString != null) {
            this.parseParameters(parameterString);
        }
    }

    private void parseParameters(String parameterString) throws ParseException {
        String[] parameters;
        block16: for (String parameter : parameters = parameterString.split(DELIMITER)) {
            String[] keyValue = parameter.split("=");
            switch (keyValue.length) {
                case 1: {
                    String value = keyValue[0].trim();
                    if (value.length() <= 0) continue block16;
                    switch (value) {
                        case "PERM": {
                            this.isPermanentDataMgr = true;
                            continue block16;
                        }
                    }
                    this.parameters.put(value, null);
                    continue block16;
                }
                case 2: {
                    String key = keyValue[0].trim();
                    if (key.length() == 0) {
                        throw new ParseException("Zero-length key in load rule \"" + parameterString + "\"", 0);
                    }
                    String value = keyValue[1].trim();
                    switch (key) {
                        case "IMPL": {
                            this.dataMgrImplementationClass = value;
                            continue block16;
                        }
                    }
                    this.parameters.put(key, value);
                    continue block16;
                }
                default: {
                    throw new ParseException("Failed to parse load rule \"" + parameterString + "\"", 0);
                }
            }
        }
    }

    public boolean isPermanentDataMgr() {
        return this.isPermanentDataMgr;
    }

    public String getDataMgrImplementationClass() {
        return this.dataMgrImplementationClass;
    }

    public String getValue(String key) {
        return this.parameters.get(key);
    }

    public boolean contains(String key) {
        return this.parameters.containsKey(key);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LoadRule[");
        builder.append(this.parameters);
        builder.append("]");
        return builder.toString();
    }
}

