/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.DigitBasedRow;
import java.math.BigInteger;
import java.util.List;

public class DigitMapRow
extends DigitBasedRow {
    private final boolean deny;
    private final Long routingOrigId;
    private final Long origPatternSetId;
    private final boolean treatAsEmergency;

    public DigitMapRow(long id, short min, short max, String digits, boolean deny, Long routingOrigId, Long sipDomainId, Long origPatternSetId, boolean treatAsEmergency) {
        super(id, min, max, digits, sipDomainId);
        this.deny = deny;
        this.routingOrigId = routingOrigId;
        this.origPatternSetId = origPatternSetId;
        this.treatAsEmergency = treatAsEmergency;
    }

    public DigitMapRow(short length, String digits, DigitMapRow row) {
        this(row.getId(), length, length, digits, row.deny, row.routingOrigId, row.getSipDomainId(), row.origPatternSetId, row.treatAsEmergency);
    }

    public boolean getDeny() {
        return this.deny;
    }

    public boolean getTreatAsEmergency() {
        return this.treatAsEmergency;
    }

    public Long getRoutingOrigId() {
        return this.routingOrigId;
    }

    public Long getOrigPatternSetId() {
        return this.origPatternSetId;
    }

    public List<DigitMapRow> getSubrows() {
        return super.getSubrows(DigitMapRow.class);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitMapRow)) {
            return false;
        }
        DigitMapRow other = (DigitMapRow)object;
        if (!super.equals(other)) {
            return false;
        }
        if (this.routingOrigId != null && !this.routingOrigId.equals(other.routingOrigId) || this.routingOrigId == null && other.routingOrigId != null) {
            return false;
        }
        return (this.origPatternSetId == null || this.origPatternSetId.equals(other.origPatternSetId)) && (this.origPatternSetId != null || other.origPatternSetId == null);
    }

    @Override
    public int hashCode() {
        int hash = 23;
        hash = hash * 37 + super.hashCode();
        hash = hash * 37 + (this.routingOrigId == null ? 0 : (int)(this.routingOrigId ^ this.routingOrigId >>> 32));
        hash = hash * 37 + (this.origPatternSetId == null ? 0 : (int)(this.origPatternSetId ^ this.origPatternSetId >>> 32));
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("DigitMapRow[id=" + this.getId() + ": " + this.getDigits() + "/" + this.getMin() + "/" + this.getMax() + " loc=" + this.routingOrigId + " dom=" + this.getSipDomainId() + " osetid=" + this.origPatternSetId);
        if (this.deny) {
            buf.append(" deny");
        }
        if (this.treatAsEmergency) {
            buf.append(" emrg");
        }
        if (this.getWidth(false) != null) {
            buf.append(" width=" + new BigInteger(this.getWidth(false)));
        }
        buf.append("]");
        return buf.toString();
    }
}

