/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.objectapi.DigitTree;
import com.avaya.asm.datamgr.objectapi.DigitTreeDigitNode;
import com.avaya.asm.datamgr.objectapi.DigitTreeNode;
import com.avaya.asm.datamgr.objectapi.DigitTreeNodeMatcher;
import com.avaya.asm.datamgr.objectapi.DigitTreeObjectNodeMatch;
import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.util.TreeSet;

public class DigitTreeObjectNode<E>
implements DigitTreeNode<E>,
Serializable {
    private static final Logger log = AsmLogger.getLogger(DigitTreeObjectNode.class);
    private static final long serialVersionUID = -7329525264108588684L;
    private final short min;
    private final short max;
    private DigitTreeNode<E> subtree;
    private E object;

    public DigitTreeObjectNode(DigitTree<E> tree, DigitTreeNode<E> subtree, short min, short max, E object) {
        this.min = min;
        this.max = max;
        this.object = object;
        this.subtree = subtree;
    }

    public short getMinimumDigits() {
        return this.min;
    }

    public short getMaximumDigits() {
        return this.max;
    }

    public E getObject() {
        return this.object;
    }

    @Override
    public synchronized DigitTreeObjectNodeMatch<E> findBestMatch(DigitTree<E> tree, int depth, String digits, DigitTreeNodeMatcher<E> matcher) {
        int length;
        DigitTreeObjectNodeMatch<E> subMatch = null;
        if (this.subtree != null) {
            subMatch = this.subtree.findBestMatch(tree, depth, digits, matcher);
        }
        if ((length = digits.length()) >= this.min && length <= this.max && matcher.matches(this.object)) {
            DigitTreeObjectNodeMatch thisMatch = new DigitTreeObjectNodeMatch(this, depth);
            return matcher.pickBetterMatch(thisMatch, subMatch);
        }
        return subMatch;
    }

    @Override
    public synchronized void getAllMatches(DigitTree<E> tree, int depth, String digits, DigitTreeNodeMatcher<E> matcher, TreeSet<E> set) {
        int length;
        if (this.subtree != null) {
            this.subtree.getAllMatches(tree, depth, digits, matcher, set);
        }
        if ((length = digits.length()) >= this.min && length <= this.max && matcher.matches(this.object)) {
            set.add(this.object);
        }
    }

    @Override
    public synchronized void insert(DigitTree<E> tree, int depth, String digits, short insertMin, short insertMax, E insertObject, DigitTreeNodeMatcher<E> matcher) {
        if (log.isFinestEnabled()) {
            log.finest((Object)("insert(" + digits + "/" + this.min + "/" + this.max + ") inserting " + this.object + " at depth " + depth));
        }
        if (this.subtree == null) {
            this.subtree = new DigitTreeDigitNode<E>(tree);
        }
        this.subtree.insert(tree, depth, digits, insertMin, insertMax, insertObject, matcher);
    }

    @Override
    public synchronized boolean insertedInSubtree(DigitTree<E> tree, int depth, String digits, short insertMin, short insertMax, E insertObject, DigitTreeNodeMatcher<E> matcher) {
        if (log.isFinestEnabled()) {
            log.finest((Object)("insertedInSubtree(" + digits + "/" + this.min + "/" + this.max + ") inserting " + this.object + " at depth " + depth));
        }
        if (!matcher.allowInsertion(this, digits, insertMin, insertMax, insertObject)) {
            log.error((Object)("Insertion denied for " + digits + "/" + insertMin + "/" + insertMax + " " + this.object + " at depth " + depth));
            throw new UnsupportedOperationException("Insertion denied");
        }
        if (this.subtree == null || !this.subtree.insertedInSubtree(tree, depth, digits, insertMin, insertMax, insertObject, matcher)) {
            this.subtree = new DigitTreeObjectNode<E>(tree, this.subtree, insertMin, insertMax, insertObject);
        }
        return true;
    }

    @Override
    public synchronized DigitTreeNode<E> delete(DigitTree<E> tree, int depth, String digits, short deleteMin, short deleteMax, DigitTreeNodeMatcher<E> matcher) {
        if (digits.length() == depth && this.min == deleteMin && this.max == deleteMax && matcher.matches(this.object)) {
            return this.subtree;
        }
        if (this.subtree == null) {
            log.error((Object)("Delete null subnode digits=" + digits + " min/max=" + this.min + "/" + this.max + " depth=" + depth));
            throw new UnsupportedOperationException("Pattern/min/max not found");
        }
        this.subtree = this.subtree.delete(tree, depth, digits, deleteMin, deleteMax, matcher);
        return this;
    }

    @Override
    public synchronized void update(DigitTree<E> tree, int depth, String digits, short updateMin, short updateMax, E updateObject, DigitTreeNodeMatcher<E> matcher) {
        if (digits.length() == depth && this.min == updateMin && this.max == updateMax && matcher.matches(this.object)) {
            this.object = updateObject;
            return;
        }
        if (this.subtree == null) {
            log.error((Object)("Null route subtree digits=" + digits + " depth=" + depth));
            throw new UnsupportedOperationException("Pattern/min/max not found");
        }
        this.subtree.update(tree, depth, digits, updateMin, updateMax, updateObject, matcher);
    }

    @Override
    public synchronized StringBuffer dumpNode(DigitTree<E> tree, String currentDigits) {
        StringBuffer buf = new StringBuffer(32);
        buf.append("DT: pattern:");
        buf.append(currentDigits);
        buf.append(" min/max=");
        buf.append(this.min);
        buf.append("/");
        buf.append(this.max);
        buf.append(" ");
        buf.append(this.object.toString());
        buf.append("\n");
        if (this.subtree != null) {
            buf.append(this.subtree.dumpNode(tree, currentDigits));
        }
        return buf;
    }

    public String toString() {
        return "DigitTreeObjectNode[min=" + this.min + " max=" + this.max + " object=" + this.object + "]";
    }

    public static void setLogLevelForJUnit() {
        log.setLevel(LogLevel.INFO);
    }
}

