/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.IPv4Address;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;

public class IPv6Address
extends IPAddress {
    private static final long serialVersionUID = -5630752194272369180L;

    public IPv6Address(String string) throws ParseException {
        string = this.procZoneId(string);
        this.groups = new char[8];
        if (string.isEmpty()) {
            throw new ParseException("Empty string", 0);
        }
        ArrayList<String> hextetStrings = new ArrayList<String>(Arrays.asList(string.split(":")));
        if (string.endsWith(":::")) {
            throw new ParseException("Too many colons at end: \"" + string + "\"", 0);
        }
        if (string.endsWith(":")) {
            if (string.endsWith("::")) {
                hextetStrings.add("");
            } else {
                throw new ParseException("Address cannot end with single colon: \"" + string + "\"", 0);
            }
        }
        if (string.startsWith(":")) {
            if (string.startsWith("::")) {
                hextetStrings.remove(0);
            } else {
                throw new ParseException("Address cannot start with single colon: \"" + string + "\"", 0);
            }
        }
        if (hextetStrings.size() == 0) {
            if ("::".equals(string)) {
                return;
            }
            throw new ParseException("Invalid empty hextets: \"" + string + "\"", 0);
        }
        try {
            int size = hextetStrings.size();
            if (size > 0) {
                IPv4Address ipv4Address = new IPv4Address((String)hextetStrings.get(size - 1));
                hextetStrings.remove(size - 1);
                char[] octets = ipv4Address.getGroups();
                hextetStrings.add(String.format("%x", octets[0] << 8 | octets[1]));
                hextetStrings.add(String.format("%x", octets[2] << 8 | octets[3]));
            }
        }
        catch (ParseException size) {
            // empty catch block
        }
        if (hextetStrings.size() > 8) {
            throw new ParseException("Too many hextets in \"" + string + "\"", 0);
        }
        boolean expanded = false;
        int index = 0;
        for (int i = 0; i < hextetStrings.size(); ++i) {
            int hextet;
            if ("".equals(hextetStrings.get(i))) {
                if (expanded) {
                    throw new ParseException("Multiple :: in \"" + string + "\"", 0);
                }
                index += 9 - hextetStrings.size();
                expanded = true;
                continue;
            }
            String hextetString = (String)hextetStrings.get(i);
            if (hextetString.length() > 4) {
                throw new ParseException("Hextet too long in \"" + string + "\"", 0);
            }
            try {
                hextet = Integer.valueOf(hextetString, 16);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid hextet in \"" + string + "\"", 0);
            }
            if (hextet < 0 || hextet > 65535) {
                throw new ParseException("Invalid hextet in \"" + string + "\"", 0);
            }
            this.groups[index++] = (char)hextet;
        }
        if (index != 8) {
            throw new ParseException("Not enough hextets in \"" + string + "\"", 0);
        }
    }

    public IPv6Address(char[] groups) throws ParseException {
        if (groups.length != 8) {
            throw new ParseException("Invalid group length: " + groups.length, 0);
        }
        this.groups = groups;
    }

    @Override
    public IPAddress.IPAddressFamily getAddressFamily() {
        return IPAddress.IPAddressFamily.IPV6;
    }

    @Override
    public IPAddress createMask(int maskLength) throws Exception {
        if (maskLength < 0 || maskLength > 128) {
            throw new Exception("Bad maskLength");
        }
        char[] maskGroups = new char[8];
        for (int i = 0; i < maskLength; ++i) {
            int idx;
            int bit = 127 - i;
            int n = idx = 7 - bit / 16;
            maskGroups[n] = (char)(maskGroups[n] | 1 << bit % 16);
        }
        return new IPv6Address(maskGroups);
    }

    @Override
    public String toString(boolean expandedForm, boolean includeZoneId) {
        StringBuilder builder = new StringBuilder();
        if (this.groups[5] == '\uffff' && this.groups[0] == '\u0000' && this.groups[1] == '\u0000' && this.groups[2] == '\u0000' && this.groups[3] == '\u0000' && this.groups[4] == '\u0000') {
            builder.append(expandedForm ? "0:0:0:0:0:ffff:" : "::ffff:");
            int oct1 = this.groups[6] >> 8 & 0xFF;
            int oct2 = this.groups[6] & 0xFF;
            int oct3 = this.groups[7] >> 8 & 0xFF;
            int oct4 = this.groups[7] & 0xFF;
            builder.append(oct1);
            builder.append('.');
            builder.append(oct2);
            builder.append('.');
            builder.append(oct3);
            builder.append('.');
            builder.append(oct4);
        } else {
            int longestZeroIndex = -1;
            int longestZeroLength = 0;
            if (!expandedForm) {
                int zeroIndex = -1;
                int zeroLength = 0;
                for (int i = 0; i < 9; ++i) {
                    if (i < 8 && this.groups[i] == '\u0000') {
                        if (zeroIndex == -1) {
                            zeroIndex = i;
                            zeroLength = 1;
                            continue;
                        }
                        ++zeroLength;
                        continue;
                    }
                    if (zeroIndex == -1 || zeroLength <= longestZeroLength) continue;
                    longestZeroIndex = zeroIndex;
                    longestZeroLength = zeroLength;
                    zeroIndex = -1;
                }
                if (longestZeroLength < 2) {
                    longestZeroIndex = -1;
                    longestZeroLength = 0;
                }
            }
            for (int i = 0; i < 8; ++i) {
                if (i == longestZeroIndex) {
                    builder.append(i == 0 ? "::" : ":");
                    continue;
                }
                if (i >= longestZeroIndex && i < longestZeroIndex + longestZeroLength) continue;
                builder.append(String.format("%x", this.groups[i]));
                if (i >= 7) continue;
                builder.append(':');
            }
        }
        if (includeZoneId && this.zoneId != null) {
            builder.append('%');
            builder.append(this.zoneId);
        }
        return builder.toString();
    }
}

