/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.ResolvedIPAddress;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class ResolvedName
implements Serializable {
    private static final long serialVersionUID = -7431332663177826297L;
    private transient Logger log = AsmLogger.getLogger(ResolvedName.class);
    private volatile AtomicLong id;
    private final String fqdn;
    private volatile AtomicLong ttlExpiration = new AtomicLong(0L);
    private final List<ResolvedIPAddress> priorityList = new CopyOnWriteArrayList<ResolvedIPAddress>();
    private final boolean useRFC3263;

    public ResolvedName(Long id, String fqdn) {
        this(id, fqdn, false);
    }

    public ResolvedName(String fqdn, boolean useRFC3263) {
        this(null, fqdn, useRFC3263);
    }

    public ResolvedName(String fqdn, boolean useRFC3263, long ttl) {
        this(fqdn, useRFC3263);
        this.setTtlExpiration(ttl);
    }

    public ResolvedName(Long id, String fqdn, boolean useRFC3263) {
        this.id = id == null ? null : new AtomicLong(id);
        this.fqdn = fqdn;
        this.useRFC3263 = useRFC3263;
    }

    public Long getId() {
        if (this.id == null) {
            return null;
        }
        return this.id.get();
    }

    public void setId(Long id) {
        this.id = id == null ? null : new AtomicLong(id);
    }

    public String getFqdn() {
        return this.fqdn;
    }

    public boolean getUseRFC3263() {
        return this.useRFC3263;
    }

    public void setTtlExpiration(long ttl) {
        this.ttlExpiration.set(this.getTimeInMillis() + ttl * 1000L);
    }

    public Long getTTLExpiration() {
        return this.ttlExpiration.get();
    }

    public synchronized void addResolvedIP(ResolvedIPAddress newAddress) {
        int index = 0;
        if (!this.priorityList.contains(newAddress)) {
            for (ResolvedIPAddress address : this.priorityList) {
                if (address.getPriority() >= newAddress.getPriority()) {
                    this.priorityList.add(index, newAddress);
                    return;
                }
                ++index;
            }
            this.priorityList.add(newAddress);
        }
    }

    public synchronized ResolvedIPAddress remove(long id) {
        for (ResolvedIPAddress address : this.priorityList) {
            if (address.getId() != id) continue;
            this.priorityList.remove(address);
            return address;
        }
        this.log.error((Object)("remove() failed to find " + id + " in priority list"));
        return null;
    }

    public synchronized ResolvedIPAddress remove(String ipAddress) {
        IPAddress ipAddr = IPAddress.fromString(ipAddress);
        if (ipAddr != null) {
            for (ResolvedIPAddress address : this.priorityList) {
                if (!ipAddr.isEqualTo(address.getIpaddress())) continue;
                this.priorityList.remove(address);
                return address;
            }
        }
        this.log.error((Object)("remove() failed to find " + ipAddress + " in priority list"));
        return null;
    }

    public synchronized ResolvedIPAddress remove(ResolvedIPAddress ipAddress) {
        if (ipAddress == null) {
            return null;
        }
        for (ResolvedIPAddress address : this.priorityList) {
            if (!address.equals(ipAddress)) continue;
            this.priorityList.remove(address);
            return address;
        }
        this.log.error((Object)("remove() failed to find " + ipAddress + " in priority list"));
        return null;
    }

    public boolean hasAddress(String address, String transport) {
        IPAddress ipAddr = IPAddress.fromString(address);
        if (ipAddr != null) {
            for (ResolvedIPAddress addr : this.priorityList) {
                if (addr.getTransportprotocol() == null || !addr.getTransportprotocol().equalsIgnoreCase(transport) || !ipAddr.isEqualTo(addr.getIpaddress())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAddressAndPort(String address, String transport, int port) {
        IPAddress ipAddr = IPAddress.fromString(address);
        if (ipAddr != null) {
            for (ResolvedIPAddress addr : this.priorityList) {
                if (addr.getTransportprotocol() == null || addr.getPortnumber() != port || !addr.getTransportprotocol().equalsIgnoreCase(transport) || !ipAddr.isEqualTo(addr.getIpaddress())) continue;
                return true;
            }
        }
        return false;
    }

    public List<ResolvedIPAddress> getAddresses() {
        return Collections.unmodifiableList(this.priorityList);
    }

    protected long getTimeInMillis() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fqdn == null ? 0 : this.fqdn.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.priorityList == null ? 0 : this.priorityList.hashCode());
        result = 31 * result + (this.ttlExpiration == null ? 0 : this.ttlExpiration.hashCode());
        result = 31 * result + (this.useRFC3263 ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResolvedName other = (ResolvedName)obj;
        if (this.fqdn == null ? other.fqdn != null : !this.fqdn.equals(other.fqdn)) {
            return false;
        }
        if (this.id == null) {
            if (other.id != null) {
                return false;
            }
        } else {
            if (other.id == null) {
                return false;
            }
            if (this.id.get() != other.id.get()) {
                return false;
            }
        }
        if (this.priorityList == null ? other.priorityList != null : !this.priorityList.equals(other.priorityList)) {
            return false;
        }
        if (this.ttlExpiration == null) {
            if (other.ttlExpiration != null) {
                return false;
            }
        } else {
            if (other.ttlExpiration == null) {
                return false;
            }
            if (this.ttlExpiration.get() != other.ttlExpiration.get()) {
                return false;
            }
        }
        return this.useRFC3263 == other.useRFC3263;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return "ResolvedName[id=" + this.id + " fqdn=" + this.fqdn + " ttl=" + dateFormat.format(this.ttlExpiration.get()) + " addresses: " + this.priorityList;
    }
}

