/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi.ppm;

import com.avaya.asm.datamgr.helpers.StringArrayBytes;
import java.sql.Timestamp;
import java.util.Arrays;

public class CsPrivateContactInfo {
    static final int stringIndexSize = StringIndex.values().length;
    private long id;
    private long csPersonId;
    private boolean isCsUserid;
    private long ownerId;
    private Timestamp updateDateTime;
    private byte[] stringData;

    public CsPrivateContactInfo(long id, String displayName, String notes, long cspersonid, boolean isCsUserid, long ownerid, Timestamp updateDateTime) {
        this.id = id;
        this.csPersonId = cspersonid;
        this.isCsUserid = isCsUserid;
        this.ownerId = ownerid;
        String[] strArray = new String[stringIndexSize];
        strArray[StringIndex.DISPLAYNAME.ordinal()] = displayName;
        strArray[StringIndex.NOTES.ordinal()] = notes;
        this.updateDateTime = updateDateTime;
        this.stringData = StringArrayBytes.encode(strArray);
    }

    public long getId() {
        return this.id;
    }

    public String getDisplayName() {
        return StringArrayBytes.getString(this.stringData, StringIndex.DISPLAYNAME.ordinal());
    }

    public String getNotes() {
        return StringArrayBytes.getString(this.stringData, StringIndex.NOTES.ordinal());
    }

    public long getCspersonid() {
        return this.csPersonId;
    }

    public boolean isCsUserId() {
        return this.isCsUserid;
    }

    public long getOwnerid() {
        return this.ownerId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.csPersonId ^ this.csPersonId >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.isCsUserid ? 1231 : 1237);
        result = 31 * result + (int)(this.ownerId ^ this.ownerId >>> 32);
        result = 31 * result + Arrays.hashCode(this.stringData);
        result = 31 * result + (this.updateDateTime == null ? 0 : this.updateDateTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CsPrivateContactInfo other = (CsPrivateContactInfo)obj;
        if (this.csPersonId != other.csPersonId) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.isCsUserid != other.isCsUserid) {
            return false;
        }
        if (this.ownerId != other.ownerId) {
            return false;
        }
        if (!Arrays.equals(this.stringData, other.stringData)) {
            return false;
        }
        return !(this.updateDateTime == null ? other.updateDateTime != null : !this.updateDateTime.equals(other.updateDateTime));
    }

    public String toString() {
        return "CsPrivateContactInfo[id: " + this.id + ", displayName: " + this.getDisplayName() + ", notes: " + this.getNotes() + ", cspersonid: " + this.csPersonId + ", isCsUserid: " + this.isCsUserid + ", ownerid: " + this.ownerId + ", updateDateTime: " + this.updateDateTime + "]";
    }

    public void setUpdateDateTime(Timestamp updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

    public Timestamp getUpdateDateTime() {
        return this.updateDateTime;
    }

    static enum StringIndex {
        DISPLAYNAME,
        NOTES;

    }
}

