/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.tools;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.DebugDM;
import com.avaya.asm.datamgr.DebugDMAppBase;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.OnDemandDAO;
import com.avaya.asm.datamgr.datadistributionlayer.DDLIntraClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerData;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerListener;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.dynamic.DynamicDataMgr;
import com.avaya.asm.datamgr.objectapi.NameableDBObject;
import com.avaya.asm.datamgr.objectapi.WeakHashSet;
import com.avaya.asm.datamgr.tools.SMConsoleCommand;
import com.avaya.asm.datamgr.tools.SMConsoleParam;
import com.avaya.common.logging.client.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class SMConsoleListener
implements DataDistLayerListener {
    public static final String NON_DM = "NON_DM";
    public static final String ALL_DMS = "ALL";
    public static final String DAO_SUFFIX = "DAO";
    public static final String TEMP_FILE_PREFIX = "smcon-";
    public static final String TEMP_FILE_SUFFIX = ".out";
    protected static volatile SMConsoleListener myInstance;
    private final Logger log = AsmLogger.getLogger(SMConsoleListener.class);
    private List<String> allDMList;
    protected List<SMConsoleCommand> cmdList;
    protected Map<String, Set<MethodClassPair>> methodHash;
    protected Map<Class<? extends DataMgr>, Set<MethodClassPair>> dmMethodHash;
    protected boolean testMode = false;
    private WeakHashMap<Class<? extends DataMgr>, String> classShortNames = new WeakHashMap();

    public void addClassShortNames(Map<Class<? extends DataMgr>, String> classShortNames) {
        for (Map.Entry<Class<? extends DataMgr>, String> item : classShortNames.entrySet()) {
            Class<? extends DataMgr> clazz = item.getKey();
            String shortName = item.getValue();
            String curShortName = this.classShortNames.get(clazz);
            if (null != curShortName) {
                if (shortName.equals(curShortName)) continue;
                this.log.warn((Object)("Attempt to redefine a DataMgr class short name detected; short names must be unique. Class=" + clazz.getSimpleName() + " Orig Short Name=" + curShortName + " New Short Name=" + shortName));
                continue;
            }
            this.classShortNames.put(clazz, shortName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized SMConsoleListener getInstance() {
        if (myInstance != null) return myInstance;
        Class<SMConsoleListener> clazz = SMConsoleListener.class;
        synchronized (SMConsoleListener.class) {
            if (myInstance != null) return myInstance;
            myInstance = new SMConsoleListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return myInstance;
        }
    }

    protected SMConsoleListener() {
        this.log.info((Object)"Initializing SMConsoleListener for debugging");
        this.getFactory().getDataMgr(DebugDM.class);
    }

    protected DMFactory getFactory() {
        return DMFactory.getInstance();
    }

    public static String PrettyPrintObj(Object obj) {
        if (obj == null) {
            return "Query came back empty (null).";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        ByteArrayOutputStream byteBuff = new ByteArrayOutputStream();
        PrintWriter output = new PrintWriter(byteBuff, true);
        if (obj instanceof DataMgr) {
            DataMgr dataMgr = (DataMgr)obj;
            if (dataMgr.uninitialized()) {
                output.println("item NOT FOUND");
            } else if (dataMgr.failed()) {
                output.println("item state is FAIL");
            } else if (dataMgr.okay()) {
                output.println(obj);
            }
        } else if (obj instanceof Map) {
            Map result = (Map)obj;
            if (result.size() == 0) {
                output.println("Query came back empty.");
            }
            for (Object o : result.keySet()) {
                Object val = result.get(o);
                String valStr = "null";
                if (val != null) {
                    valStr = val.toString();
                }
                if (val instanceof NameableDBObject) {
                    valStr = SMConsoleListener.getObjectName((NameableDBObject)val) + ": " + valStr;
                }
                output.println(o + "=" + valStr);
            }
        } else if (obj instanceof List) {
            List result = (List)obj;
            if (result.size() == 0) {
                output.println("Query came back empty.");
            }
            for (Object o : result) {
                String valStr = o.toString();
                if (o instanceof NameableDBObject) {
                    valStr = SMConsoleListener.getObjectName((NameableDBObject)o) + ": " + valStr;
                }
                output.println(valStr);
            }
        } else {
            output.println(obj);
        }
        return byteBuff.toString();
    }

    public List<SMConsoleCommand> loadAllMethods() {
        if (this.getFactory() != null) {
            return this.loadAllMethods(this.getFactory().getAllDataMgrs().keySet());
        }
        return null;
    }

    public synchronized List<SMConsoleCommand> loadAllMethods(Set<Class<? extends DataMgr>> dmClassSet) {
        this.cmdList = new ArrayList<SMConsoleCommand>();
        this.dmMethodHash = new WeakHashMap<Class<? extends DataMgr>, Set<MethodClassPair>>();
        this.methodHash = new HashMap<String, Set<MethodClassPair>>();
        this.allDMList = new ArrayList<String>();
        ArrayList<Class<? extends DataMgr>> commonDebugDMList = new ArrayList<Class<? extends DataMgr>>();
        ArrayList<Class<? extends DataMgr>> appDebugDMList = new ArrayList<Class<? extends DataMgr>>();
        ArrayList<Class<? extends DataMgr>> nonDebugDMList = new ArrayList<Class<? extends DataMgr>>();
        this.log.finest((Object)"Loading all the commands for the SMConsole.");
        if (this.getFactory() != null) {
            for (Class<? extends DataMgr> dataMgrClass : dmClassSet) {
                if (DebugDM.class.isAssignableFrom(dataMgrClass)) {
                    commonDebugDMList.add(dataMgrClass);
                    continue;
                }
                if (DebugDMAppBase.class.isAssignableFrom(dataMgrClass)) {
                    appDebugDMList.add(dataMgrClass);
                    continue;
                }
                if (DataMgr.class.isAssignableFrom(dataMgrClass)) {
                    nonDebugDMList.add(dataMgrClass);
                    continue;
                }
                this.log.fine((Object)"ERROR: Unrecognized class");
            }
            this.addCmdsFromDMList(appDebugDMList);
            this.addCmdsFromDMList(commonDebugDMList);
            this.addCmdsFromDMList(nonDebugDMList);
        }
        this.log.finest((Object)"Done loading all the commands for the SMConsole.");
        return this.cmdList;
    }

    private void addCmdsFromDMList(ArrayList<Class<? extends DataMgr>> dmList) {
        for (Class<? extends DataMgr> dmClass : dmList) {
            try {
                if (this.log.isFinestEnabled()) {
                    this.log.finest((Object)("Loading " + dmClass.getSimpleName()));
                }
                this.allDMList.add(this.classShortNames.get(dmClass.getSimpleName()));
                this.cmdList.addAll(this.loadMethods(dmClass));
            }
            catch (Error e) {
                this.log.error((Object)("addCmdsFromDMList: Unable to process class: " + dmClass), (Throwable)e);
            }
        }
    }

    private static String getObjectName(NameableDBObject val) {
        return OnDemandDAO.getName(val);
    }

    private boolean isAcceptedReturnType(Class<?> c) {
        Class<?> superClass = c.getSuperclass();
        if (superClass != null && this.isAcceptedReturnType(superClass)) {
            return true;
        }
        if (c.getInterfaces() != null) {
            for (Class<?> cc : c.getInterfaces()) {
                if (!this.isAcceptedReturnType(cc)) continue;
                return true;
            }
        }
        return c.isAssignableFrom(Serializable.class) || c.equals(Serializable.class) || c.equals(Collection.class) || c.equals(Map.class) || c.isPrimitive();
    }

    private boolean isAcceptedType(Class<?> c) {
        return c.getSuperclass() != null && !c.getSuperclass().equals(Object.class) && c.getSuperclass().isAssignableFrom(Number.class) || c.isPrimitive() || c.isAssignableFrom(String.class) || c.isAssignableFrom(Boolean.class) || c.isArray();
    }

    private String formatCommand(Class<? extends DataMgr> dmClass, String methodName) {
        if (methodName.equals("getStatus")) {
            return methodName.replaceFirst("getStatus", "STATUS allDMs");
        }
        if (methodName.startsWith("remove")) {
            return methodName.replaceFirst("remove", "RM ");
        }
        if (methodName.equals("reinitAppDAOs") || methodName.equals("reinitAllDAOs")) {
            return "REINIT";
        }
        if (methodName.startsWith("reinit")) {
            return methodName.replaceFirst("reinit", "REINIT");
        }
        for (int i = 1; i < methodName.length(); ++i) {
            if (!Character.isUpperCase(methodName.charAt(i))) continue;
            return methodName.replaceFirst(methodName.substring(0, i), methodName.substring(0, i).toUpperCase() + " ");
        }
        return methodName.toUpperCase();
    }

    protected boolean isBusinessLogicDM(Class<? extends DataMgr> dmClass) {
        return dmClass.getSuperclass() != DataAccessObject.class && dmClass.getSuperclass() != DynamicDataMgr.class;
    }

    private boolean canDuplicate(String cmdName) {
        return !cmdName.equalsIgnoreCase("status alldms") && (cmdName.equalsIgnoreCase("reinit") || cmdName.equalsIgnoreCase("reinitappdaos") || cmdName.equalsIgnoreCase("reinitalldaos") || cmdName.equalsIgnoreCase("setapplication"));
    }

    protected List<SMConsoleCommand> loadMethods(Class<? extends DataMgr> dmClass) {
        Method[] methods = dmClass.getMethods();
        ArrayList<SMConsoleCommand> curCmdList = new ArrayList<SMConsoleCommand>();
        try {
            for (Method m : methods) {
                Object param;
                String cmdName;
                if (!m.isAnnotationPresent(SMConsole.class)) continue;
                SMConsole smConsole = m.getAnnotation(SMConsole.class);
                String[] paramNames = smConsole.parameterNames();
                if (!this.testMode && smConsole.test() || (cmdName = this.formatCommand(dmClass, m.getName())) == null) continue;
                boolean validCommand = true;
                ArrayList<SMConsoleParam> params = new ArrayList<SMConsoleParam>();
                if (m.getParameterTypes().length != 0) {
                    for (int i = 0; i < m.getParameterTypes().length; ++i) {
                        Class<?> cc = m.getParameterTypes()[i];
                        if (this.isAcceptedType(cc)) {
                            String name = i < paramNames.length ? paramNames[i] : null;
                            param = new SMConsoleParam(cc, name);
                            if (m.isVarArgs() && i == m.getParameterTypes().length - 1) {
                                ((SMConsoleParam)param).setIsRequired(false);
                            }
                            params.add((SMConsoleParam)param);
                            continue;
                        }
                        validCommand = false;
                    }
                }
                if (!m.getReturnType().getName().equals("void")) {
                    if (!this.isAcceptedReturnType(m.getReturnType())) {
                        validCommand = false;
                    } else {
                        Type returnType = m.getGenericReturnType();
                        if (returnType instanceof ParameterizedType) {
                            ParameterizedType type = (ParameterizedType)returnType;
                            Type[] typeArguments = type.getActualTypeArguments();
                            for (Type typeArgument : typeArguments) {
                                Class typeArgClass;
                                if (!(typeArgument instanceof Class) || this.isAcceptedReturnType(typeArgClass = (Class)typeArgument)) continue;
                                validCommand = false;
                            }
                        }
                    }
                }
                if (!validCommand) continue;
                Set<MethodClassPair> methList = this.methodHash.get(cmdName);
                SMConsoleCommand newCmd = new SMConsoleCommand(cmdName, params);
                newCmd.setDescription(smConsole.description());
                if (methList != null) {
                    Class<? extends DataMgr> otherDataMgrClass = null;
                    param = methList.iterator();
                    if (param.hasNext()) {
                        MethodClassPair mcp = (MethodClassPair)param.next();
                        otherDataMgrClass = mcp.getClazz();
                    }
                    ArrayList<SMConsoleCommand> tmpList = new ArrayList<SMConsoleCommand>(this.cmdList);
                    tmpList.addAll(curCmdList);
                    for (SMConsoleCommand curCmd : tmpList) {
                        if (!curCmd.getCmdName().equals(newCmd.getCmdName())) continue;
                        if (curCmd.equals(newCmd)) {
                            methList.add(new MethodClassPair(m, dmClass));
                            if (!this.canDuplicate(m.getName())) continue;
                            String otherName = this.classShortNames.get(otherDataMgrClass);
                            String curName = this.classShortNames.get(dmClass);
                            if (curCmd.getCmdName().startsWith("REINIT")) {
                                if (DebugDM.class.isAssignableFrom(otherDataMgrClass)) {
                                    otherName = DAO_SUFFIX;
                                }
                                if (DebugDM.class.isAssignableFrom(dmClass)) {
                                    curName = DAO_SUFFIX;
                                }
                                if (DebugDMAppBase.class.isAssignableFrom(otherDataMgrClass)) {
                                    otherName = otherName + DAO_SUFFIX;
                                }
                                if (DebugDMAppBase.class.isAssignableFrom(dmClass)) {
                                    curName = curName + DAO_SUFFIX;
                                }
                            }
                            if (curName == null || otherName == null) {
                                this.log.warn((Object)("Missing short name for class " + dmClass));
                                continue;
                            }
                            curCmd.makeAsDuplicateCommand(otherName, curName);
                            continue;
                        }
                        if (curCmd.getParamCount() == newCmd.getParamCount()) continue;
                        curCmdList.add(newCmd);
                        methList.add(new MethodClassPair(m, dmClass));
                    }
                } else {
                    methList = new WeakHashSet<MethodClassPair>();
                    curCmdList.add(newCmd);
                    methList.add(new MethodClassPair(m, dmClass));
                }
                this.methodHash.put(cmdName, methList);
                Set<MethodClassPair> dmMethods = this.dmMethodHash.get(dmClass);
                if (dmMethods == null) {
                    dmMethods = new HashSet<MethodClassPair>();
                    this.dmMethodHash.put(dmClass, dmMethods);
                }
                dmMethods.addAll(methList);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception loading SMConsole methods", (Throwable)e);
        }
        return curCmdList;
    }

    @Override
    public synchronized void destroy() {
        this.log.finer((Object)"Destroying SMConsoleListener");
    }

    @Override
    public DataDistLayerMessage.TargetAppId getListenerAppId() {
        return DataDistLayerMessage.TargetAppId.SMCONSOLE;
    }

    @Override
    public void hostLeftTheGroup(DataDistLayerMemberAddr hostId, GroupCommIntf.DDLGroupType groupType) {
    }

    @Override
    public void processMessage(DataDistLayerMessage message, DataDistLayerMemberAddr senderId) {
        Serializable payload = message.getPayload();
        this.log.finer((Object)("processMessage(senderId=" + senderId + ", message=" + payload + ")"));
        if (payload instanceof String && payload.equals("FIND SMConsoleListener")) {
            DDLIntraClusterMember member = DataDistLayerFactory.getInstance().getIntraClusterMember();
            try {
                DataDistLayerMessage response = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.SMCONSOLE, 10, (Serializable)((Object)"SMConsoleListener"));
                member.sendMessage(senderId, response);
            }
            catch (Exception e) {
                this.log.error((Object)("processMessage caught exception " + e));
            }
        }
        if (payload instanceof String && payload.toString().startsWith("testmode=")) {
            if (payload.toString().contains("true")) {
                this.log.info((Object)"Test Mode enabled");
                this.testMode = true;
            } else {
                this.log.info((Object)"Test Mode disabled");
                this.testMode = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    @Override
    public Object handleMessage(DataDistLayerMessage message, DataDistLayerMemberAddr srcMember) {
        block52: {
            if (this.methodHash == null) {
                this.loadAllMethods();
            }
            SMConsoleCommand consoleMsg = (SMConsoleCommand)message.getPayload();
            List<SMConsoleParam> args = consoleMsg.getParams();
            String dmType = NON_DM;
            this.log.finer((Object)("handleMessage(): cmd=" + (Object)((Object)consoleMsg.getCmdType()) + ", args=" + args));
            if (args != null && args.size() > 0 && args.get(0) != null) {
                dmType = args.get(0).getValue();
                if (this.getShortNameClass(dmType) == null) {
                    dmType = NON_DM;
                }
                this.log.finer((Object)("Parameter is for DataMgr: " + dmType));
            }
            try {
                DataMgr selectedDM;
                switch (consoleMsg.getCmdType()) {
                    case METHODS: {
                        List<SMConsoleCommand> commandList = this.loadAllMethods();
                        if (commandList != null) {
                            this.log.finer((Object)("handleMessage(): Returning " + commandList.size() + " methods"));
                        } else {
                            this.log.finer((Object)"handleMessage(): commandList is null");
                        }
                        return commandList;
                    }
                    case DEFINE: {
                        return this.printAll();
                    }
                    case STATUS: {
                        StringBuffer okayDMs = new StringBuffer("Okay DMs:");
                        StringBuffer failedDMs = new StringBuffer("Failed DMs:");
                        int initialSize = failedDMs.length();
                        ArrayList sortedList = new ArrayList(this.methodHash.get(consoleMsg.getCmdName()));
                        Collections.sort(sortedList, new Comparator<MethodClassPair>(){

                            @Override
                            public int compare(MethodClassPair o1, MethodClassPair o2) {
                                String name1 = o1.getClassStr();
                                String name2 = o2.getClassStr();
                                return name1.compareTo(name2);
                            }
                        });
                        for (MethodClassPair pair : sortedList) {
                            DataMgr curDM = this.getFactory().getDataMgr(pair.getClazz());
                            Method method = pair.getMethod();
                            if (method == null) continue;
                            DataMgr.Status state = (DataMgr.Status)((Object)method.invoke((Object)curDM, new Object[0]));
                            if (state == DataMgr.Status.OKAY) {
                                okayDMs.append("\n  " + curDM.getClass().getSimpleName() + " " + (Object)((Object)state));
                                continue;
                            }
                            failedDMs.append("\n  " + curDM.getClass().getSimpleName() + " " + (Object)((Object)state));
                        }
                        if (initialSize == failedDMs.length()) {
                            failedDMs.append("\n  No failing DMs");
                        }
                        okayDMs.append("\n\n");
                        okayDMs.append(failedDMs);
                        return okayDMs.toString();
                    }
                }
                this.log.finest((Object)"received Method Command for debugger.");
                Method curMethod = null;
                if (dmType.equals(NON_DM) || consoleMsg.getCmdName().equals("GET DAOMemory")) {
                    Set<MethodClassPair> mpList = this.methodHash.get(consoleMsg.getCmdName());
                    MethodClassPair pair = null;
                    if (mpList != null) {
                        Iterator<MethodClassPair> iterator = mpList.iterator();
                        while (iterator.hasNext()) {
                            MethodClassPair tmpPair = iterator.next();
                            Method tmpMethod = tmpPair.getMethod();
                            if (tmpMethod == null || tmpMethod.getParameterTypes().length != args.size()) continue;
                            pair = tmpPair;
                            break;
                        }
                    }
                    if (pair == null) break block52;
                    curMethod = pair.getMethod();
                    Class<? extends DataMgr> mainDataMgrClass = pair.getClazz();
                    selectedDM = this.getFactory().getDataMgr(mainDataMgrClass);
                } else {
                    selectedDM = this.getFactory().getDataMgr(this.getShortNameClass(dmType));
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)("TYPE: " + dmType + ", selected: " + selectedDM.getClass().getSimpleName()));
                    }
                    for (MethodClassPair mcp : this.methodHash.get(consoleMsg.getCmdName())) {
                        if (!mcp.getClazz().equals(this.getShortNameClass(dmType))) continue;
                        curMethod = mcp.getMethod();
                    }
                }
                if (curMethod != null) {
                    this.log.finest((Object)("Found Method: " + curMethod.getName()));
                    Object[] curArgs = new Object[consoleMsg.getTypedParamCount()];
                    int i = 0;
                    for (SMConsoleParam param : consoleMsg.getParams()) {
                        if (param == null || !param.isTypedParam()) continue;
                        Object curType = param.getParamType();
                        String paramObj = param.getValue();
                        if (paramObj == null) {
                            curArgs[i] = paramObj;
                        } else if (((Class)curType).isPrimitive()) {
                            if (param.getParamTypeStr().equalsIgnoreCase("int")) {
                                curArgs[i] = Integer.parseInt(paramObj);
                            } else if (param.getParamTypeStr().equalsIgnoreCase("long")) {
                                curArgs[i] = Long.parseLong(paramObj);
                            } else if (param.getParamTypeStr().equalsIgnoreCase("boolean")) {
                                curArgs[i] = Boolean.parseBoolean(paramObj);
                            }
                        } else {
                            ArrayList<String> argList = new ArrayList<String>();
                            boolean isArray = ((Class)curType).isArray();
                            if (isArray) {
                                for (String s : paramObj.split("#")) {
                                    argList.add(s);
                                }
                                curType = ((Class)curType).getComponentType();
                            } else {
                                argList.add(paramObj);
                            }
                            ArrayList<Object> tmpCurArgs = new ArrayList<Object>();
                            for (Object curParam : argList) {
                                try {
                                    Method m = ((Class)curType).getMethod("valueOf", String.class);
                                    Object[] params = new Object[]{curParam};
                                    tmpCurArgs.add(m.invoke(null, params));
                                }
                                catch (NoSuchMethodException e) {
                                    curType = String.class;
                                    tmpCurArgs.add(curParam);
                                }
                            }
                            if (isArray) {
                                this.log.finer((Object)("Array of " + ((Class)curType).getSimpleName()));
                                curArgs[i] = Array.newInstance(curType, tmpCurArgs.size());
                                int j = 0;
                                for (Object o : tmpCurArgs) {
                                    Array.set(curArgs[i], j++, o);
                                }
                            } else if (((Class)curType).isAssignableFrom(String.class)) {
                                this.log.finer((Object)"String type");
                                curArgs[i] = ((Class)curType).cast(paramObj);
                            } else {
                                curArgs[i] = tmpCurArgs.get(0);
                                this.log.finer((Object)("Number type " + curArgs[i].getClass()));
                            }
                        }
                        ++i;
                    }
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)("Attempting to invoke on " + selectedDM.getClass().getSimpleName() + " for method " + curMethod.getName() + "()"));
                    }
                    if (selectedDM != null) {
                        Object retVal = null;
                        retVal = curArgs == null || curArgs.length == 0 ? curMethod.invoke((Object)selectedDM, new Object[0]) : curMethod.invoke((Object)selectedDM, curArgs);
                        if ((DebugDMAppBase.class.isAssignableFrom(selectedDM.getClass()) || DebugDM.class.isAssignableFrom(selectedDM.getClass())) && curMethod.getName().equals("setApplication")) {
                            return retVal;
                        }
                        if (retVal != null && retVal.getClass().isArray()) {
                            String tmpVal = new String("[");
                            for (Object o : (Object[])retVal) {
                                tmpVal = tmpVal + o.toString() + ", ";
                            }
                            if (((Object[])retVal).length > 0) {
                                tmpVal = tmpVal.substring(0, tmpVal.length() - 2);
                            }
                            tmpVal = tmpVal + "]";
                            retVal = tmpVal;
                        }
                        String retValStr = this.adjustEOL(SMConsoleListener.PrettyPrintObj(retVal));
                        File tempFile = this.createTempFile();
                        try (OutputStreamWriter writerToFile = this.createFileWriter(tempFile);){
                            writerToFile.write(retValStr);
                        }
                        return tempFile;
                    }
                    this.log.error((Object)"MainDM is null, cannot execute method call");
                    break block52;
                }
                this.log.info((Object)("No such method for debugger: " + consoleMsg.getCmdName()));
            }
            catch (Exception e) {
                this.log.error((Object)"Exception handling message.  Exception passed on to the console.");
                return "Unable to successfully process request due to exception:\n" + e.getClass().getName() + ": " + e.getMessage() + ": " + DMUtilities.getStackTrace(e);
            }
        }
        this.log.finer((Object)"handleMessage(): returning null");
        return null;
    }

    protected String printAll() {
        StringBuilder retStr = new StringBuilder("DMs:");
        for (Map.Entry<Class<? extends DataMgr>, String> dm : this.classShortNames.entrySet()) {
            retStr.append("\n  " + dm.getValue() + " = " + dm.getKey());
        }
        return retStr.toString();
    }

    public Class<? extends DataMgr> getShortNameClass(String shortName) {
        if (shortName == null) {
            return null;
        }
        if ((shortName = shortName.toUpperCase().replaceFirst("DAO$", "")).equals("")) {
            shortName = ALL_DMS;
        }
        for (Map.Entry<Class<? extends DataMgr>, String> entry : this.classShortNames.entrySet()) {
            if (!shortName.equalsIgnoreCase(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void otherMemberJoined(DataDistLayerMemberAddr otherMemberId, GroupCommIntf.DDLGroupType ddlGroupType) {
    }

    @Override
    public void thisMemberJoinedTheGroup(DataDistLayerMemberAddr thisMemberId, GroupCommIntf.DDLGroupType ddlGroupType) {
    }

    @Override
    public void dataStored(DataDistLayerMemberAddr senderId, DataDistLayerData data) {
    }

    @Override
    public void dataUpdated(DataDistLayerMemberAddr senderId, DataDistLayerData priorData, DataDistLayerData updatedData) {
    }

    @Override
    public void dataRemoved(DataDistLayerMemberAddr senderId, DataDistLayerData removedData) {
    }

    @Override
    public void bulkStoreReceived(DataDistLayerMemberAddr senderId, List<DataDistLayerData> dataList) {
    }

    @Override
    public void bulkRemoveReceived(DataDistLayerMemberAddr senderId, List<DataDistLayerData> dataList) {
    }

    protected File createTempFile() throws IOException {
        return File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
    }

    protected OutputStreamWriter createFileWriter(File file) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        return writer;
    }

    protected String adjustEOL(String str) {
        return str;
    }

    protected class MethodClassPair {
        private final String method;
        private final Class<?>[] params;
        private final WeakReference<Class<? extends DataMgr>> clazz;

        public MethodClassPair(Method method, Class<? extends DataMgr> clazz) {
            this.clazz = new WeakReference<Class<? extends DataMgr>>(clazz);
            this.method = method.getName();
            this.params = method.getParameterTypes();
        }

        public Method getMethod() throws Exception {
            Class dmClazz = (Class)this.clazz.get();
            return dmClazz == null ? null : dmClazz.getMethod(this.method, this.params);
        }

        public Class<? extends DataMgr> getClazz() {
            return (Class)this.clazz.get();
        }

        public String getClassStr() {
            Class tmpClazz = (Class)this.clazz.get();
            return tmpClazz == null ? "nullClass" : tmpClazz.getSimpleName();
        }

        public String toString() {
            return this.getClassStr() + "." + this.method + " [" + Arrays.toString(this.params) + "]";
        }

        private SMConsoleListener getOuterType() {
            return SMConsoleListener.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodClassPair other = (MethodClassPair)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }
    }
}

