/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.trustmgmt.CRLHolder;
import com.avaya.asm.trustmgmt.RevocationInfo;
import com.avaya.asm.trustmgmt.RevocationOptions;
import java.io.IOException;
import java.security.cert.X509CRL;
import java.util.List;

public class RevocationInfoImpl
implements RevocationInfo {
    RevocationOptions revocationOptions = new RevocationOptions();

    @Override
    public boolean checkEndEntityOnly() {
        boolean result = true;
        String revocationCheckMethod = this.revocationOptions.getRevocationCheckMethod();
        if (revocationCheckMethod.equals("CERT_CHAIN")) {
            result = false;
        }
        return result;
    }

    @Override
    public List<X509CRL> getCrlList() throws IOException {
        CRLHolder crlHolder = CRLHolder.getInstance();
        crlHolder.loadCRLs();
        return crlHolder.getCrlList();
    }

    public RevocationOptions getRevocationOptions() {
        return this.revocationOptions;
    }

    @Override
    public boolean isCrlRevocationCheckingEnabled() {
        String revocationType;
        boolean result = false;
        if (this.isRevocationCheckingEnabled() && ((revocationType = this.revocationOptions.getRevocationType()).equals("CRL") || revocationType.equals("BOTH"))) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isFallbackAllowed() {
        boolean result = false;
        String revocationType = this.revocationOptions.getRevocationType();
        if (revocationType != null && revocationType.equals("BOTH")) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isOcspPreferred() {
        boolean result = false;
        String revocationType = this.revocationOptions.getRevocationType();
        if (revocationType != null) {
            String revocationTypePreference;
            if (revocationType.equals("OCSP")) {
                result = true;
            } else if (revocationType.equals("BOTH") && (revocationTypePreference = this.revocationOptions.getRevocationTypePreference()) != null && revocationTypePreference.equals("OCSP")) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean isOcspRevocationCheckingEnabled() {
        String revocationType;
        boolean result = false;
        if (this.isRevocationCheckingEnabled() && ((revocationType = this.revocationOptions.getRevocationType()).equals("OCSP") || revocationType.equals("BOTH"))) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isRevocationCheckingEnabled() {
        boolean result = false;
        String revocationValidation = this.revocationOptions.getRevocationValidation();
        if (revocationValidation != null && (revocationValidation.equals("BEST_EFFORT") || revocationValidation.equals("MANDATORY"))) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isSoftFailAllowed() {
        boolean result = true;
        String revocationValidation = this.revocationOptions.getRevocationValidation();
        if (revocationValidation != null && revocationValidation.equals("MANDATORY")) {
            result = false;
        }
        return result;
    }

    public void setRevocationOptions(RevocationOptions revocationOptions) {
        this.revocationOptions = new RevocationOptions(revocationOptions);
    }

    public String toString() {
        return "[revocationOptions=" + this.revocationOptions.toString() + ", checkEndEntityOnly=" + this.checkEndEntityOnly() + ", crlRevocationCheckingEnabled=" + this.isCrlRevocationCheckingEnabled() + ", fallbackAllowed=" + this.isFallbackAllowed() + ", ocspPreferred=" + this.isOcspPreferred() + ", ocspRevocationCheckingEnabled=" + this.isOcspRevocationCheckingEnabled() + ", revocationCheckingEnabled=" + this.isRevocationCheckingEnabled() + ", softFailAllowed=" + this.isSoftFailAllowed() + "]";
    }
}

