/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.CRLHolder;
import com.avaya.asm.trustmgmt.RevocationInfoManager;
import com.avaya.asm.trustmgmt.RevocationInfoUtilities;
import com.avaya.common.logging.client.Logger;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class RevocationInfoMonitor {
    private static final Logger log = AsmLogger.getLogger(RevocationInfoMonitor.class);
    private static RevocationInfoMonitor instance = null;
    private final RevocationInfoUtilities revocationInfoUtilities = RevocationInfoUtilities.getInstance();
    private final String revocationPropertiesFile = this.revocationInfoUtilities.getRevocationPropertiesFile();
    private final String crlFolder = this.revocationInfoUtilities.getCrlFolder();
    private WatchService watcher = null;
    private WatchKey crlWatchKey = null;
    private WatchKey revocationFileWatchKey;
    private boolean revocationMonitorIsEnabled = false;

    private RevocationInfoMonitor() {
        String functionName = "RevocationInfoMonitor";
        boolean isFineEnabled = log.isFineEnabled();
        if (isFineEnabled) {
            log.fine((Object)"RevocationInfoMonitor: Creating new instance.");
        }
        try {
            this.enableAllRevocationInfoMonitoring();
        }
        catch (Exception e) {
            log.error((Object)"RevocationInfoMonitor: Unable to register folders for monitoring", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static RevocationInfoMonitor getInstance() {
        if (instance != null) return instance;
        Class<RevocationInfoMonitor> clazz = RevocationInfoMonitor.class;
        synchronized (RevocationInfoMonitor.class) {
            if (instance != null) return instance;
            instance = new RevocationInfoMonitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected boolean crlMonitoringIsEnabled() {
        return this.crlWatchKey != null;
    }

    protected boolean revocationFileMonitoringIsEnabled() {
        return this.revocationFileWatchKey != null;
    }

    protected boolean revocationMonitorIsEnabled() {
        return this.revocationMonitorIsEnabled;
    }

    protected boolean watcherStarted() {
        return this.watcher != null;
    }

    protected void disableCrlMonitoring() {
        String functionName = "disableCrlMonitoring";
        if (this.crlMonitoringIsEnabled()) {
            this.crlWatchKey.cancel();
            this.crlWatchKey = null;
        }
        log.info((Object)"disableCrlMonitoring: CRL Monitoring disabled.");
    }

    protected void disableRevocationFileMonitoring() {
        String functionName = "disableRevocationFileMonitoring";
        if (this.revocationFileMonitoringIsEnabled()) {
            this.revocationFileWatchKey.cancel();
            this.revocationFileWatchKey = null;
        }
        log.info((Object)"disableRevocationFileMonitoring: Revocation File Monitoring disabled.");
    }

    protected void enableAllRevocationInfoMonitoring() throws IOException {
        this.enableCrlMonitoring();
        this.enableRevocationFileMonitoring();
    }

    protected void enableCrlMonitoring() throws IOException {
        String functionName = "enableCrlMonitoring";
        Path crlPath = FileSystems.getDefault().getPath(this.crlFolder, new String[0]);
        if (!this.crlMonitoringIsEnabled()) {
            this.startWatcher();
            this.crlWatchKey = crlPath.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            this.enableRevocationMonitor();
        }
        log.info((Object)("enableCrlMonitoring: CRL Monitoring enabled (" + crlPath + ")."));
    }

    protected void enableRevocationFileMonitoring() throws IOException {
        String functionName = "enableRevocationFileMonitoring";
        Path revocationPropertiesFilePath = FileSystems.getDefault().getPath(this.revocationPropertiesFile, new String[0]).getParent();
        if (!this.revocationFileMonitoringIsEnabled()) {
            this.startWatcher();
            this.revocationFileWatchKey = revocationPropertiesFilePath.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            this.enableRevocationMonitor();
        }
        log.info((Object)("enableRevocationFileMonitoring: Revocation File Monitoring enabled.revocationPropertiesFilePath=" + revocationPropertiesFilePath));
    }

    private void enableRevocationMonitor() {
        if (!this.revocationMonitorIsEnabled()) {
            RevocationMonitor monitor = new RevocationMonitor();
            Thread thread = new Thread((Runnable)monitor, "RevocationMonitor");
            thread.setDaemon(true);
            thread.start();
            this.revocationMonitorIsEnabled = true;
        }
    }

    private void startWatcher() {
        if (!this.watcherStarted()) {
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
            }
            catch (Exception e) {
                log.error((Object)"Unable to start watcher for monitoring", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "revocationInfoMonitor[ revocationMonitorEnabled=" + this.revocationMonitorIsEnabled() + ", watcherServiceStarted=" + this.watcherStarted() + ", crlMonitoringEnabled=" + this.crlMonitoringIsEnabled() + ", revocationFileMonitoringIsEnabled=" + this.revocationFileMonitoringIsEnabled() + "]";
    }

    private class RevocationMonitor
    implements Runnable {
        private final int monitorInterval = 5000;

        private RevocationMonitor() {
        }

        @Override
        public void run() {
            String functionName = "run";
            while (true) {
                boolean isFinestEnabled = log.isFinestEnabled();
                try {
                    if (isFinestEnabled) {
                        log.finest((Object)("run: Waiting for updates. revocationFileMonitoring=" + RevocationInfoMonitor.this.revocationFileMonitoringIsEnabled() + ", crlMonitoring=" + RevocationInfoMonitor.this.crlMonitoringIsEnabled() + ", interval=" + 5000 + "ms"));
                    }
                    if (RevocationInfoMonitor.this.watcherStarted()) {
                        boolean valid;
                        WatchKey wk = RevocationInfoMonitor.this.watcher.take();
                        boolean reloadCrls = false;
                        boolean reloadRevocationProperties = false;
                        for (WatchEvent<?> event : wk.pollEvents()) {
                            Path modified = (Path)event.context();
                            if (isFinestEnabled) {
                                log.finest((Object)("run: Modified file=" + modified + ", Modification type=" + event.kind().name()));
                            }
                            String filename = modified.toString();
                            if (RevocationInfoMonitor.this.revocationInfoUtilities.isValidCrlFilename(filename)) {
                                reloadCrls = true;
                                continue;
                            }
                            if (RevocationInfoMonitor.this.revocationInfoUtilities.isRevocationPropertiesFilename(filename)) {
                                reloadRevocationProperties = true;
                                continue;
                            }
                            if (!isFinestEnabled) continue;
                            log.finest((Object)("run: Ignored. filename=" + filename));
                        }
                        RevocationInfoManager revocationInfoManager = RevocationInfoManager.getInstance();
                        if (reloadRevocationProperties) {
                            revocationInfoManager.getRevocationInfoFile().loadRevocationProperties();
                        }
                        if (reloadRevocationProperties || reloadCrls) {
                            CRLHolder crlHolder = CRLHolder.getInstance();
                            if (revocationInfoManager.getRevocationInfo().isCrlRevocationCheckingEnabled()) {
                                crlHolder.loadCRLs();
                            } else {
                                crlHolder.clearCRLs();
                            }
                        }
                        if (!(valid = wk.reset())) {
                            log.error((Object)"run: Something went wrong with the watcher service. Trying to re-register CRL Monitor");
                            RevocationInfoMonitor.this.enableAllRevocationInfoMonitoring();
                        }
                    } else {
                        log.info((Object)"run: Revocation Info Watcher not started.");
                    }
                    Thread.sleep(5000L);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"run: Error while polling for changes in Revocation and CRL Folder", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

