/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.WaitStatus;
import com.avaya.asm.trustmgmt.TrustKeyManagerFactorySupplier;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraSSLOptions;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;

public class TrustMgmtUtil {
    private static Logger log = AsmLogger.getLogger(TrustMgmtUtil.class);
    protected static final String SYSTEM_PARAM_KEY_STORE = "javax.net.ssl.keyStore";
    protected static final String SYSTEM_PARAM_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    protected static final String SYSTEM_PARAM_KEY_STORE_PROVIDER = "javax.net.ssl.keyStoreProvider";
    protected static final String SYSTEM_PARAM_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    protected static final String SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    protected static final String SYSTEM_PARAM_TRUST_STORE = "javax.net.ssl.trustStore";
    protected static final String SYSTEM_PARAM_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    protected static final String SYSTEM_PARAM_TRUST_STORE_PROVIDER = "javax.net.ssl.trustStoreProvider";
    protected static final String SYSTEM_PARAM_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    protected static final String SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    protected static final String TLS_MINIMUM_VERSION = "TLSv1.2";
    private static final String idFile = "/proc/sys/kernel/random/boot_id";
    private static final String GETKEY_COMMAND = "/usr/bin/sudo /opt/Avaya/Session_Manager/bin/TMClient.sh getKey";
    private String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
    private static volatile TrustMgmtUtil instance = null;

    protected TrustMgmtUtil() {
        String functionName = "TrustMgmtUtil";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)"TrustMgmtUtil: instantiated.");
        }
    }

    public static synchronized TrustMgmtUtil getInstance() {
        if (instance == null) {
            instance = new TrustMgmtUtil();
        }
        return instance;
    }

    public byte[] crypto(byte[] ksPassword, boolean isEncrypt) throws Exception {
        String functionName = "crypto";
        boolean isFinestEnabled = log.isFinestEnabled();
        File bootId = new File(idFile);
        String keyString = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(bootId));
            keyString = reader.readLine();
        }
        catch (Exception e) {
            System.err.println("crypto: Unable to find key file!");
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (keyString == null) {
            throw new Exception("crypto: Unable to read key file!");
        }
        Mac sha256hmac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKey = new SecretKeySpec(keyString.replace("-", "").getBytes("UTF-8"), "HmacSHA256");
        sha256hmac.init(secretKey);
        byte[] bootIdBytes = new byte[keyString.getBytes().length + 1];
        System.arraycopy(keyString.getBytes("UTF-8"), 0, bootIdBytes, 0, keyString.getBytes().length);
        bootIdBytes[keyString.getBytes().length] = 10;
        byte[] key = sha256hmac.doFinal(bootIdBytes);
        int len = bootIdBytes.length * 2;
        byte[] bootIdBytesForIV = new byte[len];
        System.arraycopy(bootIdBytes, 0, bootIdBytesForIV, 0, bootIdBytes.length);
        System.arraycopy(bootIdBytes, 0, bootIdBytesForIV, bootIdBytes.length, bootIdBytes.length);
        byte[] bootIdForIVHash = sha256hmac.doFinal(bootIdBytesForIV);
        byte[] iv = new byte[16];
        System.arraycopy(bootIdForIVHash, 0, iv, 0, iv.length);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", (Provider)new BouncyCastleFipsProvider());
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        if (isEncrypt) {
            cipher.init(1, (Key)keySpec, new IvParameterSpec(iv));
        } else {
            cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
        }
        byte[] encryptedData = cipher.doFinal(ksPassword);
        if (isFinestEnabled) {
            log.finest((Object)("crypto: encryptedData.length" + encryptedData.length + ", ksPassword.length=" + ksPassword.length + ", isEncrypt=" + isEncrypt));
        }
        return encryptedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStoreString() throws IOException, InterruptedException {
        String functionName = "getStoreString";
        boolean isFinestEnabled = log.isFinestEnabled();
        byte[] result = null;
        InputStream inputStream = null;
        Process process = null;
        process = Runtime.getRuntime().exec(GETKEY_COMMAND);
        try {
            inputStream = process.getInputStream();
            result = this.streamToByteArray(inputStream);
        }
        finally {
            inputStream.close();
        }
        int wStatus = process.waitFor();
        if (!WaitStatus.WIFEXITED(wStatus) || WaitStatus.WEXITSTATUS(wStatus) != 0) {
            String msg = "getStoreString: Command \"/usr/bin/sudo /opt/Avaya/Session_Manager/bin/TMClient.sh getKey\" did not execute properly, status=" + WaitStatus.asString(wStatus);
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        if (isFinestEnabled) {
            if (result != null) {
                log.finest((Object)("getStoreString: result.length=" + result.length));
            } else {
                log.finest((Object)"getStoreString: result=null");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] streamToByteArray(InputStream stream) throws IOException {
        String functionName = "streamToByteArray";
        boolean isFinestEnabled = log.isFinestEnabled();
        try (ByteArrayOutputStream os = null;){
            byte[] buffer = new byte[1024];
            os = new ByteArrayOutputStream();
            int line = 0;
            while ((line = stream.read(buffer)) != -1) {
                os.write(buffer, 0, line);
            }
            os.flush();
        }
        if (isFinestEnabled) {
            log.finest((Object)("streamToByteArray: os.size()=" + os.size()));
        }
        return os.toByteArray();
    }

    protected byte[] getStoragePassword() {
        String functionName = "getStoragePassword";
        boolean isFinestEnabled = log.isFinestEnabled();
        byte[] result = null;
        try {
            result = this.crypto(this.getStoreString(), false);
        }
        catch (IOException ioe) {
            log.error((Object)"getStoragePassword: crypto failed to access the file!", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            log.error((Object)"getStoragePassword: Interrupted while accessing the file!", (Throwable)ie);
        }
        catch (Exception e) {
            log.error((Object)"getStoragePassword: Exception while accessing the file!", (Throwable)e);
        }
        if (isFinestEnabled) {
            if (result != null) {
                log.finest((Object)("getStoragePassword: result.length=" + result.length));
            } else {
                log.finest((Object)"getStoragePassword: result=null");
            }
        }
        return result;
    }

    protected String getStoragePasswordAsString() {
        String functionName = "getStoragePasswordAsString";
        boolean isFinestEnabled = log.isFinestEnabled();
        String result = null;
        byte[] decryptedData = this.getStoragePassword();
        if (decryptedData != null) {
            try {
                result = new String(decryptedData, "UTF-8").trim();
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)"getStoragePasswordAsString: Cannot convert", (Throwable)uee);
            }
            for (int j = 0; j < decryptedData.length; ++j) {
                decryptedData[j] = 0;
            }
        }
        if (isFinestEnabled) {
            if (result != null) {
                log.finest((Object)("getStoragePasswordAsString: result.length()=" + result.length()));
            } else {
                log.finest((Object)"getStoragePasswordAsString: result=null");
            }
        }
        return result;
    }

    protected char[] getStoragePasswordAsCharArray() {
        String functionName = "getStoragePasswordAsCharArray";
        boolean isFinestEnabled = log.isFinestEnabled();
        char[] result = null;
        String password = this.getStoragePasswordAsString();
        if (password != null) {
            result = password.toCharArray();
        }
        if (isFinestEnabled) {
            if (result != null) {
                log.finest((Object)("getStoragePasswordAsCharArray: result.length=" + result.length));
            } else {
                log.finest((Object)"getStoragePasswordAsCharArray: result=null");
            }
        }
        return result;
    }

    protected SSLContext getSSLContext() {
        boolean useRevocationAwareSSLContext = false;
        return this.createSSLContext(false);
    }

    protected String getKeyStorePassword() {
        return this.getStoragePasswordAsString();
    }

    protected String getKeyStorePath() {
        String functionName = "getKeystorePath";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("getKeystorePath: keystorePath=" + this.keyStorePath));
        }
        return this.keyStorePath;
    }

    protected String getKeyStoreType() {
        return KeyStore.getDefaultType();
    }

    protected String getTrustStorePassword() {
        return this.getStoragePasswordAsString();
    }

    protected String getTrustStorePath() {
        String functionName = "getTrustStorePath";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("getTrustStorePath: trustStorePath=" + this.trustStorePath));
        }
        return this.trustStorePath;
    }

    protected String getTrustStoreType() {
        return KeyStore.getDefaultType();
    }

    public CassandraSSLOptions getSSLOptions() {
        boolean useRevocationAwareSSLContext = false;
        return this.getSSLOptions(false);
    }

    public CassandraSSLOptions getSSLOptions(boolean useRevocationAwareSSLContext) {
        String functionName = "getSSLOptions";
        boolean isFinestEnabled = log.isFinestEnabled();
        SSLContext sslContext = this.createSSLContext(useRevocationAwareSSLContext);
        CassandraSSLOptions sslOptions = null;
        if (sslContext != null) {
            SSLContext.setDefault(sslContext);
            sslOptions = new CassandraSSLOptions(sslContext);
            if (isFinestEnabled) {
                log.finest((Object)("getSSLOptions: Created CassandraSSLOptions. useRevocationAwareSSLContext=" + useRevocationAwareSSLContext + ", sslOptions=" + sslOptions));
            }
        } else {
            log.error((Object)("getSSLOptions: Could not Create CassandraSSLOptions. useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        return sslOptions;
    }

    public SSLContext createSSLContext(String trustStorePath, String trustStoreType, String trustStorePassword, String trustManagerFactoryAlgorithm, String trustStoreProvider, String keyStorePath, String keyStoreType, String keyStorePassword, String keyManagerFactoryAlgorithm, String keyStoreProvider, String minimumTlsVersion, String contextProvider) throws KeyStoreException, KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException, IOException, UnrecoverableKeyException, CertificateException {
        String functionName = "createSSLContext";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("createSSLContext: trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", trustStoreProvider=" + trustStoreProvider + ", keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", keyStoreProvider=" + keyStoreProvider + ", minimumTlsVersion=" + minimumTlsVersion + ", contextProvider=" + contextProvider));
        }
        if (trustStorePath == null) {
            log.error((Object)"createSSLContext: trustStorePath is null");
            return null;
        }
        if (trustStoreType == null) {
            log.error((Object)"createSSLContext: trustStoreType is null");
            return null;
        }
        if (trustStorePassword == null) {
            log.error((Object)"createSSLContext: trustStorePassword is null");
            return null;
        }
        if (trustManagerFactoryAlgorithm == null) {
            trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        if (keyStorePath == null) {
            log.error((Object)"createSSLContext: keyStorePath is null");
            return null;
        }
        if (keyStoreType == null) {
            log.error((Object)"createSSLContext: keyStoreType is null");
            return null;
        }
        if (keyStorePassword == null) {
            log.error((Object)"createSSLContext: keyStorePassword is null");
            return null;
        }
        if (keyManagerFactoryAlgorithm == null) {
            keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (minimumTlsVersion == null) {
            minimumTlsVersion = TLS_MINIMUM_VERSION;
        }
        SSLContext sslContext = null;
        FileInputStream tsf = null;
        FileInputStream ksf = null;
        try {
            tsf = new FileInputStream(trustStorePath);
            KeyStore ts = KeyStore.getInstance(trustStoreType);
            ts.load(tsf, trustStorePassword.toCharArray());
            ksf = new FileInputStream(keyStorePath);
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            ks.load(ksf, keyStorePassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
            tmf.init(ts);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm);
            kmf.init(ks, keyStorePassword.toCharArray());
            sslContext = this.createSSLContext(tmf, kmf, minimumTlsVersion, null);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException e) {
            log.error((Object)("createSSLContext: Error creating SSLContext. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", trustStoreProvider=" + trustStoreProvider + ", keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", keyStoreProvider=" + keyStoreProvider + ", minimumTlsVersion=" + minimumTlsVersion + ", contextProvider=" + contextProvider + ", Exception=" + e), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (tsf != null) {
                    tsf.close();
                }
                if (ksf != null) {
                    ksf.close();
                }
            }
            catch (IOException ioe) {
                log.error((Object)"createSSLContext: Error closing trust or key file.", (Throwable)ioe);
            }
        }
        return sslContext;
    }

    public SSLContext createSSLContext(TrustManagerFactory trustManagerFactory, KeyManagerFactory keyManagerFactory, String minimumTlsVersion, String contextProvider) throws NoSuchProviderException, KeyManagementException, NoSuchAlgorithmException {
        String functionName = "createSSLContext";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (trustManagerFactory == null) {
            log.error((Object)"createSSLContext: trustManagerFactory is null");
            return null;
        }
        if (keyManagerFactory == null) {
            log.error((Object)"createSSLContext: keyManagerFactory is null");
            return null;
        }
        SSLContext sslContext = null;
        try {
            if (minimumTlsVersion == null) {
                minimumTlsVersion = TLS_MINIMUM_VERSION;
            }
            sslContext = contextProvider == null ? SSLContext.getInstance(minimumTlsVersion) : SSLContext.getInstance(minimumTlsVersion, contextProvider);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), this.getSecureRandom());
            if (isFinestEnabled) {
                log.finest((Object)("createSSLContext: Created SSLContext. minimumTlsVersion=" + minimumTlsVersion + ", sslContext=" + sslContext));
            }
        }
        catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException e) {
            log.error((Object)("createSSLContext: Error creating SSLContext. minimumTlsVersion=" + minimumTlsVersion + ", contextProvider=" + contextProvider + ", Exception=" + e), (Throwable)e);
            throw e;
        }
        return sslContext;
    }

    public SSLContext createSSLContext(boolean useRevocationAwareSSLContext) {
        String functionName = "createSSLContext";
        SSLContext sslContext = null;
        try {
            String trustStorePath = this.getTrustStorePath();
            String trustStorePassword = this.getTrustStorePassword();
            String trustStoreType = this.getTrustStoreType();
            String trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            String trustStoreProvider = null;
            String keyStorePath = this.getKeyStorePath();
            String keyStorePassword = this.getKeyStorePassword();
            String keyStoreType = this.getKeyStoreType();
            String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            String keyStoreProvider = null;
            String minimumTlsVersion = TLS_MINIMUM_VERSION;
            String contextProvider = null;
            sslContext = useRevocationAwareSSLContext ? this.createRevocationAwareSSLContext(trustStorePath, trustStoreType, trustStorePassword, trustManagerFactoryAlgorithm, trustStoreProvider, keyStorePath, keyStoreType, keyStorePassword, keyManagerFactoryAlgorithm, keyStoreProvider, TLS_MINIMUM_VERSION, contextProvider) : this.createSSLContext(trustStorePath, trustStoreType, trustStorePassword, trustManagerFactoryAlgorithm, trustStoreProvider, keyStorePath, keyStoreType, keyStorePassword, keyManagerFactoryAlgorithm, keyStoreProvider, TLS_MINIMUM_VERSION, contextProvider);
        }
        catch (Exception e) {
            log.error((Object)"createSSLContext: Error creating SSLContext.", (Throwable)e);
        }
        return sslContext;
    }

    public SSLContext createDefaultSSLContext(boolean useRevocationAwareSSLContext) {
        String functionName = "createDefaultRevocationAwareSSLContext";
        boolean isFinestEnabled = log.isFinestEnabled();
        SSLContext sslContext = this.createSSLContext(useRevocationAwareSSLContext);
        if (sslContext != null) {
            SSLContext.setDefault(sslContext);
            if (isFinestEnabled) {
                log.finest((Object)("createDefaultRevocationAwareSSLContext: Created Default SSLContext. useRevocationAwareSSLContext=" + useRevocationAwareSSLContext + ", sslContext=" + sslContext));
            }
        } else {
            log.error((Object)("createDefaultRevocationAwareSSLContext: Error creating Default SSLContext. useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        return sslContext;
    }

    public SSLContext createRevocationAwareSSLContext(String trustStorePath, String trustStoreType, String trustStorePassword, String trustManagerFactoryAlgorithm, String trustStoreProvider, String keyStorePath, String keyStoreType, String keyStorePassword, String keyManagerFactoryAlgorithm, String keyStoreProvider, String minimumTlsVersion, String contextProvider) throws CertificateException, InvalidAlgorithmParameterException, IOException, KeyStoreException, KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        String functionName = "createRevocationAwareSSLContext";
        boolean isFinestEnabled = log.isFinestEnabled();
        boolean isInfoEnabled = log.isInfoEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("createRevocationAwareSSLContext: trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", trustStoreProvider=" + trustStoreProvider + ", keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", keyStoreProvider=" + keyStoreProvider + ", minimumTlsVersion=" + minimumTlsVersion + ", contextProvider=" + contextProvider));
        }
        if (trustStorePath == null) {
            log.error((Object)"createRevocationAwareSSLContext: trustStorePath is null");
            return null;
        }
        if (trustStoreType == null) {
            log.error((Object)"createRevocationAwareSSLContext: trustStoreType is null");
            return null;
        }
        if (trustStorePassword == null) {
            log.error((Object)"createRevocationAwareSSLContext: trustStorePassword is null");
            return null;
        }
        if (trustManagerFactoryAlgorithm == null) {
            trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        if (keyStorePath == null) {
            log.error((Object)"createRevocationAwareSSLContext: keyStorePath is null");
            return null;
        }
        if (keyStoreType == null) {
            log.error((Object)"createRevocationAwareSSLContext: keyStoreType is null");
            return null;
        }
        if (keyStorePassword == null) {
            log.error((Object)"createRevocationAwareSSLContext: keyStorePassword is null");
            return null;
        }
        if (keyManagerFactoryAlgorithm == null) {
            keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (minimumTlsVersion == null) {
            minimumTlsVersion = TLS_MINIMUM_VERSION;
        }
        SSLContext sslContext = null;
        try {
            TrustKeyManagerFactorySupplier tkfs = new TrustKeyManagerFactorySupplier();
            TrustManagerFactory tmf = tkfs.getTrustMgrFactory(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword, trustManagerFactoryAlgorithm);
            KeyManagerFactory kmf = tkfs.getKeyMgrFactory(keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyManagerFactoryAlgorithm);
            sslContext = this.createSSLContext(tmf, kmf, minimumTlsVersion, contextProvider);
            if (isInfoEnabled) {
                log.info((Object)("createRevocationAwareSSLContext: Created Revocation Aware SSLContext. minimumTlsVersion=" + minimumTlsVersion + ", sslContext=" + sslContext));
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException e) {
            log.error((Object)("createRevocationAwareSSLContext: Error creating Revocation Aware SSLContext. trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", trustStoreProvider=" + trustStoreProvider + ", keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", keyStoreProvider=" + keyStoreProvider + ", minimumTlsVersion=" + minimumTlsVersion + ", contextProvider=" + contextProvider + ", Exception=" + e), (Throwable)e);
            throw e;
        }
        return sslContext;
    }

    public void setSSLSystemParameters() {
        String functionName = "setSSLSystemParameters";
        boolean isFinestEnabled = log.isFinestEnabled();
        String trustStorePath = this.getTrustStorePath();
        String trustStoreType = this.getTrustStoreType();
        String trustStorePassword = this.getTrustStorePassword();
        String trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        String keyStorePath = this.getKeyStorePath();
        String keyStoreType = this.getKeyStoreType();
        String keyStorePassword = this.getKeyStorePassword();
        String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        if (trustStorePath != null && System.getProperty(SYSTEM_PARAM_TRUST_STORE) == null) {
            System.setProperty(SYSTEM_PARAM_TRUST_STORE, trustStorePath);
        }
        if (trustStoreType != null && System.getProperty(SYSTEM_PARAM_TRUST_STORE_TYPE) == null) {
            System.setProperty(SYSTEM_PARAM_TRUST_STORE_TYPE, trustStoreType);
        }
        if (trustStorePassword != null && System.getProperty(SYSTEM_PARAM_TRUST_STORE_PASSWORD) == null) {
            System.setProperty(SYSTEM_PARAM_TRUST_STORE_PASSWORD, trustStorePassword);
        }
        if (trustManagerFactoryAlgorithm != null && System.getProperty(SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM) == null) {
            System.setProperty(SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM, trustManagerFactoryAlgorithm);
        }
        if (keyStorePath != null && System.getProperty(SYSTEM_PARAM_KEY_STORE) == null) {
            System.setProperty(SYSTEM_PARAM_KEY_STORE, keyStorePath);
        }
        if (keyStoreType != null && System.getProperty(SYSTEM_PARAM_KEY_STORE_TYPE) == null) {
            System.setProperty(SYSTEM_PARAM_KEY_STORE_TYPE, keyStoreType);
        }
        if (keyStorePassword != null && System.getProperty(SYSTEM_PARAM_KEY_STORE_PASSWORD) == null) {
            System.setProperty(SYSTEM_PARAM_KEY_STORE_PASSWORD, keyStorePassword);
        }
        if (keyManagerFactoryAlgorithm != null && System.getProperty(SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM) == null) {
            System.setProperty(SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM, keyManagerFactoryAlgorithm);
        }
        if (isFinestEnabled) {
            log.finest((Object)("setSSLSystemParameters: , trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ",\n" + SYSTEM_PARAM_TRUST_STORE + "=" + System.getProperty(SYSTEM_PARAM_TRUST_STORE) + ", " + SYSTEM_PARAM_TRUST_STORE_TYPE + "=" + System.getProperty(SYSTEM_PARAM_TRUST_STORE_TYPE) + ", " + SYSTEM_PARAM_TRUST_STORE_PROVIDER + "=" + System.getProperty(SYSTEM_PARAM_TRUST_STORE_PROVIDER) + ", " + SYSTEM_PARAM_TRUST_STORE_PASSWORD + "=" + System.getProperty(SYSTEM_PARAM_TRUST_STORE_PASSWORD) + ", " + SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM + "=" + System.getProperty(SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM) + ", " + SYSTEM_PARAM_KEY_STORE + "=" + System.getProperty(SYSTEM_PARAM_KEY_STORE) + ", " + SYSTEM_PARAM_KEY_STORE_TYPE + "=" + System.getProperty(SYSTEM_PARAM_KEY_STORE_TYPE) + ", " + SYSTEM_PARAM_KEY_STORE_PROVIDER + "=" + System.getProperty(SYSTEM_PARAM_KEY_STORE_PROVIDER) + ", " + SYSTEM_PARAM_KEY_STORE_PASSWORD + "=" + System.getProperty(SYSTEM_PARAM_KEY_STORE_PASSWORD) + ", " + SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM + "=" + System.getProperty(SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM)));
        }
    }

    protected SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        return new SecureRandom();
    }
}

