/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.ArgAssert;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PatternsThatMustOccur {
    private final Map<Pattern, Integer> minNumOccurrencesMap;

    private PatternsThatMustOccur(Map<Pattern, Integer> minNumOccurrencesMap) {
        this.minNumOccurrencesMap = Maps.newHashMap(minNumOccurrencesMap);
    }

    public Set<Pattern> getPatterns() {
        return Sets.newHashSet(this.minNumOccurrencesMap.keySet());
    }

    public int getMinNumOccurrences(Pattern pattern) {
        ArgAssert.assertNotNull(pattern, "pattern");
        if (this.minNumOccurrencesMap.containsKey(pattern)) {
            return this.minNumOccurrencesMap.get(pattern);
        }
        throw new IllegalArgumentException("Pattern not found:" + pattern);
    }

    public static final class Builder {
        private final Map<Pattern, Integer> minNumOccurrencesMap = Maps.newHashMap();

        public Builder setMinNumOccurrences(Pattern pattern, int minNumOccurrences) {
            ArgAssert.assertNotNull(pattern, "pattern");
            ArgAssert.assertZeroOrPositive(minNumOccurrences, "minNumOccurrences");
            this.minNumOccurrencesMap.put(pattern, minNumOccurrences);
            return this;
        }

        public PatternsThatMustOccur build() {
            return new PatternsThatMustOccur(this.minNumOccurrencesMap);
        }
    }
}

