/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ConfigLine;
import org.eclipse.jgit.lib.ConfigSnapshot;
import org.eclipse.jgit.lib.DefaultTypedConfigGetter;
import org.eclipse.jgit.lib.TypedConfigGetter;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.RawParseUtils;

public class Config {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final long KiB = 1024L;
    static final long MiB = 0x100000L;
    static final long GiB = 0x40000000L;
    private static final int MAX_DEPTH = 10;
    private static final TypedConfigGetter DEFAULT_GETTER;
    private static TypedConfigGetter typedGetter;
    private final ListenerList listeners = new ListenerList();
    private final AtomicReference<ConfigSnapshot> state;
    private final Config baseConfig;
    static final String MAGIC_EMPTY_VALUE;

    static {
        typedGetter = DEFAULT_GETTER = new DefaultTypedConfigGetter();
        MAGIC_EMPTY_VALUE = new String();
    }

    public Config() {
        this(null);
    }

    public Config(Config defaultConfig) {
        this.baseConfig = defaultConfig;
        this.state = new AtomicReference<ConfigSnapshot>(this.newState());
    }

    public static void setTypedConfigGetter(TypedConfigGetter getter) {
        typedGetter = getter == null ? DEFAULT_GETTER : getter;
    }

    static String escapeValue(String x) {
        if (x.isEmpty()) {
            return "";
        }
        boolean needQuote = x.charAt(0) == ' ' || x.charAt(x.length() - 1) == ' ';
        StringBuilder r = new StringBuilder(x.length());
        int k = 0;
        while (k < x.length()) {
            char c = x.charAt(k);
            switch (c) {
                case '\u0000': {
                    throw new IllegalArgumentException(JGitText.get().configValueContainsNullByte);
                }
                case '\n': {
                    r.append('\\').append('n');
                    break;
                }
                case '\t': {
                    r.append('\\').append('t');
                    break;
                }
                case '\b': {
                    r.append('\\').append('b');
                    break;
                }
                case '\\': {
                    r.append('\\').append('\\');
                    break;
                }
                case '\"': {
                    r.append('\\').append('\"');
                    break;
                }
                case '#': 
                case ';': {
                    needQuote = true;
                    r.append(c);
                    break;
                }
                default: {
                    r.append(c);
                }
            }
            ++k;
        }
        return needQuote ? String.valueOf('\"') + r.toString() + '\"' : r.toString();
    }

    static String escapeSubsection(String x) {
        if (x.isEmpty()) {
            return "\"\"";
        }
        StringBuilder r = new StringBuilder(x.length() + 2).append('\"');
        int k = 0;
        while (k < x.length()) {
            char c = x.charAt(k);
            switch (c) {
                case '\u0000': {
                    throw new IllegalArgumentException(JGitText.get().configSubsectionContainsNullByte);
                }
                case '\n': {
                    throw new IllegalArgumentException(JGitText.get().configSubsectionContainsNewline);
                }
                case '\"': 
                case '\\': {
                    r.append('\\').append(c);
                    break;
                }
                default: {
                    r.append(c);
                }
            }
            ++k;
        }
        return r.append('\"').toString();
    }

    public int getInt(String section, String name, int defaultValue) {
        return typedGetter.getInt(this, section, null, name, defaultValue);
    }

    public int getInt(String section, String subsection, String name, int defaultValue) {
        return typedGetter.getInt(this, section, subsection, name, defaultValue);
    }

    public long getLong(String section, String name, long defaultValue) {
        return typedGetter.getLong(this, section, null, name, defaultValue);
    }

    public long getLong(String section, String subsection, String name, long defaultValue) {
        return typedGetter.getLong(this, section, subsection, name, defaultValue);
    }

    public boolean getBoolean(String section, String name, boolean defaultValue) {
        return typedGetter.getBoolean(this, section, null, name, defaultValue);
    }

    public boolean getBoolean(String section, String subsection, String name, boolean defaultValue) {
        return typedGetter.getBoolean(this, section, subsection, name, defaultValue);
    }

    public <T extends Enum<?>> T getEnum(String section, String subsection, String name, T defaultValue) {
        Enum[] all = Config.allValuesOf(defaultValue);
        return (T)typedGetter.getEnum(this, all, section, subsection, name, defaultValue);
    }

    private static <T> T[] allValuesOf(T value) {
        try {
            return (Object[])value.getClass().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception err) {
            String typeName = value.getClass().getName();
            String msg = MessageFormat.format(JGitText.get().enumValuesNotAvailable, typeName);
            throw new IllegalArgumentException(msg, err);
        }
    }

    public <T extends Enum<?>> T getEnum(T[] all, String section, String subsection, String name, T defaultValue) {
        return (T)typedGetter.getEnum(this, (Enum[])all, section, subsection, name, defaultValue);
    }

    public String getString(String section, String subsection, String name) {
        return this.getRawString(section, subsection, name);
    }

    public String[] getStringList(String section, String subsection, String name) {
        String[] base = this.baseConfig != null ? this.baseConfig.getStringList(section, subsection, name) : EMPTY_STRING_ARRAY;
        String[] self = this.getRawStringList(section, subsection, name);
        if (self == null) {
            return base;
        }
        if (base.length == 0) {
            return self;
        }
        String[] res = new String[base.length + self.length];
        int n = base.length;
        System.arraycopy(base, 0, res, 0, n);
        System.arraycopy(self, 0, res, n, self.length);
        return res;
    }

    public long getTimeUnit(String section, String subsection, String name, long defaultValue, TimeUnit wantUnit) {
        return typedGetter.getTimeUnit(this, section, subsection, name, defaultValue, wantUnit);
    }

    public List<RefSpec> getRefSpecs(String section, String subsection, String name) {
        return typedGetter.getRefSpecs(this, section, subsection, name);
    }

    public Set<String> getSubsections(String section) {
        return this.getState().getSubsections(section);
    }

    public Set<String> getSections() {
        return this.getState().getSections();
    }

    public Set<String> getNames(String section) {
        return this.getNames(section, null);
    }

    public Set<String> getNames(String section, String subsection) {
        return this.getState().getNames(section, subsection);
    }

    public Set<String> getNames(String section, boolean recursive) {
        return this.getState().getNames(section, null, recursive);
    }

    public Set<String> getNames(String section, String subsection, boolean recursive) {
        return this.getState().getNames(section, subsection, recursive);
    }

    public <T> T get(SectionParser<T> parser) {
        ConfigSnapshot myState = this.getState();
        Object obj = myState.cache.get(parser);
        if (obj == null) {
            obj = parser.parse(this);
            myState.cache.put(parser, obj);
        }
        return (T)obj;
    }

    public void uncache(SectionParser<?> parser) {
        this.state.get().cache.remove(parser);
    }

    public ListenerHandle addChangeListener(ConfigChangedListener listener) {
        return this.listeners.addConfigChangedListener(listener);
    }

    protected boolean notifyUponTransientChanges() {
        return true;
    }

    protected void fireConfigChangedEvent() {
        this.listeners.dispatch(new ConfigChangedEvent());
    }

    String getRawString(String section, String subsection, String name) {
        String[] lst = this.getRawStringList(section, subsection, name);
        if (lst != null) {
            return lst[lst.length - 1];
        }
        if (this.baseConfig != null) {
            return this.baseConfig.getRawString(section, subsection, name);
        }
        return null;
    }

    private String[] getRawStringList(String section, String subsection, String name) {
        return this.state.get().get(section, subsection, name);
    }

    private ConfigSnapshot getState() {
        ConfigSnapshot base;
        ConfigSnapshot upd;
        ConfigSnapshot cur;
        do {
            cur = this.state.get();
            base = this.getBaseState();
            if (cur.baseState != base) continue;
            return cur;
        } while (!this.state.compareAndSet(cur, upd = new ConfigSnapshot(cur.entryList, base)));
        return upd;
    }

    private ConfigSnapshot getBaseState() {
        return this.baseConfig != null ? this.baseConfig.getState() : null;
    }

    public void setInt(String section, String subsection, String name, int value) {
        this.setLong(section, subsection, name, value);
    }

    public void setLong(String section, String subsection, String name, long value) {
        String s = value >= 0x40000000L && value % 0x40000000L == 0L ? String.valueOf(String.valueOf(value / 0x40000000L)) + "g" : (value >= 0x100000L && value % 0x100000L == 0L ? String.valueOf(String.valueOf(value / 0x100000L)) + "m" : (value >= 1024L && value % 1024L == 0L ? String.valueOf(String.valueOf(value / 1024L)) + "k" : String.valueOf(value)));
        this.setString(section, subsection, name, s);
    }

    public void setBoolean(String section, String subsection, String name, boolean value) {
        this.setString(section, subsection, name, value ? "true" : "false");
    }

    public <T extends Enum<?>> void setEnum(String section, String subsection, String name, T value) {
        String n = value instanceof ConfigEnum ? ((ConfigEnum)((Object)value)).toConfigValue() : value.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        this.setString(section, subsection, name, n);
    }

    public void setString(String section, String subsection, String name, String value) {
        this.setStringList(section, subsection, name, Collections.singletonList(value));
    }

    public void unset(String section, String subsection, String name) {
        this.setStringList(section, subsection, name, Collections.emptyList());
    }

    public void unsetSection(String section, String subsection) {
        ConfigSnapshot res;
        ConfigSnapshot src;
        while (!this.state.compareAndSet(src = this.state.get(), res = this.unsetSection(src, section, subsection))) {
        }
    }

    private ConfigSnapshot unsetSection(ConfigSnapshot srcState, String section, String subsection) {
        int max = srcState.entryList.size();
        ArrayList<ConfigLine> r = new ArrayList<ConfigLine>(max);
        boolean lastWasMatch = false;
        for (ConfigLine e : srcState.entryList) {
            if (e.includedFrom == null && e.match(section, subsection)) {
                lastWasMatch = true;
                continue;
            }
            if (lastWasMatch && e.section == null && e.subsection == null) continue;
            r.add(e);
        }
        return this.newState(r);
    }

    public void setStringList(String section, String subsection, String name, List<String> values) {
        ConfigSnapshot res;
        ConfigSnapshot src;
        while (!this.state.compareAndSet(src = this.state.get(), res = this.replaceStringList(src, section, subsection, name, values))) {
        }
        if (this.notifyUponTransientChanges()) {
            this.fireConfigChangedEvent();
        }
    }

    private ConfigSnapshot replaceStringList(ConfigSnapshot srcState, String section, String subsection, String name, List<String> values) {
        ConfigLine e;
        List<ConfigLine> entries = Config.copy(srcState, values);
        int entryIndex = 0;
        int valueIndex = 0;
        int insertPosition = -1;
        while (entryIndex < entries.size() && valueIndex < values.size()) {
            e = entries.get(entryIndex);
            if (e.includedFrom == null && e.match(section, subsection, name)) {
                entries.set(entryIndex, e.forValue(values.get(valueIndex++)));
                insertPosition = entryIndex + 1;
            }
            ++entryIndex;
        }
        if (valueIndex == values.size() && entryIndex < entries.size()) {
            while (entryIndex < entries.size()) {
                e = entries.get(entryIndex++);
                if (e.includedFrom != null || !e.match(section, subsection, name)) continue;
                entries.remove(--entryIndex);
            }
        }
        if (valueIndex < values.size() && entryIndex == entries.size()) {
            if (insertPosition < 0) {
                insertPosition = Config.findSectionEnd(entries, section, subsection, true);
            }
            if (insertPosition < 0) {
                e = new ConfigLine();
                e.section = section;
                e.subsection = subsection;
                entries.add(e);
                insertPosition = entries.size();
            }
            while (valueIndex < values.size()) {
                e = new ConfigLine();
                e.section = section;
                e.subsection = subsection;
                e.name = name;
                e.value = values.get(valueIndex++);
                entries.add(insertPosition++, e);
            }
        }
        return this.newState(entries);
    }

    private static List<ConfigLine> copy(ConfigSnapshot src, List<String> values) {
        int max = src.entryList.size() + values.size() + 1;
        ArrayList<ConfigLine> r = new ArrayList<ConfigLine>(max);
        r.addAll(src.entryList);
        return r;
    }

    private static int findSectionEnd(List<ConfigLine> entries, String section, String subsection, boolean skipIncludedLines) {
        int i = 0;
        while (i < entries.size()) {
            ConfigLine e = entries.get(i);
            if ((e.includedFrom == null || !skipIncludedLines) && e.match(section, subsection, null)) {
                ++i;
                while (i < entries.size()) {
                    e = entries.get(i);
                    if (!e.match(section, subsection, e.name)) break;
                    ++i;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toText() {
        StringBuilder out = new StringBuilder();
        for (ConfigLine e : this.state.get().entryList) {
            if (e.includedFrom != null) continue;
            if (e.prefix != null) {
                out.append(e.prefix);
            }
            if (e.section != null && e.name == null) {
                out.append('[');
                out.append(e.section);
                if (e.subsection != null) {
                    boolean quoted;
                    out.append(' ');
                    String escaped = Config.escapeValue(e.subsection);
                    boolean bl = quoted = escaped.startsWith("\"") && escaped.endsWith("\"");
                    if (!quoted) {
                        out.append('\"');
                    }
                    out.append(escaped);
                    if (!quoted) {
                        out.append('\"');
                    }
                }
                out.append(']');
            } else if (e.section != null && e.name != null) {
                if (e.prefix == null || "".equals(e.prefix)) {
                    out.append('\t');
                }
                out.append(e.name);
                if (MAGIC_EMPTY_VALUE != e.value) {
                    out.append(" =");
                    if (e.value != null) {
                        out.append(' ');
                        out.append(Config.escapeValue(e.value));
                    }
                }
                if (e.suffix != null) {
                    out.append(' ');
                }
            }
            if (e.suffix != null) {
                out.append(e.suffix);
            }
            out.append('\n');
        }
        return out.toString();
    }

    public void fromText(String text) throws ConfigInvalidException {
        this.state.set(this.newState(this.fromTextRecurse(text, 1, null)));
    }

    private List<ConfigLine> fromTextRecurse(String text, int depth, String includedFrom) throws ConfigInvalidException {
        ArrayList<ConfigLine> newEntries;
        block15: {
            if (depth > 10) {
                throw new ConfigInvalidException(JGitText.get().tooManyIncludeRecursions);
            }
            newEntries = new ArrayList<ConfigLine>();
            StringReader in = new StringReader(text);
            ConfigLine last = null;
            ConfigLine e = new ConfigLine();
            e.includedFrom = includedFrom;
            while (true) {
                int input;
                if (-1 == (input = in.read())) {
                    if (e.section != null) {
                        newEntries.add(e);
                    }
                    break block15;
                }
                char c = (char)input;
                if ('\n' == c) {
                    newEntries.add(e);
                    if (e.section != null) {
                        last = e;
                    }
                    e = new ConfigLine();
                    e.includedFrom = includedFrom;
                    continue;
                }
                if (e.suffix != null) {
                    e.suffix = String.valueOf(e.suffix) + c;
                    continue;
                }
                if (';' == c || '#' == c) {
                    e.suffix = String.valueOf(c);
                    continue;
                }
                if (e.section == null && Character.isWhitespace(c)) {
                    if (e.prefix == null) {
                        e.prefix = "";
                    }
                    e.prefix = String.valueOf(e.prefix) + c;
                    continue;
                }
                if ('[' == c) {
                    e.section = Config.readSectionName(in);
                    input = in.read();
                    if (34 == input) {
                        e.subsection = Config.readSubsectionName(in);
                        input = in.read();
                    }
                    if (93 != input) {
                        throw new ConfigInvalidException(JGitText.get().badGroupHeader);
                    }
                    e.suffix = "";
                    continue;
                }
                if (last == null) break;
                e.section = last.section;
                e.subsection = last.subsection;
                in.reset();
                e.name = Config.readKeyName(in);
                if (e.name.endsWith("\n")) {
                    e.name = e.name.substring(0, e.name.length() - 1);
                    e.value = MAGIC_EMPTY_VALUE;
                } else {
                    e.value = Config.readValue(in);
                }
                if (!e.section.equalsIgnoreCase("include")) continue;
                this.addIncludedConfig(newEntries, e, depth);
            }
            throw new ConfigInvalidException(JGitText.get().invalidLineInConfigFile);
        }
        return newEntries;
    }

    @Nullable
    protected byte[] readIncludedConfig(String relPath) throws ConfigInvalidException {
        return null;
    }

    private void addIncludedConfig(List<ConfigLine> newEntries, ConfigLine line, int depth) throws ConfigInvalidException {
        if (!line.name.equalsIgnoreCase("path") || line.value == null || line.value.equals(MAGIC_EMPTY_VALUE)) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().invalidLineInConfigFileWithParam, line));
        }
        byte[] bytes = this.readIncludedConfig(line.value);
        if (bytes == null) {
            return;
        }
        String decoded = this.isUtf8(bytes) ? RawParseUtils.decode(StandardCharsets.UTF_8, bytes, 3, bytes.length) : RawParseUtils.decode(bytes);
        try {
            newEntries.addAll(this.fromTextRecurse(decoded, depth + 1, line.value));
        }
        catch (ConfigInvalidException e) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, line.value), e);
        }
    }

    private ConfigSnapshot newState() {
        return new ConfigSnapshot(Collections.emptyList(), this.getBaseState());
    }

    private ConfigSnapshot newState(List<ConfigLine> entries) {
        return new ConfigSnapshot(Collections.unmodifiableList(entries), this.getBaseState());
    }

    protected void clear() {
        this.state.set(this.newState());
    }

    protected boolean isUtf8(byte[] bytes) {
        return bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65;
    }

    private static String readSectionName(StringReader in) throws ConfigInvalidException {
        StringBuilder name;
        block6: {
            name = new StringBuilder();
            while (true) {
                int c;
                if ((c = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (93 == c) {
                    in.reset();
                    break block6;
                }
                if (32 == c || 9 == c) {
                    do {
                        if ((c = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (34 != c) continue;
                        in.reset();
                        break block6;
                    } while (32 == c || 9 == c);
                    throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name));
                }
                if (!Character.isLetterOrDigit((char)c) && 46 != c && 45 != c) break;
                name.append((char)c);
            }
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name));
        }
        return name.toString();
    }

    private static String readKeyName(StringReader in) throws ConfigInvalidException {
        StringBuilder name;
        block7: {
            int c;
            name = new StringBuilder();
            while (true) {
                if ((c = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (61 == c) break block7;
                if (32 == c || 9 == c) {
                    do {
                        if ((c = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (61 == c) break block7;
                        if (59 != c && 35 != c && 10 != c) continue;
                        in.reset();
                        break block7;
                    } while (32 == c || 9 == c);
                    throw new ConfigInvalidException(JGitText.get().badEntryDelimiter);
                }
                if (!Character.isLetterOrDigit((char)c) && c != 45) break;
                name.append((char)c);
            }
            if (10 == c) {
                in.reset();
                name.append((char)c);
            } else {
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEntryName, name));
            }
        }
        return name.toString();
    }

    private static String readSubsectionName(StringReader in) throws ConfigInvalidException {
        int c;
        StringBuilder r = new StringBuilder();
        block4: while ((c = in.read()) >= 0) {
            if (10 == c) {
                throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
            }
            if (92 == c) {
                c = in.read();
                switch (c) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 34: 
                    case 92: {
                        r.append((char)c);
                        continue block4;
                    }
                }
                r.append((char)c);
                continue;
            }
            if (34 == c) break;
            r.append((char)c);
        }
        return r.toString();
    }

    private static String readValue(StringReader in) throws ConfigInvalidException {
        int c;
        StringBuilder value = new StringBuilder();
        StringBuilder trailingSpaces = null;
        boolean quote = false;
        boolean inLeadingSpace = true;
        block9: while ((c = in.read()) >= 0) {
            if (10 == c) {
                if (quote) {
                    throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
                }
                in.reset();
                break;
            }
            if (!(quote || 59 != c && 35 != c)) {
                if (trailingSpaces != null) {
                    trailingSpaces.setLength(0);
                }
                in.reset();
                break;
            }
            char cc = (char)c;
            if (Character.isWhitespace(cc)) {
                if (inLeadingSpace) continue;
                if (trailingSpaces == null) {
                    trailingSpaces = new StringBuilder();
                }
                trailingSpaces.append(cc);
                continue;
            }
            inLeadingSpace = false;
            if (trailingSpaces != null) {
                value.append((CharSequence)trailingSpaces);
                trailingSpaces.setLength(0);
            }
            if (92 == c) {
                c = in.read();
                switch (c) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 10: {
                        continue block9;
                    }
                    case 116: {
                        value.append('\t');
                        continue block9;
                    }
                    case 98: {
                        value.append('\b');
                        continue block9;
                    }
                    case 110: {
                        value.append('\n');
                        continue block9;
                    }
                    case 92: {
                        value.append('\\');
                        continue block9;
                    }
                    case 34: {
                        value.append('\"');
                        continue block9;
                    }
                }
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEscape, Character.valueOf((char)c)));
            }
            if (34 == c) {
                quote = !quote;
                continue;
            }
            value.append(cc);
        }
        return value.length() > 0 ? value.toString() : null;
    }

    public static interface ConfigEnum {
        public String toConfigValue();

        public boolean matchConfigValue(String var1);
    }

    public static interface SectionParser<T> {
        public T parse(Config var1);
    }

    private static class StringReader {
        private final char[] buf;
        private int pos;

        StringReader(String in) {
            this.buf = in.toCharArray();
        }

        int read() {
            try {
                return this.buf[this.pos++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.pos = this.buf.length;
                return -1;
            }
        }

        void reset() {
            --this.pos;
        }
    }
}

