/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.client;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.xml.DOMConfigurator;

class ClientPropertyWatch {
    protected Calendar reloadTime = Calendar.getInstance();
    private int propWatchSeconds = 60;
    static final String DEFAULT_CONFIGURATION_FILE = "log4j.properties";
    static final String DEFAULT_XML_CONFIGURATION_FILE = "log4j.xml";
    static final String DEFAULT_CONFIGURATION_KEY = "log4j.configuration";
    static final String CONFIGURATOR_CLASS_KEY = "log4j.configuratorClass";
    static final String DEFAULT_INIT_OVERRIDE_KEY = "log4j.defaultInitOverride";
    static URL url = null;
    static File configurationFile = null;
    static long configurationLastModified = 0L;

    protected ClientPropertyWatch() {
        this.setPropWatchSeconds();
        this.reloadTime.add(13, this.propWatchSeconds);
    }

    private void setPropWatchSeconds() {
        try {
            String string = System.getenv("COMMON_LOG_PROP_WATCH");
            this.propWatchSeconds = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.propWatchSeconds = 60;
        }
    }

    protected void check() {
        if (this.propWatchSeconds != 0 && Calendar.getInstance().after(this.reloadTime)) {
            this.setPropWatchSeconds();
            this.reloadTime = Calendar.getInstance();
            this.reloadTime.add(13, this.propWatchSeconds);
            if (url != null && configurationFile.lastModified() != configurationLastModified) {
                configurationLastModified = configurationFile.lastModified();
                if (url.toString().toUpperCase().endsWith(".XML")) {
                    DOMConfigurator.configure((URL)url);
                } else {
                    PropertyConfigurator.configure((URL)url);
                }
            }
        }
    }

    static {
        String string = OptionConverter.getSystemProperty((String)DEFAULT_INIT_OVERRIDE_KEY, null);
        String string2 = OptionConverter.getSystemProperty((String)DEFAULT_CONFIGURATION_KEY, null);
        if (string == null || "false".equalsIgnoreCase(string)) {
            if (string2 == null) {
                url = Loader.getResource((String)DEFAULT_XML_CONFIGURATION_FILE);
                if (url == null) {
                    url = Loader.getResource((String)DEFAULT_CONFIGURATION_FILE);
                }
            } else {
                try {
                    url = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    url = Loader.getResource((String)string2);
                }
            }
        }
        if (url != null) {
            configurationFile = new File(url.getFile());
            configurationLastModified = configurationFile.lastModified();
        }
    }
}

