/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.client;

import com.avaya.common.logging.client.CommonLogManager;
import com.avaya.common.logging.client.DefaultLoggingProperties;
import com.avaya.common.logging.client.FallbackErrorHandler;
import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.helper.EventCode;
import com.avaya.common.logging.helper.EventMsg;
import com.avaya.common.logging.helper.LogRecordJDO;
import java.rmi.server.UID;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.spi.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger {
    static String FQCN = Logger.class.getName();
    protected org.apache.log4j.Logger log4jLogger;
    private String logJDO = null;

    public static Logger getLogger(String string) {
        return CommonLogManager.getLogger(string);
    }

    public static Logger getLogger(Class<?> clazz) {
        return CommonLogManager.getLogger(clazz.getName());
    }

    public static Logger getLogger(String string, UID uID) {
        return CommonLogManager.getLogger(string, uID);
    }

    public static Logger getLogger(Class<?> clazz, UID uID) {
        return CommonLogManager.getLogger(clazz.getName(), uID);
    }

    public static Logger getRootLogger() {
        return CommonLogManager.getRootLogger();
    }

    protected Logger(String string) {
        this.log4jLogger = org.apache.log4j.Logger.getLogger((String)string);
        this.setErrorHandler();
    }

    protected Logger() {
        this.log4jLogger = org.apache.log4j.Logger.getRootLogger();
        this.setErrorHandler();
    }

    protected LogRecordJDO getLogRecordJDO() {
        return CommonLogManager.getLogRecordJDO(this.logJDO);
    }

    protected void initializeJDO(String string, String string2, String string3, String string4) {
        if (this.logJDO == null) {
            this.logJDO = this.log4jLogger.getName();
        }
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setHostname(string);
        logRecordJDO.setProcessId(string2);
        logRecordJDO.setProcessName(string3);
        logRecordJDO.setLogProductType(string4);
        CommonLogManager.updateLogRecordJDO(this.logJDO, logRecordJDO);
    }

    protected void setJDO(String string) {
        this.logJDO = string;
    }

    protected boolean hasAppender(Category category) {
        boolean bl = false;
        Enumeration enumeration = category.getAllAppenders();
        if (!enumeration.hasMoreElements()) {
            if (category.getParent() != null) {
                bl = this.hasAppender(category.getParent());
            }
        } else {
            bl = true;
        }
        return bl;
    }

    protected void setFallBackErrorHandler(Category category) {
        Enumeration enumeration = category.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            ErrorHandler errorHandler = appender.getErrorHandler();
            if (!(errorHandler instanceof OnlyOnceErrorHandler)) continue;
            FallbackErrorHandler fallbackErrorHandler = new FallbackErrorHandler();
            fallbackErrorHandler.setAppender(appender);
            fallbackErrorHandler.setLogger(this.log4jLogger);
            appender.setErrorHandler((ErrorHandler)fallbackErrorHandler);
        }
        if (category.getParent() != null) {
            this.setFallBackErrorHandler(category.getParent());
        }
    }

    protected void setErrorHandler() {
        boolean bl = this.hasAppender((Category)this.log4jLogger);
        if (!bl) {
            LogLog.debug((String)"The log4j appender not found load default properties ");
            DefaultLoggingProperties defaultLoggingProperties = new DefaultLoggingProperties();
            Properties properties = defaultLoggingProperties.getDefaultLoggingProperties();
            PropertyConfigurator.configure((Properties)properties);
        } else {
            this.setFallBackErrorHandler((Category)this.log4jLogger);
        }
    }

    public void setLevel(Level level) {
        this.log4jLogger.setLevel(level);
    }

    public Enumeration getAllAppenders() {
        return this.log4jLogger.getAllAppenders();
    }

    public void addAppender(Appender appender) {
        this.log4jLogger.addAppender(appender);
    }

    public void removeAppender(Appender appender) {
        this.log4jLogger.removeAppender(appender);
    }

    public Appender getAppender(String string) {
        return this.log4jLogger.getAppender(string);
    }

    public void setAdditivity(boolean bl) {
        this.log4jLogger.setAdditivity(bl);
    }

    public void error(Object object) {
        this.error(object, null);
    }

    public void error(Object object, Throwable throwable) {
        this.log(object, throwable, (Priority)Level.ERROR);
    }

    public void fatal(Object object) {
        this.fatal(object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.log(object, throwable, (Priority)Level.FATAL);
    }

    public void fine(Object object) {
        this.fine(object, null);
    }

    public void fine(Object object, Throwable throwable) {
        this.log(object, throwable, (Priority)LogLevel.FINE);
    }

    public void finer(Object object) {
        this.finer(object, null);
    }

    public void finer(Object object, Throwable throwable) {
        this.log(object, throwable, (Priority)LogLevel.FINER);
    }

    public void finest(Object object) {
        this.finest(object, null);
    }

    public void finest(Object object, Throwable throwable) {
        this.log(object, throwable, (Priority)LogLevel.FINEST);
    }

    public void info(Object object) {
        this.info(object, null);
    }

    public void info(Object object, Throwable throwable) {
        this.log(object, throwable, (Priority)Level.INFO);
    }

    public void warn(Object object) {
        this.warn(object, null);
    }

    public void warn(Object object, Throwable throwable) {
        this.log(object, throwable, (Priority)Level.WARN);
    }

    public boolean isEnabledFor(Priority priority) {
        return this.log4jLogger.isEnabledFor(priority);
    }

    public boolean isFineEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)LogLevel.FINE);
    }

    public boolean isFinerEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)LogLevel.FINER);
    }

    public boolean isFinestEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)LogLevel.FINEST);
    }

    public boolean isInfoEnabled() {
        return this.log4jLogger.isEnabledFor((Priority)Level.INFO);
    }

    public void logEvent(EventCode eventCode, Object ... objectArray) {
        EventMsg eventMsg = new EventMsg(eventCode, objectArray);
        this.log(eventMsg, null, eventCode.getLogLevel());
    }

    public void logEvent(EventCode eventCode, Throwable throwable, Object ... objectArray) {
        EventMsg eventMsg = new EventMsg(eventCode, objectArray);
        this.log(eventMsg, throwable, eventCode.getLogLevel());
    }

    protected void log(Object object, Throwable throwable, Priority priority) {
        int n = priority.getSyslogEquivalent();
        CommonLogManager.checkConfig();
        if (object instanceof LogRecordJDO) {
            ((LogRecordJDO)object).setSeverity(n);
            this.log4jLogger.log(FQCN, priority, object, throwable);
        } else {
            LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
            logRecordJDO.setLogMessage(object);
            logRecordJDO.setSeverity(n);
            this.log4jLogger.log(FQCN, priority, (Object)logRecordJDO, throwable);
        }
    }

    public void setHostname(String string) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setHostname(string);
        CommonLogManager.updateLogRecordJDO(this.logJDO, logRecordJDO);
    }

    public void setInstanceHostname(String string) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setHostname(string);
        CommonLogManager.updateInstanceLogRecordJDO(this.logJDO, logRecordJDO);
    }

    public String getHostname() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        return logRecordJDO.getHostname();
    }

    public String getInstanceHostname() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        return logRecordJDO.getHostname();
    }

    public void setProcessId(String string) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setProcessId(string);
        CommonLogManager.updateLogRecordJDO(this.logJDO, logRecordJDO);
    }

    public String getProcessId() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        return logRecordJDO.getProcessId();
    }

    public void setInstanceProcessId(String string) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setProcessId(string);
        CommonLogManager.updateInstanceLogRecordJDO(this.logJDO, logRecordJDO);
    }

    public String getInstanceProcessId() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        return logRecordJDO.getProcessId();
    }

    public void setProcessName(String string) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setProcessName(string);
        CommonLogManager.updateLogRecordJDO(this.logJDO, logRecordJDO);
    }

    public String getProcessName() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        return logRecordJDO.getProcessName();
    }

    public void setInstanceProcessName(String string) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setProcessName(string);
        CommonLogManager.updateInstanceLogRecordJDO(this.logJDO, logRecordJDO);
    }

    public String getInstanceProcessName() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        return logRecordJDO.getProcessName();
    }

    public void setLogProductType(String string) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setLogProductType(string);
        CommonLogManager.updateLogRecordJDO(this.logJDO, logRecordJDO);
    }

    public String getLogProductType() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        return logRecordJDO.getLogProductType();
    }

    public void setInstanceLogProductType(String string) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setLogProductType(string);
        CommonLogManager.updateInstanceLogRecordJDO(this.logJDO, logRecordJDO);
    }

    public String getInstanceLogProductType() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        return logRecordJDO.getLogProductType();
    }

    public void setTimeZone(TimeZone timeZone) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setTimeZone(timeZone);
        CommonLogManager.updateLogRecordJDO(this.logJDO, logRecordJDO);
    }

    public TimeZone getTimeZone() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        return logRecordJDO.getTimeZone();
    }

    public void setInstanceTimeZone(TimeZone timeZone) {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        logRecordJDO.setTimeZone(timeZone);
        CommonLogManager.updateInstanceLogRecordJDO(this.logJDO, logRecordJDO);
    }

    public TimeZone getInstanceTimeZone() {
        LogRecordJDO logRecordJDO = CommonLogManager.getLogRecordJDO(this.logJDO);
        return logRecordJDO.getTimeZone();
    }
}

