/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.ChannelSversion;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dao.ClusterAttributeDAO;
import com.avaya.zephyr.platform.dm.AusPlatformServiceDM;
import java.net.InetAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ChannelDAO
extends DataAccessObject {
    private static final Logger LOG = AsmLogger.getLogger(ChannelDAO.class);
    protected static final String CHANNEL = "zr_channel";
    protected static final String CHANNEL_SERVICE_MAPPING = "zr_map_ptops_sversion";
    protected static final String SERVICE_VERSION = "zr_service_version";
    protected static final String SERVICE = "zr_service";
    protected static final String SERVICE_CLUSTER_MAP = "zr_map_sversion_cluster";
    protected static final String FS_INSTANCE = "zr_fsinstance";
    protected static final String MAP_CATTRIBUTE_CLUSTER = "zr_map_cattribute_cluster";
    protected static final String ATTRIBUTE_METADATA = "zr_attribute_metadata";
    private Map<String, Map<Long, ChannelSversion>> channelToSversionMap = new ConcurrentHashMap<String, Map<Long, ChannelSversion>>();
    private Map<String, ChannelSversion> channelToPreferredVersionMap;
    protected static final String getAllChannels = "SELECT ch.id, ch.name, ch.type, map.service_version_id, s.service_name, v.version_string, v1.version_string as preferred_version, v.service_id FROM zr_channel ch JOIN zr_map_ptops_sversion map ON ch.id = map.channel_id JOIN zr_service_version v ON map.service_version_id = v.id JOIN zr_service s ON v.service_id = s.id JOIN zr_map_sversion_cluster c ON c.sversion_id = v.id JOIN zr_service_version v1 ON v.service_id = v1.service_id JOIN zr_map_sversion_cluster c1 ON c1.sversion_id = v1.id WHERE c1.is_latest='t' ";
    protected static final String preferredVersionQuery = "SELECT v.id, s.service_name, v.version_string, v1.version_string AS preferred_version FROM zr_service_version v JOIN zr_service s ON v.service_id=s.id JOIN zr_service_version v1 ON v.service_id=v1.service_id JOIN zr_map_sversion_cluster c1 ON v1.id=c1.sversion_id AND c1.is_preferred='t' AND v.id= ? AND c1.cluster_id= ?";
    protected static final String latestVersionQuery = "SELECT v.id, s.service_name, v.version_string, v1.version_string AS preferred_version FROM zr_service_version v JOIN zr_service s ON v.service_id=s.id JOIN zr_service_version v1 ON v.service_id=v1.service_id JOIN zr_map_sversion_cluster c1 ON v1.id=c1.sversion_id AND c1.is_latest='t' AND v.id= ? AND c1.cluster_id= ?";

    protected ResultSetMapper getChannelServiceMapper() {
        return new RSMgetChannelServiceMapper();
    }

    public Map<String, Map<Long, ChannelSversion>> getChannelToSversionMap() {
        return this.channelToSversionMap;
    }

    public Map<String, ChannelSversion> getChannelToPreferredVersionMap() {
        return this.channelToPreferredVersionMap;
    }

    public ChannelDAO() {
        super(true);
    }

    public void init() {
        this.rebuild();
    }

    private void rebuild() {
        List tmpChannelSversionList;
        LOG.info((Object)"ChannelDAO initializing");
        Long clusterId = null;
        try {
            AusInstanceDAO ausInstDao = (AusInstanceDAO)DMFactory.getInstance().getDataMgr(AusInstanceDAO.class);
            clusterId = ausInstDao.getMyClusterId();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in getting clusterId. Continue with DAO initialization");
            LOG.fine((Object)"Error details", (Throwable)e);
            clusterId = this.getClusterId();
            LOG.info((Object)("ClusterId alternate attempt : " + clusterId));
        }
        String getAllClusterChannels = getAllChannels;
        if (clusterId != null) {
            getAllClusterChannels = "SELECT ch.id, ch.name, ch.type, map.service_version_id, s.service_name, v.version_string, v1.version_string as preferred_version, v.service_id FROM zr_channel ch JOIN zr_map_ptops_sversion map ON ch.id = map.channel_id JOIN zr_service_version v ON map.service_version_id = v.id JOIN zr_service s ON v.service_id = s.id JOIN zr_map_sversion_cluster c ON c.sversion_id = v.id JOIN zr_service_version v1 ON v.service_id = v1.service_id JOIN zr_map_sversion_cluster c1 ON c1.sversion_id = v1.id WHERE c1.is_latest='t'  AND c1.cluster_id=" + clusterId + " AND c.cluster_id=" + clusterId;
        }
        Object[] params = new Object[]{};
        try {
            tmpChannelSversionList = (List)this.dataSource.executeQuery(getAllClusterChannels, params, (Object)this.getChannelServiceMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        if (tmpChannelSversionList != null) {
            ListIterator iterator = tmpChannelSversionList.listIterator();
            while (iterator.hasNext()) {
                ChannelSversion channelSversion = (ChannelSversion)iterator.next();
                String preferredVersion = this.getPreferredVersion(channelSversion.getServiceVersionId(), clusterId);
                if (preferredVersion == null) continue;
                channelSversion.setPreferredVersion(preferredVersion);
            }
            this.buildMap(tmpChannelSversionList);
        }
    }

    private String getPreferredVersion(Long sversionId, Long clusterId) {
        try {
            Object[] params = new Object[]{sversionId, clusterId};
            String version = (String)this.dataSource.executeQuery(preferredVersionQuery, params, (Object)this.getPreferredVersionMapper());
            if (version != null) {
                return version;
            }
            version = (String)this.dataSource.executeQuery(latestVersionQuery, params, (Object)this.getPreferredVersionMapper());
            if (version != null) {
                return version;
            }
            return null;
        }
        catch (DMException e) {
            LOG.error((Object)("Error in getting preferred version, sversionId=" + sversionId + ", clusterId=" + clusterId), (Throwable)e);
            return null;
        }
    }

    protected ResultSetMapper getPreferredVersionMapper() {
        return new ResultSetMapper(){

            public String mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    return results.getString("preferred_version");
                }
                return null;
            }
        };
    }

    private Long getClusterId() {
        try {
            String ip = InetAddress.getLocalHost().getHostAddress();
            String hostName = InetAddress.getLocalHost().getHostName();
            String query = "SELECT cluster_id FROM zr_fsinstance where lower(managementaccesspointhostname) IN ('" + ip + "', lower('" + hostName + "')) limit 1";
            Object[] params = new Object[]{};
            return (Long)this.dataSource.executeQuery(query, params, (Object)this.getClusterIdMapper());
        }
        catch (Exception e) {
            LOG.error((Object)"error in getting clusterId");
            LOG.fine((Object)"error details", (Throwable)e);
            return null;
        }
    }

    protected ResultSetMapper getClusterIdMapper() {
        return new ResultSetMapper(){

            public Long mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    return results.getLong("cluster_id");
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMap(List<ChannelSversion> channelServiceList) {
        ConcurrentHashMap<String, Map<Long, ChannelSversion>> tmpchannelToSversionMap = new ConcurrentHashMap<String, Map<Long, ChannelSversion>>();
        ConcurrentHashMap<String, ChannelSversion> tmpchannelToPreferredVersionMap = new ConcurrentHashMap<String, ChannelSversion>();
        for (ChannelSversion channelService : channelServiceList) {
            String channel = channelService.getChannelName();
            if (channel == null) {
                LOG.warn((Object)("buildMap: Channel has no channel name " + channelService));
                continue;
            }
            if (channelService.getServiceVersionId() == null) {
                LOG.warn((Object)("buildMap: channel has no service version associated with it:" + channelService));
                continue;
            }
            ConcurrentHashMap<Long, ChannelSversion> servicesPerChannelMap = (ConcurrentHashMap<Long, ChannelSversion>)tmpchannelToSversionMap.get(channel);
            if (servicesPerChannelMap == null) {
                servicesPerChannelMap = new ConcurrentHashMap<Long, ChannelSversion>();
                tmpchannelToSversionMap.put(channel, servicesPerChannelMap);
            }
            servicesPerChannelMap.put(channelService.getServiceVersionId(), channelService);
            ChannelSversion prefSversion = (ChannelSversion)tmpchannelToPreferredVersionMap.get(channel);
            if (prefSversion == null) {
                tmpchannelToPreferredVersionMap.put(channel, channelService);
                continue;
            }
            if (prefSversion.getServiceName().equals(channelService.getServiceName())) continue;
            String adminPreference = this.getClusterOrGlobalDefault(channel);
            if (!channelService.getServiceName().equals(adminPreference)) continue;
            tmpchannelToPreferredVersionMap.put(channel, channelService);
        }
        this.lock.acquireWriteLock();
        try {
            this.channelToSversionMap = tmpchannelToSversionMap;
            this.channelToPreferredVersionMap = tmpchannelToPreferredVersionMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private String getClusterOrGlobalDefault(String channel) {
        String prefServiceName = null;
        try {
            ClusterAttributeDAO attributeDao = (ClusterAttributeDAO)DMFactory.getInstance().getDataMgr(ClusterAttributeDAO.class);
            prefServiceName = attributeDao.getClusterAttribute("DefaultChannelProvider" + channel.toUpperCase());
        }
        catch (NoAttributeFoundException e) {
            LOG.finest((Object)("getClusterOrGlobalDefault() no cluster attribute found for channel " + channel));
        }
        if (prefServiceName == null) {
            AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
            prefServiceName = dm.getGlobalAttribute("Service for Channel-" + channel);
        }
        return prefServiceName;
    }

    @SMConsole(description="Get all Channel Services")
    public Map<String, Map<Long, ChannelSversion>> getAllChannelServices() {
        try {
            this.lock.acquireReadLock();
            Map<String, Map<Long, ChannelSversion>> map = this.channelToSversionMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get a Channel Services", parameterNames={"channel"})
    public Map<Long, ChannelSversion> getAllServicesPerChannel(String channel) {
        try {
            this.lock.acquireReadLock();
            if (channel != null) {
                Map<Long, ChannelSversion> map = this.channelToSversionMap.get(channel);
                return map;
            }
            Map<Long, ChannelSversion> map = null;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get preferred service version for a channel", parameterNames={"channel"})
    public ChannelSversion getPrefSversionForChannel(String channel) {
        try {
            this.lock.acquireReadLock();
            if (channel != null) {
                ChannelSversion channelSversion = this.channelToPreferredVersionMap.get(channel);
                return channelSversion;
            }
            ChannelSversion channelSversion = null;
            return channelSversion;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get preferred service versions for all channels")
    public Map<String, ChannelSversion> getAllPreferredSversions() {
        try {
            this.lock.acquireReadLock();
            Map<String, ChannelSversion> map = this.channelToPreferredVersionMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList(CHANNEL, CHANNEL_SERVICE_MAPPING, SERVICE_VERSION, ATTRIBUTE_METADATA, SERVICE, SERVICE_CLUSTER_MAP, FS_INSTANCE, MAP_CATTRIBUTE_CLUSTER);
    }

    protected Object getMainCollection() {
        return this.channelToSversionMap;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        String tableName = tableEvent.getTableName();
        if (CHANNEL.equals(tableName) || CHANNEL_SERVICE_MAPPING.equals(tableName) || SERVICE_VERSION.equals(tableName) || ATTRIBUTE_METADATA.equals(tableName) || SERVICE.equals(tableName) || SERVICE_CLUSTER_MAP.equals(tableName) || FS_INSTANCE.equals(tableName) || MAP_CATTRIBUTE_CLUSTER.equals(tableName)) {
            this.rebuild();
        } else {
            LOG.warn((Object)("updateDAO: received tableEvent for table " + tableName));
        }
    }

    public static class RSMgetChannelServiceMapper
    implements ResultSetMapper {
        public List<ChannelSversion> mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<ChannelSversion> tmpList = new ArrayList<ChannelSversion>();
            while (results.next()) {
                tmpList.add(new ChannelSversion((Long)results.getObject("id"), results.getString("name"), results.getString("type"), (Long)results.getObject("service_version_id"), results.getString("service_name"), results.getString("version_string"), results.getString("preferred_version"), (Long)results.getObject("service_id")));
            }
            return tmpList;
        }
    }
}

