/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.TemplateServiceAttribute;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemplateServiceAttributeDAO
extends DataAccessObject {
    private final String getAllTemplateServiceAttribute = "SELECT * FROM zr_template_service_attribute";
    private Map<Long, TemplateServiceAttribute> templateServiceAttributeMap;
    private Map<Long, List<TemplateServiceAttribute>> templateServiceToAttributeMap;
    private static final Logger log = AsmLogger.getLogger(TemplateServiceAttributeDAO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map tmpMap;
        HashMap<Long, List<TemplateServiceAttribute>> tmpTSToAttrMap = new HashMap<Long, List<TemplateServiceAttribute>>();
        try {
            tmpMap = (Map)this.dataSource.executeQuery("SELECT * FROM zr_template_service_attribute", new Object[0], (Object)this.getTemplateServiceAttributeMapper());
            for (TemplateServiceAttribute tsa : tmpMap.values()) {
                Long tsId = tsa.getTemplateServiceId();
                if (tmpTSToAttrMap.get(tsId) == null) {
                    tmpTSToAttrMap.put(tsId, new ArrayList());
                }
                ((List)tmpTSToAttrMap.get(tsId)).add(tsa);
            }
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.templateServiceAttributeMap = tmpMap;
            this.templateServiceToAttributeMap = tmpTSToAttrMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @SMConsole(description="Get all Zephyr Template Service Attributes")
    public Map<Long, TemplateServiceAttribute> getAllTemplSvcAttr() {
        return this.templateServiceAttributeMap;
    }

    public TemplateServiceAttribute getTemplateServiceAttribute(Long id) {
        return this.templateServiceAttributeMap.get(id);
    }

    @SMConsole(description="Get all attributes for the given Template Service Attribute ID.", parameterNames={"templateServiceId"})
    public Map<String, String> getAllTemplSvcAttrById(Long tmplSvcId) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        List<TemplateServiceAttribute> attrs = this.templateServiceToAttributeMap.get(tmplSvcId);
        if (attrs != null) {
            for (TemplateServiceAttribute tsa : attrs) {
                attributes.put(tsa.getName(), tsa.getValue());
            }
        }
        return attributes;
    }

    protected ResultSetMapper getTemplateServiceAttributeMapper() {
        return new ResultSetMapper(){

            public Map<Long, TemplateServiceAttribute> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, TemplateServiceAttribute> tmpMap = new HashMap<Long, TemplateServiceAttribute>();
                while (results.next()) {
                    Long id = (Long)results.getObject("id");
                    tmpMap.put(id, new TemplateServiceAttribute(id, results.getString("name"), results.getString("value"), results.getString("user_changeable"), (Long)results.getObject("template_service_id"), (Long)results.getObject("service_attribute_default_id")));
                }
                return tmpMap;
            }
        };
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        this.reinit();
    }

    public List<String> getDependentTables() {
        return Arrays.asList("zr_template_service_attribute");
    }

    protected Object getMainCollection() {
        return this.templateServiceAttributeMap;
    }
}

