/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListTagCommand;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_CreateATag")
class Tag
extends TextBuiltin {
    @Option(name="-f", usage="usage_forceReplacingAnExistingTag")
    private boolean force;
    @Option(name="-d", usage="usage_tagDelete")
    private boolean delete;
    @Option(name="-m", metaVar="metaVar_message", usage="usage_tagMessage")
    private String message = "";
    @Argument(index=0, metaVar="metaVar_name")
    private String tagName;
    @Argument(index=1, metaVar="metaVar_object")
    private ObjectId object;

    Tag() {
    }

    @Override
    protected void run() throws Exception {
        block25: {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Git git = new Git(this.db);){
                if (this.tagName != null) {
                    if (this.delete) {
                        List deletedTags = git.tagDelete().setTags(new String[]{this.tagName}).call();
                        if (deletedTags.isEmpty()) {
                            throw Tag.die(MessageFormat.format(CLIText.get().tagNotFound, this.tagName));
                        }
                        break block25;
                    }
                    TagCommand command = git.tag().setForceUpdate(this.force).setMessage(this.message).setName(this.tagName);
                    if (this.object != null) {
                        Throwable throwable2 = null;
                        Object var6_13 = null;
                        try (RevWalk walk = new RevWalk(this.db);){
                            command.setObjectId(walk.parseAny((AnyObjectId)this.object));
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    try {
                        command.call();
                        break block25;
                    }
                    catch (RefAlreadyExistsException e) {
                        throw Tag.die(MessageFormat.format(CLIText.get().tagAlreadyExists, this.tagName));
                    }
                }
                ListTagCommand command = git.tagList();
                List list = command.call();
                for (Ref ref : list) {
                    this.outw.println(Repository.shortenRefName((String)ref.getName()));
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }
}

