/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.call.speech.voicexml.sample;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.CallListenerAbstract;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.call.speech.search.SpeechFactory;
import com.avaya.collaboration.call.speech.voicexml.VoiceXMLDialogCause;
import com.avaya.collaboration.call.speech.voicexml.VoiceXMLDialogItem;
import com.avaya.collaboration.call.speech.voicexml.VoiceXMLDialogListener;
import com.avaya.collaboration.util.logger.Logger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;

public class SampleVoiceXMLDialog
extends CallListenerAbstract {
    private final Logger logger = Logger.getLogger(SampleVoiceXMLDialog.class);

    @Override
    public void callIntercepted(Call call) {
        VoiceXMLDialogItem voiceXMLDialogItem = SpeechFactory.createVoiceXMLDialogItem();
        try {
            URI documentUrl = new URI("http://speechserver.test.com/test.vxml");
            voiceXMLDialogItem.setVoiceXMLScript(documentUrl);
            MyVoiceXMLDialogListener voiceXMLDialogListener = new MyVoiceXMLDialogListener(call.getCallingParty());
            UUID requestId = SpeechFactory.createSpeechService().startVoiceXMLDialog(call.getCallingParty(), voiceXMLDialogItem, voiceXMLDialogListener);
            this.logger.info("VoiceXML dialog started with requestId " + requestId.toString());
        }
        catch (URISyntaxException e) {
            this.logger.error("Failed to start VoiceXML dialog", e);
        }
    }

    public class MyVoiceXMLDialogListener
    implements VoiceXMLDialogListener {
        private final Participant participant;

        public MyVoiceXMLDialogListener(Participant participant) {
            this.participant = participant;
        }

        @Override
        public void dialogEvent(UUID requestId, Map<String, Object> names, VoiceXMLDialogCause dialogEvent) {
            SampleVoiceXMLDialog.this.logger.info("VoiceXML dialog completed for " + this.participant);
            this.participant.getCall().allow();
        }
    }
}

