/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api;

import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.collaboration.businessdata.api.AccessControlException;
import com.avaya.collaboration.businessdata.api.Attribute;
import com.avaya.collaboration.businessdata.api.ClusterNotFoundException;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.zephyr.platform.dm.AusPlatformServiceDM;
import com.avaya.zephyr.platform.dm.ZephyrDM;

public class AttributeImpl
implements Attribute {
    private String clusterName;
    private String serviceName;
    private String attributeName;
    private Attribute.SCOPE scope = Attribute.SCOPE.GLOBAL;

    public Attribute clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public Attribute serviceName(String serviceName) throws AccessControlException {
        this.serviceName = serviceName;
        return this;
    }

    public Attribute attributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    public Attribute scope(Attribute.SCOPE scope) {
        this.scope = scope;
        return this;
    }

    public String getValue() throws IllegalArgumentException {
        if (this.scope.equals((Object)Attribute.SCOPE.CLUSTER)) {
            return this.getClusterScopeAttributeValue();
        }
        return null;
    }

    public String toString() {
        return "Attribute Info [cluster name : " + this.clusterName + ", service name : " + this.serviceName + ", attribute name : " + this.attributeName + ", scope : " + this.scope.toString() + "]";
    }

    private String getClusterScopeAttributeValue() {
        BusinessLogicDM dm;
        String attributeValue = null;
        if (this.clusterName == null) {
            dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
            this.clusterName = dm.getClusterAttributeDAO().getClusterName();
        }
        dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
        try {
            attributeValue = dm.getServiceAttributeOnCluster(this.clusterName, this.serviceName, this.attributeName);
        }
        catch (ClusterNotFoundException e) {
            throw new IllegalArgumentException("Invalid value for cluster name " + this.clusterName, e);
        }
        catch (ServiceNotFoundException e) {
            throw new IllegalArgumentException("Invalid value for service name " + this.serviceName, e);
        }
        catch (NoAttributeFoundException e) {
            throw new IllegalArgumentException("Invalid value for attribute name " + this.attributeName, e);
        }
        catch (AccessControlException e) {
            throw new IllegalArgumentException("Insufficient permissions to retrieve attribute value for attribute name : " + this.attributeName, e);
        }
        return attributeValue;
    }
}

