/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api.objectapi;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DigitMapRow {
    private final long id;
    private final short min;
    private final short max;
    private final byte[] digits;
    private final String description;
    private final long templateId;
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private byte[] width = null;
    private final boolean isRange;

    public DigitMapRow(long id, short min, short max, String digits, String description, long templateId) {
        this.id = id;
        this.description = description;
        this.templateId = templateId;
        if (digits == null) {
            this.digits = null;
            this.min = 0;
            this.max = 0;
            this.isRange = false;
        } else {
            this.digits = digits.getBytes(CHARSET);
            short length = (short)digits.indexOf(58);
            if (length == -1 || 2 * length + 1 != digits.length()) {
                this.min = min;
                this.max = max;
                this.isRange = false;
            } else {
                this.min = length;
                this.max = length;
                this.isRange = true;
            }
        }
    }

    public DigitMapRow(short length, String digits, DigitMapRow row) {
        this(row.id, length, length, digits, row.description, row.templateId);
    }

    public long getId() {
        return this.id;
    }

    public short getMin() {
        return this.min;
    }

    public short getMax() {
        return this.max;
    }

    public String getDigits() {
        return this.digits == null ? null : new String(this.digits, CHARSET);
    }

    public boolean isRange() {
        return this.isRange;
    }

    public String getDescription() {
        return this.description;
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public byte[] getWidth(boolean computeWidth) {
        byte[] returnWidth = null;
        if (computeWidth) {
            this.computeWidth();
        }
        if (this.width != null) {
            returnWidth = Arrays.copyOf(this.width, this.width.length);
        }
        return returnWidth;
    }

    public synchronized void computeWidth() {
        if (this.width == null) {
            if (!this.isRange) {
                int i;
                StringBuilder s = new StringBuilder("1");
                for (i = this.min; i < this.max; ++i) {
                    s.append("1");
                }
                for (i = this.digits.length; i < this.min; ++i) {
                    s.append("0");
                }
                for (i = 1; i < this.digits.length; ++i) {
                    if (this.digits[i] != 88) continue;
                    s.append("0");
                }
                BigInteger widthInt = new BigInteger(s.toString());
                if (this.digits[0] == 88) {
                    widthInt = widthInt.multiply(BigInteger.valueOf(12L));
                }
                this.width = widthInt.toByteArray();
            } else {
                int offset = this.digits[0] == 43 ? 1 : 0;
                int length = (this.digits.length - 1) / 2 - offset;
                BigInteger fromInt = new BigInteger(new String(this.digits, offset, length, CHARSET));
                BigInteger widthInt = new BigInteger(new String(this.digits, offset * 2 + length + 1, length, CHARSET));
                widthInt = widthInt.subtract(fromInt);
                widthInt = widthInt.add(BigInteger.valueOf(1L));
                this.width = widthInt.toByteArray();
            }
        }
    }

    public int compareWidth(DigitMapRow otherRow) {
        int len;
        int diff;
        if (this.width == null) {
            this.computeWidth();
        }
        if (otherRow.width == null) {
            otherRow.computeWidth();
        }
        if ((diff = (len = this.width.length) - otherRow.width.length) != 0) {
            return diff;
        }
        for (int i = 0; i < len; ++i) {
            diff = this.width[i] - otherRow.width[i];
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public List<DigitMapRow> getSubrows() {
        ArrayList<DigitMapRow> rows = new ArrayList<DigitMapRow>();
        if (this.isRange) {
            int diffIndex;
            int length = (this.digits.length - 1) / 2;
            String from = new String(this.digits, 0, length, CHARSET);
            String to = new String(this.digits, length + 1, length, CHARSET);
            for (diffIndex = 0; diffIndex < length && this.digits[diffIndex] == this.digits[diffIndex + length + 1]; ++diffIndex) {
            }
            this.expand(rows, from, to, from.substring(0, diffIndex));
        } else {
            rows.add(this);
        }
        return rows;
    }

    private void expand(List<DigitMapRow> rows, String from, String to, String pattern) {
        short length = (short)from.length();
        if (length == pattern.length() || this.contains(from, to, pattern)) {
            rows.add(new DigitMapRow(length, pattern, this));
            return;
        }
        int lowDigit = from.startsWith(pattern) ? from.charAt(pattern.length()) - 48 : 0;
        int highDigit = to.startsWith(pattern) ? to.charAt(pattern.length()) - 48 : 9;
        for (int digit = lowDigit; digit <= highDigit; ++digit) {
            this.expand(rows, from, to, pattern + digit);
        }
    }

    public boolean contains(String from, String to, String pattern) {
        int patternLength = pattern.length();
        int compare = pattern.compareTo(from.substring(0, patternLength));
        if (compare < 0) {
            return false;
        }
        if (compare == 0 && !from.substring(patternLength).matches("^0*$")) {
            return false;
        }
        compare = pattern.compareTo(to.substring(0, patternLength));
        if (compare > 0) {
            return false;
        }
        return compare != 0 || to.substring(patternLength).matches("^9*$");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitMapRow)) {
            return false;
        }
        DigitMapRow other = (DigitMapRow)object;
        if (this.digits.length != other.digits.length) {
            return false;
        }
        for (int i = 0; i < this.digits.length; ++i) {
            if (this.digits[i] == other.digits[i]) continue;
            return false;
        }
        return this.min == other.min && this.max == other.max;
    }

    public int hashCode() {
        int hash = 23;
        hash = hash * 37 + Arrays.hashCode(this.digits);
        hash = hash * 37 + this.min;
        hash = hash * 37 + this.max;
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("DigitMapRow[id=" + this.id + ": " + new String(this.digits, CHARSET) + "/" + this.min + "/" + this.max);
        if (this.width != null) {
            buf.append(" width=" + new BigInteger(this.width));
        }
        buf.append("]");
        return buf.toString();
    }
}

