/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthenticationDetails;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AuthenticationDetailsDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(AuthenticationDetailsDAO.class);
    private static final String ZR_AUTHENTICATION_DETAILS = "ZR_AUTHENTICATION_DETAILS";
    private static final String GET_AUTHENTICATION_DETAILS = "SELECT ID as ID, AUTHENTICATION_MECHANISM AS AUTHENTICATIONMECHANISM, IS_AUTH_REQUEST_SIGNED AS AUTHREQUESTSINGED, IS_SAML_RESPONSE_SIGNED AS SAMLRESPONSESIGNED, IDP_METADATA AS IDPMETADATA, IS_USERID_USED AS ISUSERIDUSED, ATTRIBUTE_NAME AS ATTRIBUTENAME, MAPPED_ATTRIBUTE AS MAPPEDATTRIBUTE, AUTHENTICATION_CONTEXT AS AUTHENTICATIONCONTEXT FROM ZR_AUTHENTICATION_DETAILS";
    private static final String GET_AUTHENTICATION_DETAILS_BY_ID = "SELECT ID as ID, AUTHENTICATION_MECHANISM AS AUTHENTICATIONMECHANISM, IS_AUTH_REQUEST_SIGNED AS AUTHREQUESTSINGED, IS_SAML_RESPONSE_SIGNED AS SAMLRESPONSESIGNED, IDP_METADATA AS IDPMETADATA, IS_USERID_USED AS ISUSERIDUSED, ATTRIBUTE_NAME AS ATTRIBUTENAME, MAPPED_ATTRIBUTE AS MAPPEDATTRIBUTE, AUTHENTICATION_CONTEXT AS AUTHENTICATIONCONTEXT FROM ZR_AUTHENTICATION_DETAILS WHERE ID=?";
    private Map<Long, AuthenticationDetails> idToAuthenticationDetailsMap = new ConcurrentHashMap<Long, AuthenticationDetails>();
    protected static final List<DMListener> LISTENERS = new CopyOnWriteArrayList<DMListener>();

    protected final ResultSetMapper getAuthenticationDetailsMapperById() {
        return new ResultSetMapper(){

            public AuthenticationDetails mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    AuthenticationDetails authenticationDetails = new AuthenticationDetails(results.getLong("ID"), results.getString("AUTHENTICATIONMECHANISM"), results.getString("IDPMETADATA"), results.getBoolean("AUTHREQUESTSINGED"), results.getBoolean("SAMLRESPONSESIGNED"), results.getString("ATTRIBUTENAME"), results.getString("MAPPEDATTRIBUTE"), results.getString("AUTHENTICATIONCONTEXT"), results.getBoolean("ISUSERIDUSED"));
                    return authenticationDetails;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map idToAuthenticationDetailsMapTmp;
        AuthenticationDetailsMapper authenticationDetailsMapper = new AuthenticationDetailsMapper();
        try {
            Object[] params = new Object[]{};
            idToAuthenticationDetailsMapTmp = (Map)this.dataSource.executeQuery(GET_AUTHENTICATION_DETAILS, params, (Object)authenticationDetailsMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("AuthenticationDetailsDAO init(): Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            if (idToAuthenticationDetailsMapTmp != null) {
                this.idToAuthenticationDetailsMap = idToAuthenticationDetailsMapTmp;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList("zr_authentication_details");
    }

    protected Object getMainCollection() {
        return this.idToAuthenticationDetailsMap;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("AuthenticationDetailsDAO updateDAO(): " + tableEvent));
        }
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null && tableName.equalsIgnoreCase(ZR_AUTHENTICATION_DETAILS)) {
            this.updateAuthenticationDetails(operation, id);
        }
    }

    private void updateAuthenticationDetails(DAOReplicationEvent.OperationType operation, Long id) {
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            this.handleAuthenticationDetailsDelete(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            this.handleAuthenticationDetailsUpdate(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            this.handleAuthenticationDetailsInsert(id);
        }
    }

    private void handleAuthenticationDetailsInsert(Long id) {
        AuthenticationDetails newObject;
        block5: {
            newObject = null;
            try {
                newObject = (AuthenticationDetails)this.dataSource.executeQuery(GET_AUTHENTICATION_DETAILS_BY_ID, new Object[]{id}, (Object)this.getAuthenticationDetailsMapperById());
                if (newObject == null) break block5;
                this.lock.acquireWriteLock();
                try {
                    this.idToAuthenticationDetailsMap.put(id, newObject);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("AuthenticationDetailsDAO handleAuthenticationDetailsInsert(): Error while updating Cache for table ZR_AUTHENTICATION_DETAILS " + e.getMessage()));
            }
        }
        this.updateListeners(null, newObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAuthenticationDetailsUpdate(Long id) {
        AuthenticationDetails oldObject;
        AuthenticationDetails newObject;
        block5: {
            newObject = null;
            oldObject = null;
            try {
                newObject = (AuthenticationDetails)this.dataSource.executeQuery(GET_AUTHENTICATION_DETAILS_BY_ID, new Object[]{id}, (Object)this.getAuthenticationDetailsMapperById());
                oldObject = this.idToAuthenticationDetailsMap.get(id);
                if (newObject == null || oldObject == null) break block5;
                this.lock.acquireWriteLock();
                try {
                    this.idToAuthenticationDetailsMap.remove(id);
                    this.idToAuthenticationDetailsMap.put(id, newObject);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("AuthenticationDetailsDAO handleAuthenticationDetailsUpdate(): Error while updating Cache for table ZR_AUTHENTICATION_DETAILS " + e.getMessage()));
            }
        }
        this.updateListeners(oldObject, newObject);
    }

    private void handleAuthenticationDetailsDelete(Long id) {
        AuthenticationDetails oldObject = null;
        try {
            this.lock.acquireWriteLock();
            oldObject = this.idToAuthenticationDetailsMap.get(id);
            if (oldObject != null) {
                this.idToAuthenticationDetailsMap.remove(id);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.updateListeners(oldObject, null);
    }

    @SMConsole(description="Get authentication details")
    public AuthenticationDetails getAuthenticationDetails() {
        AuthenticationDetails authenticationDetails = new AuthenticationDetails();
        if (this.idToAuthenticationDetailsMap.values() != null && !this.idToAuthenticationDetailsMap.values().isEmpty()) {
            Iterator<AuthenticationDetails> iterator = this.idToAuthenticationDetailsMap.values().iterator();
            authenticationDetails = iterator.next();
        }
        return authenticationDetails;
    }

    public void registerListener(DMListener listener) {
        LISTENERS.add(listener);
    }

    public void removeListener(DMListener listener) {
        LISTENERS.remove(listener);
    }

    protected void updateListeners(Object oldObj, Object newObj) {
        for (DMListener listener : LISTENERS) {
            try {
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                this.log.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                this.log.error((Object)("NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.log.error((Object)"Error is: ", (Throwable)e);
                this.log.error((Object)("Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
        }
    }

    public static class AuthenticationDetailsMapper
    implements ResultSetMapper {
        public Map<Long, AuthenticationDetails> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, AuthenticationDetails> idToAuthenticationDetailsMapTmp = new ConcurrentHashMap<Long, AuthenticationDetails>();
            while (results.next()) {
                Long id = (Long)results.getObject("ID");
                AuthenticationDetails authenticationDetails = new AuthenticationDetails(results.getLong("ID"), results.getString("AUTHENTICATIONMECHANISM"), results.getString("IDPMETADATA"), results.getBoolean("AUTHREQUESTSINGED"), results.getBoolean("SAMLRESPONSESIGNED"), results.getString("ATTRIBUTENAME"), results.getString("MAPPEDATTRIBUTE"), results.getString("AUTHENTICATIONCONTEXT"), results.getBoolean("ISUSERIDUSED"));
                idToAuthenticationDetailsMapTmp.put(id, authenticationDetails);
            }
            if (!idToAuthenticationDetailsMapTmp.isEmpty()) {
                return idToAuthenticationDetailsMapTmp;
            }
            return null;
        }
    }
}

