/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.collaboration.businessdata.api.ClusterNotFoundException;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.common.logging.client.Logger;
import com.avaya.commons.lang.ArgAssert;
import com.avaya.zephyr.encrypt.EncryptDecrypt;
import com.avaya.zephyr.platform.dal.api.objectapi.Cluster;
import com.avaya.zephyr.platform.dal.api.objectapi.ClusterAttribute;
import com.avaya.zephyr.platform.dal.api.objectapi.ClusterProfile;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ClusterAttributeDAO
extends DataAccessObject {
    private static final Logger LOG = AsmLogger.getLogger(ClusterAttributeDAO.class);
    protected static final String PUBLIC_MACHINE_PROVISION = "GridPublicMachineProvision";
    protected static final String ZR_CLUSTER = "zr_cluster";
    protected static final String ZR_CLUSTER_PROFILE = "zr_cluster_profile";
    protected static final String ZR_CLUSTER_PROFILE_ATTRIBUTE = "zr_cluster_profile_attribute";
    protected static final String ZR_MAP_CATTRIBUTE_CLUSTER = "zr_map_cattribute_cluster";
    protected static final String ZR_MAP_SATTRIBUTE_CLUSTER = "zr_map_sattribute_cluster";
    protected static final String getClusters = "select id, name, domain_name, managed_ip_addr, cluster_profile_id, description, cluster_db_enabled, auto_switch_over, fqdn from zr_cluster";
    protected static final String getClusterByID = "select id, name, domain_name, managed_ip_addr, cluster_profile_id, description, cluster_db_enabled, auto_switch_over, fqdn from zr_cluster where id = ?";
    private Map<Long, Cluster> clusterMap = new ConcurrentHashMap<Long, Cluster>();
    protected static final String getClusterProfiles = "select id, name from zr_cluster_profile";
    protected static final String getclusterProfileByID = "select id, name from zr_cluster_profile where id = ?";
    private Map<Long, ClusterProfile> clusterProfileMap = new ConcurrentHashMap<Long, ClusterProfile>();
    protected static final String getClusterProfileAttributes = "select id, name, cluster_profile_id, default_value, cprofile_value from zr_cluster_profile_attribute";
    protected static final String clusterProfileAttributeByID = "select id, name, cluster_profile_id, default_value, cprofile_value from zr_cluster_profile_attribute where id = ?";
    protected static final String getClusterAttributes = "select map_cattr.id, name, encrypted, default_value, cprofile_value, cluster_id, cluster_override_value from zr_cluster_profile_attribute cprofile_attr join zr_map_cattribute_cluster map_cattr on cprofile_attr.id = map_cattr.cattribute_id";
    protected static final String clusterAttributeByAttrMapID = "select map_cattr.id, name, encrypted, default_value, cprofile_value, cluster_id, cluster_override_value from zr_cluster_profile_attribute cprofile_attr join zr_map_cattribute_cluster map_cattr on cprofile_attr.id = map_cattr.cattribute_id where map_cattr.id = ?";
    protected static final String clusterAttributeByAttrID = "select map_cattr.id, name, encrypted, default_value, cprofile_value, cluster_id, cluster_override_value from zr_cluster_profile_attribute cprofile_attr join zr_map_cattribute_cluster map_cattr on cprofile_attr.id = map_cattr.cattribute_id where cprofile_attr.id = ?";
    protected static final String getClusterAusInstances = "select instance.cluster_id,instance.managementaccesspointhostname,instance.lu_order from zr_fsinstance instance,zr_cluster cluster where cluster.id = instance.cluster_id";
    private final Map<Long, ClusterAttribute> clusterAttributeMapTmp;
    private Map<Long, ClusterAttribute> clusterAttributeMap = new ConcurrentHashMap<Long, ClusterAttribute>();
    private Map<Long, Map<String, ClusterAttribute>> clusterIdToAttributeMap;
    private static final List<DMListener> listeners = new CopyOnWriteArrayList<DMListener>();

    public ClusterAttributeDAO() {
        super(true);
        this.clusterAttributeMapTmp = new ConcurrentHashMap<Long, ClusterAttribute>();
        this.clusterIdToAttributeMap = new ConcurrentHashMap<Long, Map<String, ClusterAttribute>>();
    }

    public List<DMListener> getListeners() {
        return listeners;
    }

    public Map<Long, ClusterProfile> getClusterProfileMap() {
        return this.clusterProfileMap;
    }

    public Map<Long, ClusterAttribute> getClusterAttributeMapTmp() {
        return this.clusterAttributeMapTmp;
    }

    public Map<Long, ClusterAttribute> getClusterAttributeMap() {
        return this.clusterAttributeMap;
    }

    protected void setClusterAttributeMap(Map<Long, ClusterAttribute> clusterAttributeMap) {
        this.clusterAttributeMap = clusterAttributeMap;
    }

    public Map<Long, Map<String, ClusterAttribute>> getClusterIdToAttributeMap() {
        return this.clusterIdToAttributeMap;
    }

    public Map<Long, Cluster> getClusterMap() {
        return this.clusterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map clusterIdToAttributeMapTmp;
        Map clusterProfileMapTmp;
        Map clusterMapTmp;
        try {
            Object[] params = new Object[]{};
            clusterMapTmp = (Map)this.dataSource.executeQuery(getClusters, params, (Object)this.getClusterMapper());
            clusterProfileMapTmp = (Map)this.dataSource.executeQuery(getClusterProfiles, params, (Object)this.getClusterProfileMapper());
            clusterIdToAttributeMapTmp = (Map)this.dataSource.executeQuery(getClusterAttributes, params, (Object)this.getClusterAttributeMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.clusterMap = clusterMapTmp == null ? new ConcurrentHashMap() : clusterMapTmp;
            this.clusterProfileMap = clusterProfileMapTmp == null ? new ConcurrentHashMap() : clusterProfileMapTmp;
            this.clusterAttributeMap = this.clusterAttributeMapTmp == null ? new ConcurrentHashMap() : this.clusterAttributeMapTmp;
            this.clusterIdToAttributeMap = clusterIdToAttributeMapTmp == null ? new ConcurrentHashMap() : clusterIdToAttributeMapTmp;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    protected ResultSetMapper getClusterAttributeMapper() {
        return new ResultSetMapper(){

            public Map<Long, Map<String, ClusterAttribute>> mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<Long, Map<String, ClusterAttribute>> clusterIdToAttributeMapTmp = new ConcurrentHashMap<Long, Map<String, ClusterAttribute>>();
                ClusterAttribute clusterAttributeTmp = null;
                while (results.next()) {
                    Long id = results.getLong("id");
                    Long clusterId = results.getLong("cluster_id");
                    String attrName = results.getString("name");
                    clusterAttributeTmp = attrName.equalsIgnoreCase(ClusterAttributeDAO.PUBLIC_MACHINE_PROVISION) ? new ClusterAttribute(id, attrName, results.getBoolean("encrypted"), "true", results.getString("cprofile_value"), clusterId, "true") : new ClusterAttribute(id, attrName, results.getBoolean("encrypted"), results.getString("default_value"), results.getString("cprofile_value"), clusterId, results.getString("cluster_override_value"));
                    if (clusterIdToAttributeMapTmp.get(clusterId) == null) {
                        clusterIdToAttributeMapTmp.put(clusterId, new ConcurrentHashMap());
                    }
                    ((Map)clusterIdToAttributeMapTmp.get(clusterId)).put(attrName, clusterAttributeTmp);
                    ClusterAttributeDAO.this.clusterAttributeMapTmp.put(id, clusterAttributeTmp);
                }
                if (!clusterIdToAttributeMapTmp.isEmpty()) {
                    return clusterIdToAttributeMapTmp;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getClusterAttributeMapperByMapID() {
        return new RSMgetClusterAttributeMapperByMapID();
    }

    protected ResultSetMapper getClusterAttributeMapperByAttrID() {
        return new RSMgetClusterMapperByAttrID();
    }

    protected ResultSetMapper getClusterMapper() {
        return new RSMgetClusterMapper();
    }

    protected ResultSetMapper getClusterMapperByID() {
        return new RSMgetClusterMapperByID();
    }

    protected ResultSetMapper getClusterProfileMapper() {
        return new RSMgetClusterProfileMapper();
    }

    protected ResultSetMapper getClusterProfileMapperByID() {
        return new ResultSetMapper(){

            public ClusterProfile mapResults(ResultSet results) throws SQLException, DMException {
                ClusterProfile clusterProfile = null;
                while (results.next()) {
                    Long id = (Long)results.getObject("id");
                    clusterProfile = new ClusterProfile(id, results.getString("name"));
                }
                if (clusterProfile != null) {
                    return clusterProfile;
                }
                return null;
            }
        };
    }

    public List<String> getDependentTables() {
        return Arrays.asList(ZR_CLUSTER, ZR_CLUSTER_PROFILE, ZR_CLUSTER_PROFILE_ATTRIBUTE, ZR_MAP_CATTRIBUTE_CLUSTER, ZR_MAP_SATTRIBUTE_CLUSTER);
    }

    protected Object getMainCollection() {
        return null;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null) {
            if (tableName.equalsIgnoreCase(ZR_CLUSTER)) {
                this.updateZRCluster(id, operation);
            }
            if (tableName.equalsIgnoreCase(ZR_CLUSTER_PROFILE)) {
                this.updateZRClusterProfile(id, operation);
            }
            if (tableName.equalsIgnoreCase(ZR_CLUSTER_PROFILE_ATTRIBUTE)) {
                this.updateZRClusterAttributeByAttrId(id, operation);
            }
            if (tableName.equalsIgnoreCase(ZR_MAP_CATTRIBUTE_CLUSTER)) {
                this.updateZRClusterAttribute(id, operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateZRCluster(Long id, DAOReplicationEvent.OperationType operation) {
        Cluster oldObject = null;
        Cluster newObject = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            try {
                this.lock.acquireWriteLock();
                oldObject = this.clusterMap.remove(id);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                newObject = (Cluster)this.dataSource.executeQuery(getClusterByID, new Object[]{id}, (Object)this.getClusterMapperByID());
                this.lock.acquireWriteLock();
                try {
                    this.clusterMap.put(id, newObject);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                LOG.error((Object)("Error while updating Cache for table zr_cluster " + e.getMessage()));
            }
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateZRClusterProfile(Long id, DAOReplicationEvent.OperationType operation) {
        ClusterProfile oldObject = null;
        ClusterProfile newObject = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            try {
                this.lock.acquireWriteLock();
                oldObject = this.clusterProfileMap.remove(id);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                newObject = (ClusterProfile)this.dataSource.executeQuery(getclusterProfileByID, new Object[]{id}, (Object)this.getClusterProfileMapperByID());
                this.lock.acquireWriteLock();
                try {
                    this.clusterProfileMap.put(id, newObject);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                LOG.error((Object)("Error while updating Cache for table zr_cluster_profile " + e.getMessage()));
            }
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateZRClusterAttributeByAttrId(Long id, DAOReplicationEvent.OperationType operation) {
        block8: {
            ClusterAttribute oldObject = null;
            ArrayList newObjects = null;
            if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
                try {
                    newObjects = (ArrayList)this.dataSource.executeQuery(clusterAttributeByAttrID, new Object[]{id}, (Object)this.getClusterAttributeMapperByAttrID());
                    if (newObjects == null) break block8;
                    for (ClusterAttribute object : newObjects) {
                        if (this.clusterIdToAttributeMap.get(object.getClusterID()) != null) {
                            oldObject = this.clusterIdToAttributeMap.get(object.getClusterID()).get(object.getAttributeName());
                        }
                        try {
                            this.lock.acquireWriteLock();
                            this.clusterAttributeMap.put(object.getId(), object);
                            this.clusterIdToAttributeMap.get(object.getClusterID()).put(object.getAttributeName(), object);
                        }
                        finally {
                            this.lock.releaseWriteLock();
                        }
                        this.updateListeners(oldObject, object);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while updating cache for change in table zr_cluster_profile_attribute For id=" + id + "Exception:" + e.getMessage()));
                    this.reinit();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateZRClusterAttribute(Long id, DAOReplicationEvent.OperationType operation) {
        ClusterAttribute oldObject = null;
        ClusterAttribute newObject = null;
        Long oldClusterId = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            try {
                oldObject = this.clusterAttributeMap.get(id);
                oldClusterId = oldObject.getClusterID();
                try {
                    this.lock.acquireWriteLock();
                    this.clusterAttributeMap.remove(id);
                    this.clusterIdToAttributeMap.get(oldClusterId).remove(oldObject.getAttributeName());
                    if (this.clusterIdToAttributeMap.get(oldClusterId).isEmpty()) {
                        this.clusterIdToAttributeMap.remove(oldClusterId);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while updating cache for change in table zr_map_cattribute_cluster For id=" + id + " Exception:" + e.getMessage()));
                this.reinit();
                return;
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            block17: {
                try {
                    newObject = (ClusterAttribute)this.dataSource.executeQuery(clusterAttributeByAttrMapID, new Object[]{id}, (Object)this.getClusterAttributeMapperByMapID());
                    if (newObject == null) break block17;
                    if (this.clusterIdToAttributeMap.get(newObject.getClusterID()) != null) {
                        oldObject = this.clusterIdToAttributeMap.get(newObject.getClusterID()).get(newObject.getAttributeName());
                    }
                    try {
                        this.lock.acquireWriteLock();
                        this.clusterAttributeMap.put(id, newObject);
                        if (this.clusterIdToAttributeMap.get(newObject.getClusterID()) == null) {
                            this.clusterIdToAttributeMap.put(newObject.getClusterID(), new ConcurrentHashMap());
                        }
                        this.clusterIdToAttributeMap.get(newObject.getClusterID()).put(newObject.getAttributeName(), newObject);
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while updating cache for change in table zr_map_cattribute_cluster For id=" + id + "Exception:" + e.getMessage()));
                    this.reinit();
                    return;
                }
            }
            if (oldObject != null || newObject != null) {
                this.updateListeners(oldObject, newObject);
            }
        }
    }

    protected AusInstanceDAO getAusInstaceDAO() {
        return (AusInstanceDAO)DMFactory.getInstance().getDataMgr(AusInstanceDAO.class);
    }

    protected Boolean isEncryptedAttribute(ClusterAttribute clusterAttr) {
        return clusterAttr.getEncrypted();
    }

    public void removeListener(DMListener listener) {
        listeners.remove(listener);
    }

    public void registerListener(DMListener listener) {
        listeners.add(listener);
    }

    protected void updateListeners(Object oldObject, Object newObject) {
        for (DMListener listener : listeners) {
            try {
                listener.objectChanged(oldObject, newObject);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"Exception is: ", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.error((Object)("updateListeners NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"updateListeners Error is: ", (Throwable)e);
                LOG.error((Object)("updateListeners Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
        }
    }

    @SMConsole(description="Get The Attribute Value For This Cluster")
    public String getClusterAttribute(String attributeName) throws NoAttributeFoundException {
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        if (clusterId == null || this.clusterIdToAttributeMap.get(clusterId) == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            ClusterAttribute clustAttr = this.clusterIdToAttributeMap.get(clusterId).get(attributeName);
            if (clustAttr != null) {
                if (!this.isEncryptedAttribute(clustAttr).booleanValue()) {
                    String string = clustAttr.getOverrideValue();
                    return string;
                }
                throw new UnsupportedOperationException(((Object)((Object)this)).getClass() + ":Attribute name:" + attributeName + " is Encrypted. Please call different method for retrieving encrypted attributes");
            }
            throw new NoAttributeFoundException("No Cluster Attribute " + attributeName + " returned for clusterId:" + clusterId);
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public String getClusterEncryptedAttribute(String attributeName) throws NoAttributeFoundException {
        Long clusterId = null;
        String attrValue = null;
        clusterId = this.getAusInstaceDAO().getMyClusterId();
        if (clusterId == null || this.clusterIdToAttributeMap.get(clusterId) == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            ClusterAttribute clustAttr = this.clusterIdToAttributeMap.get(clusterId).get(attributeName);
            if (clustAttr != null && this.isEncryptedAttribute(clustAttr).booleanValue()) {
                if (clustAttr.getOverrideValue() == null) {
                    String string = null;
                    return string;
                }
                try {
                    attrValue = EncryptDecrypt.decrypt((String)clustAttr.getOverrideValue(), (String)attributeName);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while Decrypting attribute." + e.getMessage()));
                }
                String string = attrValue;
                return string;
            }
            throw new NoAttributeFoundException("No Cluster Attribute " + attributeName + " returned for clusterId:" + clusterId);
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get The Default Attribute Value For This Cluster")
    public String getClusterAttributeDefault(String attributeName) {
        String attrValue = null;
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        if (clusterId == null || this.clusterIdToAttributeMap.get(clusterId) == null) {
            return null;
        }
        if (this.clusterIdToAttributeMap.get(clusterId).get(attributeName) != null) {
            attrValue = this.clusterIdToAttributeMap.get(clusterId).get(attributeName).getDefaultValue();
        }
        return attrValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get The List of Cluster Attributes For This Cluster")
    public ArrayList<String> getClusterAttributeList() {
        ArrayList<String> attributeList = new ArrayList<String>();
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        if (clusterId == null || this.clusterIdToAttributeMap.get(clusterId) == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            attributeList.addAll(this.clusterIdToAttributeMap.get(clusterId).keySet());
            ArrayList<String> arrayList = attributeList;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get The Name of the Cluster for current EDP instance")
    public final String getClusterName() {
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        if (clusterId != null) {
            return this.clusterMap.get(clusterId).getName();
        }
        return null;
    }

    @SMConsole(description="Get The Domain Name of the Cluster for current EDP instance")
    public final String getClusterDomainName() {
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        if (clusterId != null) {
            return this.clusterMap.get(clusterId).getDomainName();
        }
        return null;
    }

    @SMConsole(description="Get The Host of the Cluster for current EDP instance")
    public final String getClusterHost() {
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        if (clusterId != null) {
            return this.clusterMap.get(clusterId).getHost();
        }
        return null;
    }

    @SMConsole(description="Get The Description of the Cluster for current EDP instance")
    public final String getClusterDescription() {
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        if (clusterId != null) {
            return this.clusterMap.get(clusterId).getDescription();
        }
        return null;
    }

    @SMConsole(description="Get The Profile ID of the Cluster for current EDP instance")
    public final Long getClusterProfileID() {
        Long clusterId = this.getAusInstaceDAO().getMyClusterId();
        if (clusterId != null && this.clusterMap.get(clusterId) != null) {
            return this.clusterMap.get(clusterId).getClusterProfileID();
        }
        return null;
    }

    @SMConsole(description="Get The Profile Name of the Cluster for current EDP instance")
    public final String getClusterProfileName() {
        Long profileID = this.getClusterProfileID();
        if (profileID != null) {
            return this.clusterProfileMap.get(profileID).getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Given a cluster name, find cluster ID which has this name.", parameterNames={"clusterName"})
    public Long getClusterIDByClusterName(String clusterName) {
        if (clusterName == null) {
            LOG.fine((Object)"getClusterIDByClusterName: clusterName is null");
            return null;
        }
        try {
            this.lock.acquireReadLock();
            for (Cluster cluster : this.clusterMap.values()) {
                if (!clusterName.equals(cluster.getName())) continue;
                Long l = cluster.getId();
                return l;
            }
            if (LOG.isFineEnabled()) {
                LOG.fine((Object)("getClusterIDByClusterName: Cluster ID not found for cluster:" + clusterName));
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Given a cluster name, find Cluster IP which has this name.", parameterNames={"clusterName"})
    public String getClusterHostByName(String clusterName) throws ClusterNotFoundException {
        ArgAssert.assertNotBlank((String)clusterName);
        try {
            this.lock.acquireReadLock();
            for (Cluster cluster : this.clusterMap.values()) {
                if (!clusterName.equals(cluster.getName())) continue;
                String string = cluster.getHost();
                return string;
            }
            if (LOG.isFineEnabled()) {
                LOG.finest((Object)("getClusterHostByName: Cluster not found for cluster name:" + clusterName));
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        throw new ClusterNotFoundException("getClusterHostByName: No cluster found with name " + clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Given a cluster name, find Cluster FQDN which has this name.", parameterNames={"clusterName"})
    public String getClusterFqdnByClusterName(String clusterName) throws ClusterNotFoundException {
        ArgAssert.assertNotBlank((String)clusterName);
        try {
            this.lock.acquireReadLock();
            for (Cluster cluster : this.clusterMap.values()) {
                if (!clusterName.equals(cluster.getName())) continue;
                String string = cluster.getFqdn();
                return string;
            }
            if (LOG.isFineEnabled()) {
                LOG.finest((Object)("getClusterFqdnByClusterName: Cluster not found for cluster name:" + clusterName));
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        throw new ClusterNotFoundException("getClusterFqdnByClusterName: No cluster found with name " + clusterName);
    }

    public static class RSMgetClusterAttributeMapperByMapID
    implements ResultSetMapper {
        public final ClusterAttribute mapResults(ResultSet results) throws SQLException, DMException {
            ClusterAttribute clusterAttribute = null;
            while (results.next()) {
                Long id = (Long)results.getObject("id");
                clusterAttribute = new ClusterAttribute(id, results.getString("name"), results.getBoolean("encrypted"), results.getString("default_value"), results.getString("cprofile_value"), results.getLong("cluster_id"), results.getString("cluster_override_value"));
            }
            if (clusterAttribute != null) {
                return clusterAttribute;
            }
            return null;
        }
    }

    public static class RSMgetClusterProfileMapper
    implements ResultSetMapper {
        public final Map<Long, ClusterProfile> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, ClusterProfile> clusterProfileMapTmp = new ConcurrentHashMap<Long, ClusterProfile>();
            while (results.next()) {
                Long id = (Long)results.getObject("id");
                clusterProfileMapTmp.put(id, new ClusterProfile(id, results.getString("name")));
            }
            if (!clusterProfileMapTmp.isEmpty()) {
                return clusterProfileMapTmp;
            }
            return null;
        }
    }

    public static class RSMgetClusterMapperByID
    implements ResultSetMapper {
        public final Cluster mapResults(ResultSet results) throws SQLException, DMException {
            Cluster cluster = null;
            while (results.next()) {
                Long id = (Long)results.getObject("id");
                cluster = new Cluster(id, results.getString("name"), results.getString("domain_name"), results.getString("managed_ip_addr"), results.getLong("cluster_profile_id"), results.getString("description"), results.getBoolean("cluster_db_enabled"), results.getBoolean("auto_switch_over"), results.getString("fqdn"));
            }
            if (cluster != null) {
                return cluster;
            }
            return null;
        }
    }

    public static class RSMgetClusterMapper
    implements ResultSetMapper {
        public final Map<Long, Cluster> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, Cluster> clusterMapTmp = new ConcurrentHashMap<Long, Cluster>();
            while (results.next()) {
                Long id = (Long)results.getObject("id");
                clusterMapTmp.put(id, new Cluster(id, results.getString("name"), results.getString("domain_name"), results.getString("managed_ip_addr"), results.getLong("cluster_profile_id"), results.getString("description"), results.getBoolean("cluster_db_enabled"), results.getBoolean("auto_switch_over"), results.getString("fqdn")));
            }
            if (!clusterMapTmp.isEmpty()) {
                return clusterMapTmp;
            }
            return null;
        }
    }

    public static class RSMgetClusterMapperByAttrID
    implements ResultSetMapper {
        public final ArrayList<ClusterAttribute> mapResults(ResultSet results) throws SQLException, DMException {
            ArrayList<ClusterAttribute> clusterAttrList = new ArrayList<ClusterAttribute>();
            ClusterAttribute clusterAttribute = null;
            while (results.next()) {
                Long id = (Long)results.getObject("id");
                clusterAttribute = new ClusterAttribute(id, results.getString("name"), results.getBoolean("encrypted"), results.getString("default_value"), results.getString("cprofile_value"), results.getLong("cluster_id"), results.getString("cluster_override_value"));
                clusterAttrList.add(clusterAttribute);
            }
            return clusterAttrList;
        }
    }
}

