/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dm;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmCommProfileDAO;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.CsDomainDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.SetCommunityDAO;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.objectapi.AsmCommProfile;
import com.avaya.asm.datamgr.objectapi.CsHandle;
import com.avaya.asm.datamgr.objectapi.Instance;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.asm.datamgr.objectapi.UserDomainAOR;
import com.avaya.collaboration.data.api.AddressType;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.client.UStoreNodeIdentifier;
import com.avaya.ustore.client.UserStoreClient;
import com.avaya.ustore.client.UserStoreFactory;
import com.avaya.ustore.client.objects.UserStoreException;
import com.avaya.zephyr.platform.dal.api.objectapi.AusInstance;
import com.avaya.zephyr.platform.dao.AusAssetDAO;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dao.ClusterAttributeDAO;
import com.avaya.zephyr.platform.dao.GlobalParmDAO;
import com.avaya.zephyr.platform.dao.HttpCorsDAO;
import com.avaya.zephyr.platform.dao.NetworkDAO;
import com.avaya.zephyr.platform.dao.ZephyrCsHandleDAO;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class PlatformServiceDM
extends BusinessLogicDM
implements UStoreNodeIdentifier {
    private final Logger log = AsmLogger.getLogger(PlatformServiceDM.class);
    private static final Long DEFAULT_DOMAIN_ID = 50L;
    private static DMFactory factory;
    private static EnumSet<PlatDM> serviceDM;

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return serviceDM;
    }

    public void init() {
        if (ZephyrDM.isMgmtServer()) {
            this.log.info((Object)"Skipping preload of DAOs on management server.");
            return;
        }
        PlatformServiceDM.setServiceDM(EnumSet.range(PlatDM.ASM_COMMPROFILE_DAO, PlatDM.USER_COMMUNITY_DAO));
        if (DMUtilities.isAusInstance()) {
            serviceDM.add(PlatDM.AUS_INSTANCE_DAO);
        } else {
            serviceDM.add(PlatDM.ASM_INSTANCE_DAO);
        }
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (PlatDM dm : serviceDM) {
            if (dm.get().okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + (Object)((Object)dm)));
        }
        this.setStatus(status);
    }

    private static void setServiceDM(EnumSet<PlatDM> newServiceDM) {
        serviceDM = newServiceDM;
    }

    protected CsDomainDAO getCsDomainDAO() {
        return (CsDomainDAO)PlatDM.CS_DOMAIN_DAO.get();
    }

    protected NetworkDAO getNetworkDAO() {
        return (NetworkDAO)PlatDM.NETWORK_DAO.get();
    }

    protected ZephyrCsHandleDAO getCsHandleDAO() {
        return (ZephyrCsHandleDAO)PlatDM.CS_HANDLE_DAO.get();
    }

    protected AsmCommProfileDAO getAsmCommProfileDAO() {
        return (AsmCommProfileDAO)PlatDM.ASM_COMMPROFILE_DAO.get();
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)PlatDM.ASM_INSTANCE_DAO.get();
    }

    protected AusAssetDAO getAusAssetDAO() {
        return (AusAssetDAO)PlatDM.AUS_ASSET_DAO.get();
    }

    protected AusInstanceDAO getAusInstanceDAO() {
        return (AusInstanceDAO)PlatDM.AUS_INSTANCE_DAO.get();
    }

    protected SetCommunityDAO getSetCommunityDAO() {
        return (SetCommunityDAO)PlatDM.SET_COMMUNITY_DAO.get();
    }

    protected SIPEntityDAO getSIPEntityDAO() {
        return (SIPEntityDAO)PlatDM.SIP_ENTITY_DAO.get();
    }

    protected UserCommunityDAO getUserCommunityDAO() {
        return (UserCommunityDAO)PlatDM.USER_COMMUNITY_DAO.get();
    }

    protected UserStoreClient getUStoreClient() {
        return UserStoreFactory.getUserStoreRESTClient();
    }

    @SMConsole(description="Get the primary and secondary SM based on the user and domain and the resulting SIP Comm Profile", parameterNames={"user", "domain"})
    public List<String> getUserHomeSMInstanceIPs(String user, String domain) {
        ArrayList<String> homeInstanceIPs = new ArrayList<String>();
        Long commProfSetId = this.getCommProfileSetId(user, domain);
        if (commProfSetId == null) {
            return homeInstanceIPs;
        }
        Long communityId = this.getSetCommunityDAO().getUserCommunityId(commProfSetId);
        List asmInstanceIdList = this.getUserCommunityDAO().getUserCommAsmInstanceIds(communityId);
        for (Long asmInstanceId : asmInstanceIdList) {
            homeInstanceIPs.add(this.getAsmInstanceDAO().getAsmInstance(asmInstanceId).getManagementAccessPointHostName());
        }
        return homeInstanceIPs;
    }

    @SMConsole(description="Get the primary and secondary SM based on the user and domain and the resulting SIP Comm Profile", parameterNames={"user", "domain"})
    public List<String> getUserHomeASMSipEntityIPs(String user, String domain) {
        ArrayList<String> homeInstanceIPs = new ArrayList<String>();
        List<Long> entityIds = this.getHomeASMSipEntityIds(user, domain);
        for (Long id : entityIds) {
            SIPEntity se = this.getSIPEntityDAO().getSIPEntity(id);
            if (se == null) continue;
            homeInstanceIPs.add(se.getFqdnoripaddr());
        }
        return homeInstanceIPs;
    }

    public Long getCommProfileSetId(String user, String domain) {
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("getCommProfileSetId ENTER : User is " + user + " and domain is " + domain));
        }
        Long csDomainId = this.getCsDomainDAO().getCsDomainId(domain);
        AddressType addressType = this.getAddressType(user);
        if (csDomainId != null) {
            CsHandle csHandle = this.getCsHandleDAO().getHandle(user, domain, addressType, csDomainId);
            if (csHandle != null) {
                this.log.finest((Object)"getCommProfileSetId EXIT : csHandle not null");
                return csHandle.getCsCommProfileSetId();
            }
        } else if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("getCommProfileSetId EXIT : Queried domain '" + domain + "' for user '" + user + "' is not provisioned!"));
        }
        this.log.finest((Object)"getCommProfileSetId EXIT : Returning null");
        return null;
    }

    public Long getCommProfileSetId(String user, String domain, AddressType addressType) {
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("getCommProfileSetId ENTER : User is " + user + ", domain is " + domain + " and addressType = " + addressType));
        }
        Long csDomainId = null;
        if (addressType == null) {
            return this.getCommProfileSetId(user, domain);
        }
        csDomainId = addressType == AddressType.AVAYA_SIP || addressType == AddressType.AVAYA_E164 || addressType == AddressType.AVAYA_XMPP ? this.getCsDomainDAO().getCsDomainId(domain) : DEFAULT_DOMAIN_ID;
        if (csDomainId != null) {
            CsHandle csHandle = this.getCsHandleDAO().getHandle(user, domain, addressType, csDomainId);
            if (csHandle != null) {
                this.log.finest((Object)"getCommProfileSetId EXIT : csHandle not null");
                return csHandle.getCsCommProfileSetId();
            }
        } else if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("getCommProfileSetId : Queried domain '" + domain + "' for user '" + user + "' is not provisioned!"));
        }
        this.log.finest((Object)"getCommProfileSetId EXIT : Returning null");
        return null;
    }

    public List<Long> getHomeASMSipEntityIds(Long commProfileSetId) {
        ArrayList<Long> sipEntityIdList = new ArrayList<Long>();
        Long userCommunityId = this.getSetCommunityDAO().getUserCommunityId(commProfileSetId);
        if (userCommunityId != null) {
            List asmInstanceIdList = this.getUserCommunityDAO().getUserCommAsmInstanceIds(userCommunityId);
            Map instanceMap = this.getAsmInstanceDAO().getAllAsmInstances();
            for (Long instanceId : asmInstanceIdList) {
                sipEntityIdList.add(((Instance)instanceMap.get(instanceId)).getSipEntityId());
            }
        }
        return sipEntityIdList;
    }

    @SMConsole(parameterNames={"user", "domain"}, description="Get IDs of SIPEntities for Session Managers in the User Community for the given user@domain.")
    public List<Long> getHomeASMSipEntityIds(String user, String domain) {
        return this.getHomeASMSipEntityIds(this.getCommProfileSetId(user, domain));
    }

    @SMConsole(description="Get my instance IP address - the match of the provisioned instance (ASM/AUS) against the manangement access point eth (eth0)")
    public String getMyInstanceIP() {
        AusInstance instance;
        String myIp = null;
        myIp = DMUtilities.isAusInstance() ? ((instance = this.getAusInstanceDAO().getMyAusInstance()) == null ? null : instance.getManagementAccessPointHostName()) : ((instance = this.getAsmInstanceDAO().getMyAsmInstance()) == null ? null : instance.getManagementAccessPointHostName());
        return myIp;
    }

    @SMConsole(description="Get my instance IPv6 address - the match of the provisioned instance against the manangement access point eth (eth0)")
    public String getMyInstanceIPv6() {
        AusInstance instance = this.getAusInstanceDAO().getMyAusInstance();
        return instance == null ? null : instance.getManagementAccessPointHostNameIPV6();
    }

    @SMConsole(description="Get data from the User Store basing the query on the user's UStore instances (primary and secondary SMs).  Optionally, the hosts may be inputted to identify which nodes to query.", parameterNames={"user", "domain", "path", "hosts"})
    public String getUserStoreData(String user, String domain, String path, String ... hosts) throws UserStoreException {
        return this.getUserStoreData(new UserDomainAOR(user, domain), path, hosts);
    }

    public String getUserStoreData(UserDomainAOR aor, String path, String ... hosts) throws UserStoreException {
        UserStoreClient client;
        String attribute = null;
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("getUserStoreData: Retrieving data from UStore instances for " + aor + " on path " + path));
        }
        if ((client = this.getUStoreClient()) == null) {
            return null;
        }
        attribute = (String)client.getData(String.class, aor.getUri(), path, hosts);
        return attribute;
    }

    @SMConsole(description="Store some data into the User Store", parameterNames={"user", "domain", "path", "data", "hosts"})
    public void setUserStoreData(String user, String domain, String path, String data, String ... hosts) throws UserStoreException {
        String aorStr = this.createAOR(user, domain);
        UserStoreClient client = this.getUStoreClient();
        if (client == null) {
            return;
        }
        client.storeData(aorStr, path, (Object)data, hosts);
    }

    protected String createAOR(String user, String domain) {
        return user + "@" + domain;
    }

    public AsmCommProfile getAsmCommProfile(Long commProfileSetId) {
        return this.getAsmCommProfileDAO().getAsmCommProfileBySetId(commProfileSetId);
    }

    protected List<String> getRandomizedASMSipEntityList(Integer maxNonSIPEntries) {
        ArrayList<String> seList = new ArrayList<String>();
        for (Instance instance : this.getAsmInstanceDAO().getAllAsmInstances().values()) {
            SIPEntity se;
            if (instance.isBranch() || (se = this.getSIPEntityDAO().getSIPEntity(Long.valueOf(instance.getSipEntityId()))) == null) continue;
            seList.add(se.getFqdnoripaddr());
        }
        Collections.shuffle(seList);
        if (maxNonSIPEntries != null && seList.size() > maxNonSIPEntries) {
            return seList.subList(0, maxNonSIPEntries);
        }
        return seList;
    }

    public Boolean isNonSIPUser(String aorURI) {
        UserDomainAOR aor = new UserDomainAOR(aorURI);
        Long cpSetId = this.getCommProfileSetId(aor.getUser(), aor.getDomain());
        if (cpSetId != null) {
            return this.getSetCommunityDAO().getUserCommunityId(cpSetId) == null;
        }
        return null;
    }

    @SMConsole(description="Get the ordered User Store IP addresses for which the AOR is assigned - SIP Entity.  The aor is of the form 'user@domain'.  If the user is a non-SIP user, maxNonSIPEntries is applied.", parameterNames={"aor", "maxNonSIPEntries "})
    public String[] getOrderedUStoreIPs(String aorURI, Integer maxNonSIPEntries) {
        UserDomainAOR aor = new UserDomainAOR(aorURI);
        List<String> hostList = this.getUserHomeASMSipEntityIPs(aor.getUser(), aor.getDomain());
        if (hostList.size() == 0 && Boolean.TRUE.equals(this.isNonSIPUser(aorURI))) {
            hostList = this.getRandomizedASMSipEntityList(maxNonSIPEntries);
        }
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("getOrderedUStoreIPs: For aorURI=" + aorURI + ", the authoritative SMs are " + hostList));
        }
        return hostList.toArray(new String[0]);
    }

    protected AddressType getAddressType(String user) {
        if (user.charAt(0) == '+') {
            return AddressType.AVAYA_E164;
        }
        return AddressType.AVAYA_SIP;
    }

    static {
        serviceDM = null;
    }

    public static enum PlatDM implements BLDMEnumType
    {
        ASM_COMMPROFILE_DAO(AsmCommProfileDAO.class),
        CS_DOMAIN_DAO(CsDomainDAO.class),
        CS_HANDLE_DAO(ZephyrCsHandleDAO.class),
        SET_COMMUNITY_DAO(SetCommunityDAO.class),
        SIP_ENTITY_DAO(SIPEntityDAO.class),
        AUS_ASSET_DAO(AusAssetDAO.class),
        USER_COMMUNITY_DAO(UserCommunityDAO.class),
        AUS_INSTANCE_DAO(AusInstanceDAO.class),
        ASM_INSTANCE_DAO(AsmInstanceDAO.class),
        AUS_CLUSTER_DAO(ClusterAttributeDAO.class),
        HTTP_CORS_DAO(HttpCorsDAO.class),
        GLOBAL_PARM_DAO(GlobalParmDAO.class),
        NETWORK_DAO(NetworkDAO.class);

        private Class<? extends DataMgr> subDM;

        private PlatDM(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        public DataMgr get() {
            return PlatformServiceDM.getFactory().getDataMgr(this.subDM);
        }
    }
}

