/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.io;

import com.avaya.commons.lang.ArgAssert;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    public static final String NO_FILE_EXTENSION = "";
    public static final String BACKUP_FILE_EXTENSION = "bak";
    public static final String CSV_FILE_EXTENSION = "csv";
    public static final String NSF_FILE_EXTENSION = "nsf";
    public static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String UTF8 = "UTF8";
    public static final char EXTENSION_CHAR = '.';

    private FileUtil() {
    }

    public static void checkIfReadableFile(File file) {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("Can't read file: " + file.getAbsolutePath());
        }
    }

    public static String readUtf8FileToString(String fileSpec) throws IOException {
        ArgAssert.assertNotNull((Object)fileSpec, (String)"fileSpec");
        return FileUtil.readUtf8FileToString(new File(fileSpec));
    }

    public static String readUtf8FileToString(File file) throws IOException {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        return FileUtils.readFileToString((File)file, (String)UTF8);
    }

    public static List<String> readUtf8FileToStringList(String fileSpec) throws IOException {
        ArgAssert.assertNotNull((Object)fileSpec, (String)"fileSpec");
        File file = new File(fileSpec);
        return FileUtil.readUtf8FileToStringList(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readUtf8FileToStringList(File file) throws IOException {
        ArrayList arrayList;
        FileUtil.checkIfReadableFile(file);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            ArrayList listOfLines = Lists.newArrayList();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                listOfLines.add(line);
            }
            arrayList = listOfLines;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return arrayList;
    }

    public static void writeStringToUtf8File(String fileSpec, String fileContents) throws IOException {
        ArgAssert.assertNotNull((Object)fileSpec, (String)"fileSpec");
        File file = new File(fileSpec);
        FileUtil.writeStringToUtf8File(file, fileContents);
    }

    public static void writeStringToUtf8File(File file, String fileContents) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)fileContents, (String)UTF8);
    }

    public static boolean hasExtension(File file) {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        return !NO_FILE_EXTENSION.equals(FileUtil.getFileExtension(file));
    }

    public static String getFileExtension(File file) {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        String fileExtension = NO_FILE_EXTENSION;
        String fileName = file.getName();
        int indexOfLastExtensionChar = fileName.lastIndexOf(46);
        if (indexOfLastExtensionChar >= 0 && indexOfLastExtensionChar < fileName.length() - 1) {
            fileExtension = fileName.substring(indexOfLastExtensionChar + 1).toLowerCase(Locale.US);
        }
        return fileExtension;
    }

    public static File addFileExtension(File file, String fileExtension) {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        ArgAssert.assertNotNull((Object)fileExtension, (String)"fileExtension");
        return new File(file.getPath() + '.' + fileExtension);
    }

    public static void cleanDirQuietly(File directory) {
        ArgAssert.assertNotNull((Object)directory, (String)"directory");
        try {
            FileUtils.cleanDirectory((File)directory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteAllFilesInDirectory(String directoryPath) {
        ArgAssert.assertNotNull((Object)directoryPath, (String)"directoryPath");
        File directory = new File(directoryPath);
        File[] filesInDirectory = directory.listFiles();
        for (int i = 0; i < filesInDirectory.length; ++i) {
            File thisFile = filesInDirectory[i];
            if (!thisFile.isFile()) continue;
            thisFile.delete();
        }
    }

    public static void copyAllFilesToDir(File sourceDir, File destinationDir) throws IOException {
        ArgAssert.assertNotNull((Object)sourceDir, (String)"sourceDir");
        ArgAssert.assertNotNull((Object)destinationDir, (String)"destinationDir");
        File[] sourceFiles = sourceDir.listFiles();
        if (sourceFiles != null) {
            for (int i = 0; i < sourceFiles.length; ++i) {
                File sourceFile = sourceFiles[i];
                if (!sourceFile.isFile()) continue;
                FileUtils.copyFileToDirectory((File)sourceFile, (File)destinationDir);
            }
        }
    }

    public static File getTempDirWithPrefix(String dirNamePrefix, File parentDirectory) throws IOException {
        ArgAssert.assertNotNull((Object)dirNamePrefix, (String)"dirNamePrefix");
        String dirNameSuffix = null;
        File tempFile = File.createTempFile(dirNamePrefix, dirNameSuffix, parentDirectory);
        tempFile.delete();
        return new File(tempFile.getName());
    }

    public static File constructNewFileWithSamePath(File originalFile) {
        ArgAssert.assertNotNull((Object)originalFile, (String)"originalFile");
        return new File(originalFile.getPath());
    }

    public static void checkIfFileExists(File file) throws FileNotFoundException {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        if (!file.exists()) {
            String message = "File not found: " + file.getPath();
            throw new FileNotFoundException(message);
        }
    }

    public static File getRelativeFile(File absoluteFile, File prefixDir) throws IOException {
        File relativeFile;
        FileUtil.checkIfAbsolute(absoluteFile);
        FileUtil.checkIfDirectory(prefixDir);
        FileUtil.checkIfAbsolute(prefixDir);
        FileUtil.checkIfAncestor(prefixDir, absoluteFile);
        String absoluteParentDir = absoluteFile.getParent();
        if (absoluteParentDir.equals(prefixDir.getPath())) {
            relativeFile = new File(absoluteFile.getName());
        } else {
            File relativeParentDir = new File(absoluteParentDir.substring(prefixDir.getPath().length() + File.separator.length()));
            relativeFile = new File(relativeParentDir, absoluteFile.getName());
        }
        return relativeFile;
    }

    public static File getAbsoluteFile(File relativeFile, File prefixDir) throws IOException {
        FileUtil.checkIfRelative(relativeFile);
        FileUtil.checkIfFile(relativeFile);
        FileUtil.checkIfAbsolute(prefixDir);
        FileUtil.checkIfDirectory(prefixDir);
        return new File(prefixDir, relativeFile.getPath());
    }

    public static void copyUtf8FileContents(File sourceFile, File destFile) throws IOException {
        ArgAssert.assertNotNull((Object)sourceFile, (String)"sourceFile");
        ArgAssert.assertNotNull((Object)destFile, (String)"destFile");
        String sourceFileContents = FileUtil.readUtf8FileToString(sourceFile);
        FileUtil.writeStringToUtf8File(destFile, sourceFileContents);
    }

    public static void checkIfDirectory(File dir) {
        ArgAssert.assertNotNull((Object)dir, (String)"dir");
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getPath() + " is not a directory.");
        }
    }

    public static void checkIfFile(File file) {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.getPath() + " is not a directory.");
        }
    }

    public static void checkIfAbsolute(File file) {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException(file.getPath() + " is not absolute.");
        }
    }

    public static void checkIfRelative(File file) {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        if (file.isAbsolute()) {
            throw new IllegalArgumentException(file.getPath() + " is not relative.");
        }
    }

    public static void checkIfAncestor(File prefixDir, File file) {
        FileUtil.checkIfDirectory(prefixDir);
        if (!FileUtil.isAncestor(prefixDir, file)) {
            throw new IllegalArgumentException("'prefix' not a prefix of the absolute file. [prefixDir=" + prefixDir.getPath() + " file=" + file.getName() + "]");
        }
    }

    public static boolean areRelativePathsEqual(String fileSpec1, String fileSpec2, File prefixDir) throws IOException {
        ArgAssert.assertNotNull((Object)fileSpec1, (String)"fileSpec1");
        ArgAssert.assertNotNull((Object)fileSpec2, (String)"fileSpec2");
        File file1 = new File(fileSpec1);
        File file2 = new File(fileSpec2);
        if (file1.isAbsolute()) {
            FileUtil.checkIfAncestor(prefixDir, file1);
        }
        if (file2.isAbsolute()) {
            FileUtil.checkIfAncestor(prefixDir, file2);
        }
        File relativeFile1 = FileUtil.relaxedGetRelativeFile(file1, prefixDir);
        File relativeFile2 = FileUtil.relaxedGetRelativeFile(file2, prefixDir);
        return relativeFile1.getCanonicalPath().equals(relativeFile2.getCanonicalPath());
    }

    public static File relaxedGetRelativeFile(File absoluteFile, File prefixDir) throws IOException {
        ArgAssert.assertNotNull((Object)absoluteFile, (String)"absoluteFile");
        File returnFile = absoluteFile.isAbsolute() ? FileUtil.getRelativeFile(absoluteFile, prefixDir) : FileUtil.constructNewFileWithSamePath(absoluteFile);
        return returnFile;
    }

    public static boolean isAncestor(File prefixDir, File file) {
        ArgAssert.assertNotNull((Object)prefixDir, (String)"prefix");
        ArgAssert.assertNotNull((Object)file, (String)"file");
        try {
            File absolutePrefix = prefixDir.getCanonicalFile();
            File absoluteFile = file.getCanonicalFile();
            if (absoluteFile.getPath().equals(absolutePrefix.getPath())) {
                return false;
            }
            File parent = absoluteFile;
            while (parent.getPath().startsWith(absolutePrefix.getPath())) {
                if (parent.getPath().equals(absolutePrefix.getPath())) {
                    return true;
                }
                parent = parent.getParentFile();
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceFileContents(File file, String contents) throws IOException {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        FileUtil.checkIfFile(file);
        ArgAssert.assertNotNull((Object)contents, (String)"contents");
        file.delete();
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(contents);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    public static File createFile(List<String> pathComponents) {
        Validate.noNullElements(pathComponents, (String)"pathComponents can't be null or have null elements", (Object[])new Object[0]);
        ArgAssert.assertNotEmpty(pathComponents, (String)"pathComponents");
        File file = new File(pathComponents.get(0));
        for (int i = 1; i < pathComponents.size(); ++i) {
            file = new File(file, pathComponents.get(i));
        }
        return file;
    }

    public static File createFile(String ... pathComponents) {
        ArgAssert.assertNotNull((Object)pathComponents, (String)"pathComponents");
        return FileUtil.createFile(Lists.newArrayList((Object[])pathComponents));
    }

    public static File getRootDir(File file) {
        ArgAssert.assertNotNull((Object)file, (String)"file");
        File workingFile = file.getAbsoluteFile();
        while (workingFile.getParentFile() != null) {
            workingFile = workingFile.getParentFile();
        }
        return workingFile;
    }
}

