/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.io;

import com.avaya.commons.lang.ArgAssert;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.TruePredicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IoUtil {
    public static final int READER_HAS_NO_MORE_CHARACTERS = -1;

    private IoUtil() {
    }

    public static String read(Reader reader) throws IOException {
        ArgAssert.assertNotNull((Object)reader, (String)"reader");
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder contentsAsString = new StringBuilder();
        int charAsInt = ((Reader)bufferedReader).read();
        while (-1 != charAsInt) {
            contentsAsString.append((char)charAsInt);
            charAsInt = ((Reader)bufferedReader).read();
        }
        return contentsAsString.toString();
    }

    public static List<String> readAllLines(Reader reader) throws IOException {
        ArgAssert.assertNotNull((Object)reader, (String)"reader");
        return IoUtil.readLines(reader, TruePredicate.getInstance());
    }

    public static List<String> readNonBlankLines(Reader reader) throws IOException {
        ArgAssert.assertNotNull((Object)reader, (String)"reader");
        return IoUtil.readLines(reader, new NotBlankPredicate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(Reader reader, Predicate predicate) throws IOException {
        ArrayList arrayList;
        ArgAssert.assertNotNull((Object)reader, (String)"reader");
        ArgAssert.assertNotNull((Object)predicate, (String)"predicate");
        BufferedReader bufferedReader = null;
        try {
            ArrayList lines = Lists.newArrayList();
            bufferedReader = new BufferedReader(reader);
            String line = bufferedReader.readLine();
            while (line != null) {
                if (predicate.evaluate((Object)line)) {
                    lines.add(line);
                }
                line = bufferedReader.readLine();
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return arrayList;
    }

    public static void closeQuietly(Closeable closeable) {
        IoUtil.closeOrLog(closeable, null);
    }

    @Deprecated
    public static void closeOrLog(Closeable closeable, Logger logger) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (logger == null) break block3;
                    logger.log(Level.INFO, "Failed to close " + closeable, e);
                }
            }
        }
    }

    public static Set<File> getAllFiles(File directory, boolean isRecursive) {
        ArgAssert.assertNotNull((Object)directory, (String)"directory");
        Validate.isTrue((boolean)directory.isDirectory(), (String)"Not a directory", (Object[])new Object[0]);
        String[] extensions = null;
        return Sets.newHashSet((Iterable)FileUtils.listFiles((File)directory, extensions, (boolean)isRecursive));
    }

    public static void closeQuietly(ZipFile zipFile) {
        IoUtil.closeOrLog(zipFile, null);
    }

    @Deprecated
    public static void closeOrLog(ZipFile zipFile, Logger logger) {
        block3: {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    if (logger == null) break block3;
                    logger.log(Level.INFO, "Failed to close zip file.", e);
                }
            }
        }
    }

    private static class NotBlankPredicate
    implements Predicate {
        private NotBlankPredicate() {
        }

        public boolean evaluate(Object object) {
            String string = (String)object;
            return StringUtils.isNotBlank((CharSequence)string);
        }
    }
}

