/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.data.api.impl;

import com.avaya.asm.datamgr.DMFactory;
import com.avaya.collaboration.data.api.AddressType;
import com.avaya.collaboration.data.api.EmailType;
import com.avaya.collaboration.data.api.MobileType;
import com.avaya.collaboration.data.api.UserData;
import com.avaya.collaboration.data.dao.UserDataDAO;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import java.util.List;
import java.util.Map;

public class UserDataImpl
implements UserData {
    private Logger log = Logger.getLogger(UserDataImpl.class);

    protected UserDataDAO getUserDataDAO() {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        return dm.getUserDataDAO();
    }

    public Map<String, List<String>> getPhoneNumbers(String enterpriseId) {
        if (enterpriseId == null || enterpriseId.isEmpty()) {
            throw new IllegalArgumentException("Invalid argument : enterpriseId cannot be null or empty");
        }
        this.log.fine((Object)("Requesting phone numbers linked to the user : " + enterpriseId));
        return this.getUserDataDAO().getPhoneNumbersByLoginName(enterpriseId);
    }

    public Map<String, Map<EmailType, List<String>>> getEmails(String enterpriseId) {
        if (enterpriseId == null || enterpriseId.isEmpty()) {
            throw new IllegalArgumentException("Invalid argument : enterpriseId cannot be null or empty");
        }
        this.log.fine((Object)("Requesting email addresses linked to the user : " + enterpriseId));
        return this.getUserDataDAO().getEmailsByLoginName(enterpriseId);
    }

    public Map<MobileType, List<String>> getMobileNumbers(String enterpriseId) {
        if (enterpriseId == null || enterpriseId.isEmpty()) {
            throw new IllegalArgumentException("Invalid argument : enterpriseId cannot be null or empty");
        }
        return this.getUserDataDAO().getMobileNumbers(enterpriseId);
    }

    public String getTenantID(String enterpriseId) {
        if (enterpriseId == null || enterpriseId.isEmpty()) {
            throw new IllegalArgumentException("Invalid argument : enterpriseId cannot be null or empty");
        }
        this.log.fine((Object)("Requesting tenant id belonged to the user : " + enterpriseId));
        return this.getUserDataDAO().getTenantID(enterpriseId);
    }

    public String getLoginNameByPhoneNumber(String phoneNumber) {
        this.log.fine((Object)("Searching login name for the phone number  : " + phoneNumber));
        return this.getUserDataDAO().getLoginNameByPhoneNumber(phoneNumber);
    }

    public String getLoginNameByParticipant(String participantHandle, String participantDomain) {
        this.log.fine((Object)("Requesting login name for the participant : " + participantHandle));
        return this.getUserDataDAO().getLoginNameByParticipant(participantHandle, participantDomain);
    }

    public Map<String, Map<AddressType, List<String>>> getAllCommunicationAddresses(String enterpriseId) {
        if (enterpriseId == null || enterpriseId.isEmpty()) {
            throw new IllegalArgumentException("Invalid argument : enterpriseId cannot be null or empty");
        }
        this.log.fine((Object)("Requesting all communication addresses belonged to the user : " + enterpriseId));
        return this.getUserDataDAO().getAllCommunicationAddresses(enterpriseId);
    }
}

