/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api;

import com.avaya.asm.datamgr.DMFactory;
import com.avaya.collaboration.businessdata.api.ServiceLicenseData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import java.util.Map;

public class ServiceLicenseDataImpl
implements ServiceLicenseData {
    private Logger log = Logger.getLogger(ServiceLicenseData.class);
    private String serviceName = null;
    private String serviceVersion = null;

    public ServiceLicenseDataImpl() {
    }

    public ServiceLicenseDataImpl(String name) {
        this.serviceName = name;
    }

    public ServiceLicenseDataImpl(String name, String release) {
        this.serviceName = name;
        this.serviceVersion = release;
    }

    public String getServiceName() throws ServiceNotFoundException {
        return this.serviceName;
    }

    public String getServiceVersion() throws ServiceNotFoundException {
        return this.serviceVersion;
    }

    public Boolean hasValidToken() throws ServiceNotFoundException {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        Boolean serviceToken = false;
        serviceToken = dm.hasValidToken(this.serviceName, this.serviceVersion);
        if (this.log.isFineEnabled()) {
            this.log.finer((Object)("Token: " + serviceToken + " Service: " + this.serviceName + " Version: " + this.serviceVersion));
        }
        if (serviceToken == null) {
            this.log.warn((Object)("Token not found for Service: " + this.serviceName + " Version: " + this.serviceVersion));
        }
        return serviceToken;
    }

    public Boolean hasValidToken(String serviceName, String serviceVersion) throws ServiceNotFoundException {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        Boolean serviceToken = false;
        serviceToken = dm.hasValidToken(serviceName, serviceVersion);
        if (this.log.isFineEnabled()) {
            this.log.finer((Object)("Token: " + serviceToken + " Service: " + serviceName + " Version: " + serviceVersion));
        }
        if (serviceToken == null) {
            this.log.warn((Object)("Token not found for Service: " + serviceName + " Version: " + serviceVersion));
        }
        return serviceToken;
    }

    public Map<String, Boolean> getTokenStatusForAllVersions(String serviceName) throws ServiceNotFoundException {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        Map<String, Boolean> tokensForService = null;
        tokensForService = dm.getTokenStatusForAllVersions(serviceName);
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)("Tokens: " + tokensForService + " Service: " + serviceName));
        }
        return tokensForService;
    }

    public String getLicenseMode() throws ServiceNotFoundException {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        String licenseMode = null;
        licenseMode = dm.getLicenseMode(this.serviceName, this.serviceVersion);
        if (this.log.isFineEnabled()) {
            this.log.finer((Object)("License mode: " + licenseMode + " Service: " + this.serviceName + " Version: " + this.serviceVersion));
        }
        if (licenseMode == null) {
            this.log.warn((Object)("License mode not found for Service: " + this.serviceName + " Version: " + this.serviceVersion));
            return null;
        }
        return licenseMode;
    }

    public String getLicenseMode(String serviceName, String serviceVersion) throws ServiceNotFoundException {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        String licenseMode = null;
        licenseMode = dm.getLicenseMode(serviceName, serviceVersion);
        if (this.log.isFineEnabled()) {
            this.log.finer((Object)("License mode: " + licenseMode + " Service: " + serviceName + " Version: " + serviceVersion));
        }
        if (licenseMode == null) {
            this.log.warn((Object)("License mode not found for Service: " + serviceName + " Version: " + serviceVersion));
            return null;
        }
        return licenseMode;
    }

    public Map<String, String> getLicenseModeForAllVersions(String serviceName) throws ServiceNotFoundException {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        Map<String, String> licenseModesForService = null;
        licenseModesForService = dm.getLicenseModeForAllVersions(serviceName);
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)("LicenseModes: " + licenseModesForService + " Service: " + serviceName));
        }
        return licenseModesForService;
    }
}

