/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api.objectapi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ServiceAttributes
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ACTIVATED = "activated";
    private boolean activated;
    private Map<String, String> attributes;

    public ServiceAttributes() {
        this.attributes = new HashMap<String, String>();
        this.activated = false;
    }

    public ServiceAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
        this.updateIsActivated();
    }

    public boolean isActivated() {
        return this.activated;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String attr, String value) {
        this.attributes.put(attr, value);
        this.updateIsActivated();
    }

    public void removeAttribute(String attr) {
        this.attributes.remove(attr);
        this.updateIsActivated();
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    private void updateIsActivated() {
        this.activated = "true".equalsIgnoreCase(this.attributes.get(ACTIVATED)) || "1".equalsIgnoreCase(this.attributes.get(ACTIVATED));
    }

    public String toString() {
        return "ServiceAttributes [activated=" + this.activated + ", attributes=" + this.attributes + "]";
    }
}

