/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusTemplate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AusTemplateDAO
extends DataAccessObject {
    protected static final String getAllTemplate = "SELECT id, template_type, template_name FROM zr_template";
    private Map<Long, AusTemplate> templateMap;
    private Map<String, Map<String, Long>> templateTypeNameMap;
    private static final Logger LOG = AsmLogger.getLogger(AusTemplateDAO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map tmpMap;
        HashMap<String, Map<String, Long>> tmpTypeNameMap = new HashMap<String, Map<String, Long>>();
        try {
            tmpMap = (Map)this.dataSource.executeQuery(getAllTemplate, new Object[0], (Object)this.getTemplateMapper());
            for (AusTemplate t : tmpMap.values()) {
                HashMap<String, Long> tmpNameMap = (HashMap<String, Long>)tmpTypeNameMap.get(t.getType());
                if (tmpNameMap == null) {
                    tmpNameMap = new HashMap<String, Long>();
                    tmpTypeNameMap.put(t.getType(), tmpNameMap);
                }
                tmpNameMap.put(t.getName(), t.getId());
            }
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.templateMap = tmpMap;
            this.templateTypeNameMap = tmpTypeNameMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @SMConsole(description="Get all AUS Templates")
    public Map<Long, AusTemplate> getAllTemplates() {
        return this.templateMap;
    }

    public AusTemplate getTemplate(Long id) {
        return this.templateMap.get(id);
    }

    @SMConsole(description="Get an AusTemplate's ID by the template type and name.", parameterNames={"tmplType", "tmplName"})
    public Long getTemplateIdByTypeAndName(String type, String name) {
        Long rtnVal = null;
        Map<String, Long> tmpMap = this.templateTypeNameMap.get(type);
        if (tmpMap != null) {
            rtnVal = tmpMap.get(name);
        }
        return rtnVal;
    }

    protected ResultSetMapper getTemplateMapper() {
        return new ResultSetMapper(){

            public Map<Long, AusTemplate> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, AusTemplate> tmpMap = new HashMap<Long, AusTemplate>();
                while (results.next()) {
                    Long id = (Long)results.getObject("id");
                    tmpMap.put(id, new AusTemplate(id, results.getString("template_type"), results.getString("template_name")));
                }
                return tmpMap;
            }
        };
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        this.reinit();
    }

    public List<String> getDependentTables() {
        return Arrays.asList("zr_template");
    }

    protected Object getMainCollection() {
        return this.templateMap;
    }
}

