/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.HttpCorsByClusterEntry;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dm.utilities.RunHttpCorsFile;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpCorsByClusterDAO
extends DataAccessObject {
    private Map<Long, HttpCorsByClusterEntry> httpCorsByClusterMap;
    private static final Logger log = AsmLogger.getLogger(HttpCorsByClusterDAO.class);
    protected static final String ZR_HTTP_CORS_BY_CLUSTER = "zr_http_cors_by_cluster";
    private static final String getHttpCorsEntries = "SELECT id, fqdn_or_ip, cluster_id From zr_http_cors_by_cluster";
    protected static final String getHttpCorsEntriesByCluster = "SELECT id, fqdn_or_ip, cluster_id From zr_http_cors_by_cluster where cluster_id = ?";
    protected static final String getHttpCorsEntryById = "SELECT id, fqdn_or_ip, cluster_id From zr_http_cors_by_cluster where id = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map httpCorsMapTmp;
        Long myClusterId = this.getAusInstanceDAO().getMyClusterId();
        try {
            httpCorsMapTmp = (Map)this.dataSource.executeQuery(getHttpCorsEntriesByCluster, new Object[]{myClusterId}, (Object)this.getHttpCorsEntriesMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.httpCorsByClusterMap = httpCorsMapTmp;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.updateEntriesInFile();
    }

    protected ResultSetMapper getHttpCorsEntriesMapper() {
        return new ResultSetMapper(){

            public Map<Long, HttpCorsByClusterEntry> mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<Long, HttpCorsByClusterEntry> map = new ConcurrentHashMap<Long, HttpCorsByClusterEntry>();
                while (results.next()) {
                    map.put(results.getLong("id"), new HttpCorsByClusterEntry(results.getLong("id"), results.getString("fqdn_or_ip"), results.getLong("cluster_id")));
                }
                return map;
            }
        };
    }

    protected ResultSetMapper getHttpCorsEntryMapperById() {
        return new ResultSetMapper(){

            public HttpCorsByClusterEntry mapResults(ResultSet results) throws SQLException, DMException {
                HttpCorsByClusterEntry entry = null;
                while (results.next()) {
                    entry = new HttpCorsByClusterEntry(results.getLong("id"), results.getString("fqdn_or_ip"), results.getLong("cluster_id"));
                }
                return entry;
            }
        };
    }

    public List<String> getDependentTables() {
        return Arrays.asList(ZR_HTTP_CORS_BY_CLUSTER);
    }

    protected Object getMainCollection() {
        return this.httpCorsByClusterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDAO(DAOTableEvent tableEvent) {
        Long id = tableEvent.getKey();
        HttpCorsByClusterEntry oldEntry = null;
        HttpCorsByClusterEntry newEntry = null;
        Long myClusterId = this.getAusInstanceDAO().getMyClusterId();
        if (tableEvent.getTableName().equals(ZR_HTTP_CORS_BY_CLUSTER) && tableEvent.getOperation() != null) {
            block9: {
                try {
                    this.lock.acquireWriteLock();
                    if (tableEvent.getOperation().equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                        oldEntry = this.httpCorsByClusterMap.get(id);
                        this.httpCorsByClusterMap.remove(id);
                        break block9;
                    }
                    try {
                        newEntry = (HttpCorsByClusterEntry)this.dataSource.executeQuery(getHttpCorsEntryById, new Object[]{id}, (Object)this.getHttpCorsEntryMapperById());
                        if (newEntry != null && newEntry.getClusterId().equals(myClusterId)) {
                            this.httpCorsByClusterMap.put(id, newEntry);
                        }
                    }
                    catch (DMException e) {
                        log.error((Object)("Error while updating cache for change in table zr_http_cors_by_cluster For id=" + id + " Exception:" + e.getMessage()));
                        this.reinit();
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            if (oldEntry != null && oldEntry.getClusterId().equals(myClusterId) || newEntry != null && newEntry.getClusterId().equals(myClusterId)) {
                this.updateEntriesInFile();
            }
        }
    }

    protected AusInstanceDAO getAusInstanceDAO() {
        return (AusInstanceDAO)DMFactory.getInstance().getDataMgr(AusInstanceDAO.class);
    }

    protected void updateEntriesInFile() {
        RunHttpCorsFile runTask = new RunHttpCorsFile();
        runTask.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get the list of Http Cors Entries for the Cluster which this EDP belongs")
    public List<String> getHttpCorsListForEDPCluster() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            this.lock.acquireReadLock();
            for (HttpCorsByClusterEntry entry : this.httpCorsByClusterMap.values()) {
                list.add(entry.getFqdn());
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return list;
    }
}

