/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.alarming.datamgr;

import com.avaya.asm.alarming.PollingAlarm;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.CACBwLocException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.dao.LocationDAO;
import com.avaya.asm.datamgr.objectapi.Location;
import com.avaya.common.logging.helper.EventCode;

public class CACThresholdAlarm
extends PollingAlarm {
    private static final long ALARM_RETRY_INTERVAL = 60000L;

    @Override
    public Object[] getAlarmEventArgs() {
        CACBwLocException bwLocExc = (CACBwLocException)this.exception;
        return new Object[]{bwLocExc.getLocationName(), this.getPreAlarm_MaxRetryCount(), this.getPoolName(bwLocExc)};
    }

    @Override
    public EventCode getAlarmEventCode() {
        return AsmLogger.OP_CCAC54003;
    }

    @Override
    public Object[] getClearEventArgs() {
        CACBwLocException bwLocExc = (CACBwLocException)this.exception;
        return new Object[]{bwLocExc.getLocationName(), this.getPoolName(bwLocExc)};
    }

    @Override
    public EventCode getClearEventCode() {
        return AsmLogger.OP_CCAC54004;
    }

    @Override
    public Object[] getWarnEventArgs() {
        return null;
    }

    @Override
    public EventCode getWarnEventCode() {
        return null;
    }

    @Override
    public boolean isSingularFailure() {
        return true;
    }

    @Override
    public long getPreAlarm_RetryInterval() {
        return 60000L;
    }

    @Override
    public long getPostAlarm_RetryInterval() {
        return 60000L;
    }

    @Override
    public int getPreAlarm_MaxRetryCount() {
        Long id = ((CACBwLocException)this.exception).getLocationIdentity();
        int type = ((CACBwLocException)this.exception).getErrorType();
        Location loc = this.getLocDAO().getLocation(id);
        if (loc != null) {
            return type == 0 ? loc.getAudioAlarmLatency() : loc.getMultimediaAlarmLatency();
        }
        return 0;
    }

    protected LocationDAO getLocDAO() {
        return (LocationDAO)this.getDMFactory().getDataMgr(LocationDAO.class);
    }

    protected String getPoolName(CACBwLocException bwLocExc) {
        return DMUtilities.getPoolName(bwLocExc.getErrorType(), false, this.getLocDAO().getLocation(bwLocExc.getLocationIdentity()).getCanBorrow());
    }

    protected DMFactory getDMFactory() {
        return DMFactory.getInstance();
    }
}

