/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

import com.avaya.asm.core.AsmConstants;
import com.avaya.asm.core.LocalSettings;
import com.avaya.asm.datamgr.DMFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AsmSettings
extends LocalSettings {
    private static long pollingSubscribesPerSecond = 65L;
    private static long pollingSubscribeBaseRateIncrease = 5L;
    private static long pollingSubscribeRateDecrease = 35L;
    private static long pollingSubscribeOverloadRateIncrease = 5L;

    public static boolean getAlarmImmediately() {
        try {
            return Boolean.parseBoolean(AsmSettings.getLocalParameter("ALARM_IMMEDIATELY"));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean getBulkUpdateASAP() {
        try {
            return Boolean.parseBoolean(AsmSettings.getLocalParameter("BULK_UPDATE_ASAP"));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int getRetainEventsThreshold() {
        try {
            return Integer.parseInt(AsmSettings.getLocalParameter("RETAIN_EVENTS_THRESHOLD"));
        }
        catch (NumberFormatException e) {
            return 100;
        }
    }

    public static long getConnectionPreservedTime() {
        try {
            return 60000L * (long)Integer.parseInt(AsmSettings.getLocalParameter("CONN_PRESERVED_CALL_LENGTH"));
        }
        catch (NumberFormatException e) {
            return 300000L;
        }
    }

    public static long getIPTCMSyncTimeout() {
        try {
            return 60000L * (long)Integer.parseInt(AsmSettings.getLocalParameter("IPTCM_SYNC_TIMEOUT"));
        }
        catch (NumberFormatException e) {
            return 28800000L;
        }
    }

    public static Integer getZonefileBatchSize() {
        try {
            return Integer.parseInt(AsmSettings.getLocalParameter("ZONEFILE_BATCH_SIZE"));
        }
        catch (NumberFormatException e) {
            return 100;
        }
    }

    public static void setDatabaseTimeout(int timeout) {
        DMFactory.getInstance().getDataSource().setQueryTimeout(timeout);
        DMFactory.getInstance().getLocalDataSource().setQueryTimeout(timeout);
    }

    public static void setDatabaseRetries(int retries) {
        DMFactory.getInstance().getDataSource().setQueryRetries(retries);
        DMFactory.getInstance().getLocalDataSource().setQueryRetries(retries);
    }

    public static Long getFragAuditInterval() {
        try {
            return 1000L * Long.parseLong(AsmSettings.getLocalParameter("INTER_CLUSTER_AUDIT_INTERVAL"));
        }
        catch (Exception e) {
            return 3600000L;
        }
    }

    public static Double getFragRejoinThreshold() {
        try {
            return Double.parseDouble(AsmSettings.getLocalParameter("INTER_CLUSTER_AUDIT_REJOIN_THRESHOLD"));
        }
        catch (Exception e) {
            return 0.5;
        }
    }

    public static Long getFullCACAuditInterval() {
        try {
            return 60000L * Long.parseLong(AsmSettings.getLocalParameter("CAC_AUDIT_INTERVAL"));
        }
        catch (Exception e) {
            return 0x6DDD00L;
        }
    }

    public static int getJGroupQueueThreshold() {
        try {
            return Integer.parseInt(AsmSettings.getLocalParameter("JGROUP_QUEUE_THRESHOLD"));
        }
        catch (Exception e) {
            return Integer.parseInt("10000");
        }
    }

    public static int getJGroupSingleHostQueryTimeout() {
        try {
            return Integer.parseInt(AsmSettings.getLocalParameter("JGROUP_SINGLEHOST_QUERY_TIMEOUT"));
        }
        catch (Exception e) {
            return Integer.parseInt("2100");
        }
    }

    public static int getCACRequestTimeLimit() {
        try {
            return Integer.parseInt(AsmSettings.getLocalParameter("CAC_REQUEST_TIME_LIMIT"));
        }
        catch (Exception e) {
            return Integer.parseInt("600");
        }
    }

    public static int getCACThreadCountThreshold() {
        try {
            return Integer.parseInt(AsmSettings.getLocalParameter("CAC_THREAD_COUNT_THRESHOLD"));
        }
        catch (Exception e) {
            return Integer.parseInt("12");
        }
    }

    public static int getCACTotalQueryTimeout() {
        try {
            return Integer.parseInt(AsmSettings.getLocalParameter("CAC_TOTAL_QUERY_TIMEOUT"));
        }
        catch (Exception e) {
            return Integer.parseInt("4000");
        }
    }

    public static int getUsageAuditThreshold() {
        try {
            return Integer.parseInt(AsmSettings.getLocalParameter("USAGE_AUDIT_GSID_THRESHOLD"));
        }
        catch (NumberFormatException e) {
            return 100;
        }
    }

    public static int getUsageAuditTime() {
        try {
            return Integer.parseInt(AsmSettings.getLocalParameter("USAGE_AUDIT_TIME"));
        }
        catch (NumberFormatException e) {
            return 180;
        }
    }

    public static long getUsageAuditTimeout() {
        try {
            return Long.parseLong(AsmSettings.getLocalParameter("USAGE_AUDIT_TIMEOUT"));
        }
        catch (NumberFormatException e) {
            return 100L;
        }
    }

    public static List<String> getLogAttributes(String parameter) {
        try {
            if (!parameter.startsWith("LOG_ATTRIBUTES_")) {
                return null;
            }
            String value = AsmSettings.getLocalParameter(parameter);
            if (value == null || value.toLowerCase(Locale.getDefault()).startsWith("all")) {
                return null;
            }
            ArrayList<String> retVal = new ArrayList<String>();
            for (String attribute : value.split(" ")) {
                if (attribute.equals("")) continue;
                retVal.add(attribute);
            }
            return retVal;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static long getPollingSubscribesPerSecond() {
        return pollingSubscribesPerSecond;
    }

    public static void setPollingSubscribesPerSecond(long newValue) {
        pollingSubscribesPerSecond = newValue;
    }

    public static long getPollingSubscribeBaseRateIncrease() {
        return pollingSubscribeBaseRateIncrease;
    }

    public static void setPollingSubscribeBaseRateIncrease(long newValue) {
        pollingSubscribeBaseRateIncrease = newValue;
    }

    public static long getPollingSubscribeRateDecrease() {
        return pollingSubscribeRateDecrease;
    }

    public static void setPollingSubscribeRateDecrease(long newValue) {
        pollingSubscribeRateDecrease = newValue;
    }

    public static long getPollingSubscribeOverloadRateIncrease() {
        return pollingSubscribeOverloadRateIncrease;
    }

    public static void setPollingSubscribeOverloadRateIncrease(long newValue) {
        pollingSubscribeOverloadRateIncrease = newValue;
    }

    static {
        AsmSettings.loadLocalSettings(AsmConstants.SM_LOCAL_PARAMETERS.class);
    }
}

